<?php
// $Id: mail_wrapper.inc,v 1.3 2007/12/29 18:13:16 z0rac Exp $

function _jbox_mime_header($string, $encoding = 'UTF-8', $indent = 1) {
  if (preg_match('/[^\x20-\x7E]/', $string)) {
    $limit = 76 - strlen('=?'. $encoding .'?B??=');
    $output = '';
    for ($len = drupal_strlen($string); $len > 0; $len -= $c) {
      $c = $len;
      $chunk = base64_encode(jbox_convert_encoding($string, $encoding));
      while ($c > 1 && strlen($chunk) + $indent > $limit) {
        $c = intval($c * 2 / 3);
        $chunk = base64_encode(jbox_convert_encoding(drupal_substr($string, 0, $c), $encoding));
      }
      $output .= ' =?'. $encoding .'?B?'. $chunk ."?=\n";
      $string = drupal_substr($string, $c);
      $indent = 1;
    }
    return trim($output);
  }
  return $string;
}

function drupal_mail_wrapper($message) {
  $encoding = 'ISO-2022-JP';
  $ct = array(
    'MIME-Version' => '1.0',
    'Content-Type' => 'text/plain; charset='. $encoding,
    'Content-Transfer-Encoding' => '7bit'
  );

  if (function_exists('mb_send_mail')) {
    foreach ($message['headers'] as $name => $value) {
      if (isset($ct[$name])) continue;
      $ha[] = $name .': '. $value;
    }
    $lang = mb_language();
    mb_language('ja');
    $ok = mb_send_mail(
      $message['to'],
      $message['subject'],
      str_replace("\r", '', $message['body']),
      join("\n", $ha)
    );
    mb_language($lang);
    return $ok;
  }
  $to = $message['to'];
  $subject = _jbox_mime_header($message['subject'], $encoding, strlen('Subject: '));
  $body = jbox_convert_encoding(str_replace("\r", '', $message['body']), $encoding);
  foreach (array_merge($message['headers'], $ct) as $name => $value) {
    $ha[] = $name .': '. _jbox_mime_header($value, $encoding, strlen($name) + 2);
  }

  if ($sendmail = ini_get('sendmail_path') and $h = popen($sendmail, 'w')) {
    $ok = fwrite($h, 'To: '. $to ."\nSubject: ". $subject ."\n". join("\n", $ha) ."\n");
    $ok = $ok && fwrite($h, "\n". $body ."\n");
    pclose($h);
    return $ok;
  }
  return mail(
    $to,
    str_replace("\n", "\r\n", $subject),
    str_replace("\n", "\r\n", $body),
    str_replace("\n", "\r\n", join("\n", $ha))
  );
}
