<?php
// $Id: update_locale.import.inc,v 1.7.2.1 2008/02/04 21:10:57 z0rac Exp $
// original: locale.inc,v 1.105 2007/01/05 05:32:22 unconed Exp

function _update_locale_import_translations($modules = array(), $lang = array()) {
  $project = array();
  $langs = language_list('enabled', !empty($lang));
  unset($langs[1]['en']);
  $langs = array_keys($langs[1]);
  if ($lang) {
    $langs = array_intersect($langs, (array)$lang);
  }
  if ($langs) {
    if (empty($modules)) {
      $modules = array('module' => array(), 'theme' => array());
    }
    foreach ($modules as $type => $args) {
      $pat = '@^((?:.+/)?'. $type .'s/.+)/@U';
      $q = "SELECT filename FROM {system} WHERE type='%s' AND status=1";
      if ($args) {
        $q .= ' AND name IN ('. implode(',', array_fill(0, count($args), "'%s'")) .')';
      }
      array_unshift($args, $type);
      $result = db_query($q, $args);
      while ($filename = db_result($result)) {
        if (preg_match($pat, $filename, $match)) {
          $project[$match[1]] = $type;
        }
      }
    }
  }
  if ($project) {
    include_once './includes/locale.inc';
    $cvs = _update_locale_import_cvs();
    $sum = array();
    foreach ($langs as $lang) {
      $old = $sum;
      foreach ($project as $component => $type) {
        $name = basename($component);
        $last = _update_locale_last_imported($name, $type, $lang);
        if ($file = _update_locale_import_net_profile($cvs, $name, $type, $lang, $last)) {
          $sum = array_map('_update_locale_imported_sum', $file->count, $sum);
        }
        else {
          foreach (_update_locale_po_files($component, $lang) as $path) {
            if ($result = _update_locale_import_file($path, $lang, $last)) {
              if (!$file || $result->time > $file->time) {
                $file = $result;
              }
              $sum = array_map('_update_locale_imported_sum', $result->count, $sum);
            }
          }
        }
        _update_locale_last_imported($name, $type, $lang, $file);
      }
      if ($sum != $old) {
        _locale_invalidate_js($lang);
        cache_clear_all('locale:'. $lang, 'cache');
      }
    }
    if (array_sum($sum)) {
      menu_rebuild();
      drupal_set_message(t('The translation was successfully imported. There are %number newly created translated strings, %update strings were updated and %delete strings were removed.', array('%number' => $sum[0], '%update' => $sum[1], '%delete' => $sum[2])));
    }
  }
}

function _update_locale_imported_sum($a, $b) {
  return $a + $b;
}

function _update_locale_last_imported($name, $type, $lang) {
  $args = func_get_args();
  if (!isset($args[3])) {
    return db_result(db_query("SELECT ftime FROM {update_locale_file} WHERE name='%s' AND type='%s' AND language='%s'", $name, $type, $lang));
  }
  if ($file = $args[3]) {
    if (count($file->header['Plural-Forms']) == 2) {
      $arg = $file->header['Plural-Forms'];
      $arg[] = $lang;
      db_query("UPDATE {languages} SET plurals=%d, formula='%s' WHERE language='%s'", $arg);
    }
    db_lock_table('update_locale_file');
    db_query("UPDATE {update_locale_file} SET translator='%s',team='%s',ptime=%d,ftime=%d WHERE name='%s' AND type='%s' AND language='%s'", $file->header['Last-Translator'], $file->header['Language-Team'], $file->header['PO-Revision-Date'], $file->time, $name, $type, $lang);
    if (!db_affected_rows()) {
      db_query("INSERT INTO {update_locale_file} (name, type, language, translator, team, ptime, ftime) VALUES ('%s', '%s', '%s', '%s', '%s', %d, %d)", $name, $type, $lang, $file->header['Last-Translator'], $file->header['Language-Team'], $file->header['PO-Revision-Date'], $file->time);
    }
    db_unlock_tables();
  }
}

function _update_locale_import_net_profile($cvs, $name, $type, $lang, $last = 0) {
  $path = 'translations/'. $lang .'/'. $type .'s/'. $name .'.'. $lang .'.po';
  $file = _update_locale_import_cvs($cvs, $path, $lang, $last);
  if (!$file) {
    global $profile;
    $prof = isset($profile) ? $profile : variable_get('install_profile', 'default');
    $file = _update_locale_import_file('profiles/'. $prof .'/'. $path, $lang, $last);
  }
  return $file;
}

function _update_locale_po_files($dirs, $lang) {
  $files = array();
  $dirs = (array)$dirs;
  while ($dir = array_shift($dirs)) {
    $t = '';
    if ($h = opendir($dir)) {
      while ($file = readdir($h)) {
        $path = $dir .'/'. $file;
        if (is_dir($path)) {
          if ($file == 'translations') {
            $t = $path;
          }
          elseif (!in_array($file, array('.', '..', 'CVS', '.svn', '.git'))) {
            $dirs[] = $path;
          }
        }
      }
      closedir($h);
    }
    if ($t != '' and $h = opendir($t)) {
      while ($file = readdir($h)) {
        $path = $t .'/'. $file;
        if (is_file($path) && preg_match('/(^|\.)'. $lang .'\.po$/', $file)) {
          $files[] = $path;
        }
      }
      closedir($h);
    }
  }
  return $files;
}

function _update_locale_import_file($path, $lang, $last = 0) {
  if (is_file($path)) {
    $time = filemtime($path);
    if ($time > $last) {
      $file = (object)array('filename' => $path, 'time' => $time, 'handle' => fopen($path, 'rb'));
      if (_update_locale_import_po($file, $lang)) {
        fclose($file->handle);
        unset($file->handle);
        return $file;
      }
    }
  }
}

function _update_locale_import_cvs() {
  if ($args = func_get_args()) {
    if ($cvs = array_shift($args)) {
      $func = array_shift($cvs);
      return call_user_func_array($func, array_merge($cvs, $args));
    }
  }
  elseif ($repo = variable_get('update_locale_cvs', '')) {
    $cmd = '_update_locale_import_cvsemu';
    if ($h = popen('cvs -v', 'r')) {
      if (fgets($h) !== FALSE) {
        $cmd = '_update_locale_import_cvscmd';
      }
      pclose($h);
    }
    $tag = VERSION;
    $tag = 'DRUPAL-'. $tag[0];
    return array($cmd, $repo, $tag);
  }
}

function _update_locale_import_cvscmd($repo, $tag, $path, $lang, $last = 0) {
  $cvs = 'cvs -z3 -Q -d'. $repo;
  if ($h = popen($cvs .' rlog '. $path, 'r')) {
    $blocks = array();
    $block = array();
    while (($s = fgets($h, 10240)) !== FALSE) {
      $s = _update_locale_cvslog_line($s);
      if (is_string($s)) {
        $block[] = $s;
      }
      else {
        $blocks[] = $block;
        if (!$s) {
          break;
        }
        $block = array();
      }
    }
    pclose($h);
    if (list($rev, $time) = _update_locale_cvslog_parse($tag, $blocks)) {
      if ($time > $last) {
        $file = (object)array(
          'filename' => 'cvs:'. $path,
          'time' => $time,
          'handle' => popen("$cvs co -p -r$rev $path", 'r')
        );
        if (_update_locale_import_po($file, $lang)) {
          pclose($file->handle);
          unset($file->handle);
          return $file;
        }
      }
    }
  }
}

function _update_locale_cvslog_line($s) {
  $s = rtrim($s, "\r\n");
  $n = strspn($s, '=');
  if ($n >= 77 && strlen($s) == $n) {
    return FALSE;
  }
  return strspn($s, '-') == 28 && strlen($s) == 28 ? TRUE : $s;
}

function _update_locale_cvslog_parse($tag, $blocks) {
  if ($hd = array_shift($blocks)) {
    $name = '';
    foreach ($hd as $hd) {
      $pair = explode(':', $hd, 2);
      if ($pair[0][0] == ' ' || $pair[0][0] == "\t") {
        if ($name == 'symbolic names') {
          $pair[0] = trim($pair[0]);
          if ($pair[0] == $tag) {
            $tag = trim($pair[1]);
            break;
          }
        }
      }
      else {
        $name = trim($pair[0]);
        if ($name == 'head' && $tag == 'HEAD') {
          $tag = trim($pair[1]);
          break;
        }
        if ($name == 'description') {
          break;
        }
      }
    }
    if (preg_match('/^\d+(\.\d+)+$/', $tag)) {
      $rev = explode('.', $tag);
      $n = count($rev);
      if ($rev[$n - 2]) {
        $ex = implode('\.', $rev);
      }
      else {
        $ex = implode('\.', array_slice($rev, 0, $n - 2)) .'(|\.'. $rev[$n - 1] .'\.\d+)';
      }
      $rev = '';
      $time = 0;
      foreach ($blocks as $block) {
        if (isset($block[0]) && preg_match('/^revision\s+('. $ex .')\s*$/', $block[0], $match)) {
          if (isset($block[1])) {
            list($name, $body) = explode(':', $block[1], 2);
            if ($name != 'date' && isset($block[2])) {
              list($name, $body) = explode(':', $block[2], 2);
            }
            if ($name == 'date') {
              list($time) = explode(';', $body, 2);
              $time = strtotime($time);
            }
          }
          $rev = $match[1];
          if (!isset($match[2]) || $match[2] != '') {
            break;
          }
        }
      }
      if ($time) {
        return array($rev, $time);
      }
    }
  }
}

function _update_locale_import_cvsemu($repo, $tag, $path, $lang, $last = 0) {
  $cvsroot = explode(':', $repo, 4);
  if ($cvsroot[1] == 'pserver') {
    list($acc, $host) = explode('@', $cvsroot[2], 2);
    list($port, $root) = explode('/', $cvsroot[3], 2);
    $root = '/'. $root;
    if ($h = fsockopen($host, $port ? $port : 2401)) {
      fputs($h, "BEGIN AUTH REQUEST\n$root\n$acc\nA\nEND AUTH REQUEST\n");
      $s = fgets($h);
      if ($s == "I LOVE YOU\n") {
        fputs($h, 'Root '. $root ."\nValid-responses ok error Valid-requests Checked-in Updated Merged Removed M E F\nvalid-requests\n");
        $s = fgets($h, 10240);
        if ($s !== FALSE) {
          $s = fgets($h);
        }
        if ($s == "ok\n") {
          $time = 0;
          $req = 'UseUnchanged';
          $req .= implode("\nGlobal_option ", array('', '-q', '-Q'));
          $req .= implode("\nArgument ", array('', '--', $path));
          $req .= "\nrlog\n";
          fputs($h, $req);
          $blocks = array();
          $block = array();
          $s = fgets($h, 10240);
          for (; $s[1] == ' '; $s = fgets($h, 10240)) {
            if ($s[0] == 'M') {
              $s = _update_locale_cvslog_line(substr($s, 2));
              if (is_string($s)) {
                $block[] = $s;
              }
              else {
                $blocks[] = $block;
                if (!$s) {
                  do {
                    $s = fgets($h, 10240);
                  } while ($s[1] == ' ');
                  break;
                }
                $block = array();
              }
            }
          }
          if ($s == "ok\n" && list($rev, $time) = _update_locale_cvslog_parse($tag, $blocks)) {
            if ($time > $last) {
              $req = trim(implode("\nGlobal_option ", array('', '-n', '-q', '-Q')));
              $req .= implode("\nArgument ", array('', '-npNP', '-r'. $rev, '--', $path));
              $req .= "\nco\n";
              fputs($h, $req);
              $file = (object)array('filename' => 'cvs:'. $path, 'time' => $time, 'handle' => $h, 'fgets' => '_update_locale_import_cvsemu_fgets');
              if (_update_locale_import_po($file, $lang)) {
                fclose($file->handle);
                unset($file->handle, $file->fgets);
                return $file;
              }
            }
          }
        }
      }
      fclose($h);
    }
  }
}

function _update_locale_import_cvsemu_fgets($handle, $size = 1024) {
  $s = fgets($handle, $size + 2);
  for (; $s[1] == ' '; $s = fgets($handle, $size + 2)) {
    if ($s[0] == 'M') {
      return substr($s, 2);
    }
  }
  return FALSE;
}

function _update_locale_import_po(&$file, $lang) {
  include_once './includes/locale.inc';
  if (empty($file->handle)) {
    _locale_import_message('The translation import failed, because the file %filename could not be read.', $file);
    return FALSE;
  }
  if (!ini_get('safe_mode')) {
    set_time_limit(240);
  }
  $file->count = array(0, 0, 0);
  $file->header = array();
  $file->complete = _update_locale_parse_po($file, $lang);
  if ($file->header) {
    if (isset($file->header['PO-Revision-Date'])) {
      $file->header['PO-Revision-Date'] = strtotime($file->header['PO-Revision-Date']);
    }
    if (isset($file->header['Plural-Forms'])) {
      $file->header['Plural-Forms'] = _locale_import_parse_plural_forms($file->header['Plural-Forms'], $file->filename);
    }
  }
  elseif ($file->complete) {
    _locale_import_message('The translation file %filename appears to have a missing or malformed header.', $file);
  }
  $file->header += array(
    'PO-Reveision-Date' => 0,
    'Last-Translator' => '',
    'Language-Team' => '',
    'Plural-Forms' => FALSE
  );
  if (array_sum($file->count)) {
    watchdog('locale', 'Imported %file into %locale: %number new strings added, %update updated and %delete removed.', array('%file' => $file->filename, '%locale' => $lang, '%number' => $file->count[0], '%update' => $file->count[1], '%delete' => $file->count[2]));
  }
  return TRUE;
}

function _update_locale_parse_po(&$file, $lang, $group = 'default') {
  $context = '#';
  $current = array('msgid' => '');   // Current entry being read
  $plural = 0;          // Current plural form
  $lineno = 0;          // Current line

  $fgets = empty($file->fgets) ? 'fgets' : $file->fgets;
  $line = $fgets($file->handle, 10240);
  for (; $line !== FALSE; $line = $fgets($file->handle, 10240)) {
    $lineno++;
    $line = trim(strtr($line, array("\\\n" => '')));
    if ($line == '') continue;

    if ($line[0] == '#') { // A comment
      if ($context == 'msgid' || $context == 'msgid_plural') {
        _locale_import_message('The translation file %filename contains an error: "msgstr" was expected but not found on line %line.', $file, $lineno);
        return FALSE;
      }
      if ($context != '#') {
        _update_locale_db($current, $file, $lang, $group);
        $current = array('msgid' => '');
        $context = '#';
      }
      $current['#'][] = substr($line, 1);
      continue;
    }
    if ($line[0] != '"') { // New entry
      list($st, $line) = explode(' ', $line, 2);
      $line = trim($line);
      if ($st == 'msgid') {
        if ($context == 'msgid' || $context == 'msgid_plural') {
          // Already in this context? Parse error
          _locale_import_message('The translation file %filename contains an error: "msgid" is unexpected on line %line.', $file, $lineno);
          return FALSE;
        }
        if ($context != '#') {
          _update_locale_db($current, $file, $lang, $group);
          $current = array('msgid' => '');
        }
      }
      elseif ($st == 'msgid_plural') {
        if ($context != 'msgid') { // Must be plural form for current entry
          _locale_import_message('The translation file %filename contains an error: "msgid_plural" was expected but not found on line %line.', $file, $lineno);
          return FALSE;
        }
        $current['msgid'] .= "\0";
      }
      elseif ($st == 'msgstr') {
        if ($context != 'msgid') {   // Should come just after a msgid block
          _locale_import_message('The translation file %filename contains an error: "msgstr" is unexpected on line %line.', $file, $lineno);
          return FALSE;
        }
        $plural = 0;
        $current['msgstr'][0] = '';
      }
      elseif (strncmp('msgstr[', $st, 7) == 0 && $st[strlen($st) - 1] == ']') {
        if ($context == '#' || $context == 'msgid' || $context == 'msgstr') {
          // Must come after msgid_plural or msgstr[]
          _locale_import_message('The translation file %filename contains an error: "msgstr[]" is unexpected on line %line.', $file, $lineno);
          return FALSE;
        }
        $plural = substr($st, 7, strlen($st) - 8);
        $current['msgstr'][$plural] = '';
      }
      else {
        $st = FALSE;
      }
      $context = $st;
    }
    // String
    $line = _locale_import_parse_quoted($line);
    if ($context == FALSE || $line === FALSE) {
      _locale_import_message('The translation file %filename contains a syntax error on line %line.', $file, $lineno);
      return FALSE;
    }
    if ($context == '#') {
      _locale_import_message('The translation file %filename contains an error: there is an unexpected string on line %line.', $file, $lineno);
      return FALSE;
    }
    if ($context == 'msgid' || $context == 'msgid_plural') {
      $current['msgid'] .= $line;
    }
    else {
      $current['msgstr'][$plural] .= $line;
    }
  }
  if ($context != '#') { // End of PO file, flush last entry
    if ($context == 'msgid' || $context == 'msgid_plural') {
      _locale_import_message('The translation file %filename ended unexpectedly at line %line.', $file, $lineno);
      return FALSE;
    }
    _update_locale_db($current, $file, $lang, $group);
  }
  return TRUE;
}

function _update_locale_db($msg, &$file, $lang, $group) {
  if ($msg['msgid'] == '') {
    if (empty($file->header) && !empty($msg['msgstr'][0])) {
      $file->header = _locale_import_parse_header($msg['msgstr'][0]);
    }
    return;
  }
  $english = explode("\0", $msg['msgid'], 2);
  if (isset($english[1])) { // Handle a translation for some plural string
    $entries = array_keys($msg['msgstr']);
    if (count($entries) > 2) {
      $english = array_merge($english, array_fill(0, count($entries) - 2, $english[1]));
    }
    $english = array_map('_locale_import_append_plural', $english, $entries);
    $msg['msgstr'] = array_map('_locale_import_append_plural', $msg['msgstr'], $entries);
  }
  $plid = 0;
  foreach ($msg['msgstr'] as $key => $trans) {
    $comment = _locale_import_shorten_comments($msg['#']);
    $tab = db_fetch_object(db_query("SELECT s.*, t.translation FROM {locales_source} s LEFT JOIN {locales_target} t ON s.lid=t.lid AND t.language='%s' WHERE s.source='%s' AND textgroup='%s'", $lang, $english[$key], $group));
    if ($lid = $tab->lid) {
      if ($trans != '') {
        if (!$plid) {
          db_query("UPDATE {locales_source} SET location='%s' WHERE lid=%d", $comment, $lid);
        }
        if (!isset($tab->translation)) {
          db_query("INSERT INTO {locales_target} (lid, language, translation, plid, plural) VALUES (%d, '%s', '%s', %d, %d)", $lid, $lang, $trans, $plid, $key);
          ++$file->count[0];
        }
        elseif ($tab->translation != $trans) {
          if ($tab->translation != '' && variable_get('update_locale_moderation', 1)) {
            db_query("UPDATE {update_locale_string} SET translation='%s' WHERE lid=%d AND language='%s'", $trans, $lid, $lang);
            if (!db_affected_rows()) {
              db_query("INSERT INTO {update_locale_string} (lid, language, translation) VALUES (%d, '%s', '%s')", $lid, $lang, $trans);
            }
          }
          else {
            db_query("UPDATE {locales_target} SET translation='%s' WHERE lid=%d AND language='%s'", $trans, $lid, $lang);
          }
          ++$file->count[$tab->translation != '' ? 1 : 0];
        }
        else {
          db_query("DELETE FROM {update_locale_string} WHERE lid=%d AND language='%s'", $lid, $lang);
          if (db_affected_rows()) {
            ++$file->count[1];
          }
        }
      }
      elseif (isset($tab->translation)) {
        if ($tab->translation != '' && variable_get('update_locale_moderation', 1)) {
          db_query("UPDATE {update_locale_string} SET translation='' WHERE lid=%d AND language='%s'", $lid, $lang);
          if (!db_affected_rows()) {
            db_query("INSERT INTO {update_locale_string} (lid, language, translation) VALUES (%d, '%s', '')", $lid, $lang);
          }
        }
        else {
          db_query("DELETE FROM {locales_target} WHERE lid=%d AND language='%s'", $lid, $lang);
          db_query("DELETE FROM {update_locale_string} WHERE lid=%d AND language='%s'", $lid, $lang);
        }
        ++$file->count[2];
      }
    }
    elseif ($trans != '') {
      db_query("INSERT INTO {locales_source} (location, source, textgroup) VALUES ('%s', '%s', '%s')", $comment, $english[$key], $group);
      if ($lid = db_result(db_query("SELECT lid FROM {locales_source} WHERE source='%s' AND textgroup='%s'", $english[$key], $group))) {
        db_query("INSERT INTO {locales_target} (lid, language, translation, plid, plural) VALUES (%d, '%s', '%s', %d, %d)", $lid, $lang, $trans, $plid, $key);
        ++$file->count[0];
      }
    }
    $plid = $lid;
  }
}

/**
 * batch functions
 */
function _update_locale_import_translations_batch($modules = array(), $lang = array()) {
  $op = array();
  $langs = language_list('enabled', !empty($lang));
  unset($langs[1]['en']);
  $langs = array_keys($langs[1]);
  if ($lang) {
    $langs = array_intersect($langs, (array)$lang);
  }
  if ($langs) {
    $project = array();
    if (empty($modules)) {
      $modules = array('module' => array(), 'theme' => array());
    }
    foreach ($modules as $type => $args) {
      $pat = '@^((?:.+/)?'. $type .'s/.+)/@U';
      $q = "SELECT filename FROM {system} WHERE type='%s' AND status=1";
      if ($args) {
        $q .= ' AND name IN ('. implode(',', array_fill(0, count($args), "'%s'")) .')';
      }
      array_unshift($args, $type);
      $result = db_query($q, $args);
      while ($filename = db_result($result)) {
        if (preg_match($pat, $filename, $match)) {
          $project[$match[1]] = $type;
        }
      }
    }
    foreach ($langs as $lang) {
      foreach ($project as $path => $type) {
        $op[] = array('_update_locale_import_batch', array($path, $type, $lang));
      }
    }
  }
  _update_locale_clear_batch();
  if ($op) {
    $t = get_t();
    $batch = array(
      'operations' => $op,
      'title' => $t('Importing interface translations'),
      'init_message' => $t('Starting import'),
      'error_message' => $t('Error importing interface translations'),
      'file' => './'. drupal_get_path('module', 'update_locale') .'/update_locale.import.inc',
      'finished' => '_update_locale_import_batch_finished'
    );
    batch_set($batch);
  }
}

function _update_locale_import_batch($component, $type, $lang, &$context) {
  $name = basename($component);
  if (empty($context['results'])) {
    $context['results']['count'] = array();
    $context['results']['cvs'] = _update_locale_import_cvs();
  }
  if (empty($context['sandbox'])) {
    $last = _update_locale_last_imported($name, $type, $lang);
    $file = _update_locale_import_net_profile($context['results']['cvs'], $name, $type, $lang, $last);
    if (!$file and $files = _update_locale_po_files($component, $lang)) {
      $file = _update_locale_import_file(array_shift($files), $lang, $last);
      if ($files) {
        $context['sandbox'] = array('files' => $files, 'total' => count($files) + 1, 'last' => $last, 'newest' => $file);
      }
    }
  }
  else {
    $sandbox =& $context['sandbox'];
    $path = array_shift($sandbox['files']);
    $last = $sandbox['last'];
    if ($file = _update_locale_import_file($path, $lang, $last)) {
      if (!$sandbox['newest'] || $file->time > $sandbox['newest']->time) {
        $sandbox['newest'] = $file;
      }
    }
  }
  if ($file) {
    $t = get_t();
    $context['message'] = $t('Imported %file into %locale: %number new strings added, %update updated and %delete removed.', array('%file' => $file->filename, '%locale' => $lang, '%number' => $file->count[0], '%update' => $file->count[1], '%delete' => $file->count[2]));
    if (array_sum($file->count)) {
      $count =& $context['results']['count'];
      $count[$lang] = isset($count[$lang]) ? array_map('_update_locale_imported_sum', $file->count, $count[$lang]) : $file->count;
    }
  }
  if (empty($context['sandbox']['files'])) {
    if (!empty($context['sandbox']['newest'])) {
      $file = $context['sandbox']['newest'];
    }
    _update_locale_last_imported($name, $type, $lang, $file);
  }
  else {
    $context['finished'] = ($context['sandbox']['total'] - count($context['sandbox']['files'])) / $context['sandbox']['total'];
  }
}

function _update_locale_import_batch_finished($success, $results) {
  if ($success && !empty($results['count'])) {
    include_once './includes/locale.inc';
    $sum = array();
    foreach ($results['count'] as $lang => $count) {
      $sum = array_map('_update_locale_imported_sum', $count, $sum);
      _locale_invalidate_js($lang);
      cache_clear_all('locale:'. $lang, 'cache');
    }
    menu_rebuild();
    $t = get_t();
    drupal_set_message($t('The translation was successfully imported. There are %number newly created translated strings, %update strings were updated and %delete strings were removed.', array('%number' => $sum[0], '%update' => $sum[1], '%delete' => $sum[2])));
  }
}

function _update_locale_clear_batch($op = '_locale_batch_import') {
  if ($batch =& batch_get()) {
    $i = isset($batch['current_set']) ? $batch['current_set'] + 1 : 0;
    while (isset($batch['sets'][$i])) {
      if ($batch['sets'][$i]['operations'][0][0] == $op) {
        unset($batch['sets'][$i]);
      }
      $i++;
    }
    if ($batch['sets']) {
      $batch['sets'] = array_values($batch['sets']);
    }
    else {
      $batch = array();
    }
  }
}
