<?php

/*
//  PHP routines for the 'EMOJI' of Japanese cellular phone ver 0.02
//  by Michiya Honda <pia@kreis-net.jp>
//  ver 0.01a 2001/09/05
//  ver 0.02  2001/10/16 Bug Fix
//  Copyright 2001 Michiya Honda All rights reserved.
//  $Id$
//  
//  imode,J-skyG΍
//  $str   G`FbNYBR[hS-JISƂ
//  $mode  G10i\L(F&#63647;)ꍇTRUEA
//         폜Ă܂ꍇFALSE
//  ߂l̕R[hS-JIŜ܂܂ł
//  
//  Special Thanks to :
//    T.Takeuchi <webmaster@bos-project.com>
//    TAMURA Toshihiko <tamura@bitscope.co.jp> (Bug Fix 0.01a -> 0.02)
*/

function imode_encode($str,$mode){
	$converted = '';
	$str_array = unpack("C*",$str);
	
	for($i = 1;$i <= (count($str_array));$i++){
		if (ereg("[\x20-\x7F\xA1-\xDF]",pack("C",$str_array[$i])) == 1) {
			$converted .= pack("C",$str_array[$i]);
		}
		elseif ($str_array[$i] == 0xF8) {
			if (ereg("[\x9F-\xFC]",pack("C",$str_array[$i+1])) == 1) {
				if ($mode) {
					$hex = dechex($str_array[$i]) . dechex($str_array[$i+1]);
					$converted .= '&#' . hexdec($hex) . ';';
				}
			}
			else {
				$converted .= pack("C",$str_array[$i]) . pack("C",$str_array[$i+1]);
			}
			$i++;
		}
		elseif ($str_array[$i] == 0xF9) {
			if (ereg("[\x40-\x49\x50-\x53\x55-\x57\x5B-\x7E\x80-\xB0]",pack("C",$str_array[$i+1])) == 1) {
				if ($mode) {
					$hex = dechex($str_array[$i]) . dechex($str_array[$i+1]);
					$converted .= '&#' . hexdec($hex) . ';';
				}
			}
			else {
				$converted .= pack("C",$str_array[$i]) . pack("C",$str_array[$i+1]);
			}
			$i++;
		}
		else {
			$converted .= pack("C",$str_array[$i]) . pack("C",$str_array[$i+1]);
			$i++;
		}
	}
	
	return $converted;
}

function jsky_encode($str,$mode){
	$converted = '';
	$str_array = unpack("C*",$str);
	
	for($i = 1;$i <= (count($str_array));$i++){
		if( ($str_array[$i] == 0x1B && $str_array[$i+1] == 0x24) || $str_array[$i] == 0x0F){
			if ($mode) {
				$hex =  dechex($str_array[$i]);
				$converted .= '&#' . hexdec($hex) . ';';
			}
			else {
				while ($str_array[$i] != 0x0F) { $i++; }
			}
		}
		else{
			$converted .= pack("C",$str_array[$i]);
		}
	}
	
	return $converted;
}

function imode_decode ($str,$mode) {
	$converted = '';
	$str_array = unpack("C*",$str);

	for($i = 1;$i <= (count($str_array));$i++){
		if($str_array[$i] == 0x26 && $str_array[$i+1] == 0x23) {
			$tmp = '';
			$i += 2;
			while ($str_array[$i] != 0x3B) {
				$tmp .= pack("C",$str_array[$i]);
				$i++;
			}
			if (
			($tmp >= 0xF89F && $tmp <= 0xF8FC) ||
			($tmp >= 0xF940 && $tmp <= 0xF949) ||
			($tmp >= 0xF950 && $tmp <= 0xF953) ||
			($tmp >= 0xF955 && $tmp <= 0xF957) ||
			($tmp >= 0xF95B && $tmp <= 0xF97E) ||
			($tmp >= 0xF980 && $tmp <= 0xF9B0)
			) {
				if ($mode) {
					$dec1 = intval($tmp / 256);
					$dec2 = $tmp % 256;
					$converted .= pack("C2",$dec1,$dec2);
				}
			}
			else {
				$converted .= '&#' . $tmp . ';';
			}
		}
		else{
			$converted .= pack("C",$str_array[$i]);
		}
	}
	
	return $converted;
}

function jsky_decode ($str,$mode) {
	$converted = '';
	$str_array = unpack("C*",$str);
	
	for($i = 1;$i <= (count($str_array));$i++){
		if($str_array[$i] == 0x26 && $str_array[$i+1] == 0x23) {
			$tmp = '';
			$i += 2;
			while ($str_array[$i] != 0x3B) {
				$tmp .= pack("C",$str_array[$i]);
				$i++;
			}
			if (
			($tmp == 0x0F) ||
			($tmp == 0x1B) ||
			($tmp == 0x24)
			) {
				if ($mode) {
					$converted .= pack("C",$tmp);
				}
				else {
					while (!($str_array[$i] == 0x26 && $str_array[$i+1] == 0x23)) {
						$i++;
					}
					while ($str_array[$i] != 0x3B) {
						$i++;
					}
				}
			}
			else {
				$converted .= '&#' . $tmp . ';';
			}
		}
		else{
			$converted .= pack("C",$str_array[$i]);
		}
	}
	
	return $converted;
}

function entities_decode ($str,$mode) {
	$converted = '';
	$str_array = unpack("C*",$str);
	
	for($i = 1;$i <= (count($str_array));$i++){
		if($str_array[$i] == 0x26 && $str_array[$i+1] == 0x23) {
			if ($mode) {
				$tmp = '';
				$i += 2;
				while ($str_array[$i] != 0x3B) {
					$tmp .= pack("C",$str_array[$i]);
					$i++;
				}
				if ($tmp > 255) {
					$dec1 = intval($tmp / 256);
					$dec2 = $tmp % 256;
					$converted .= pack("C2",$dec1,$dec2);
				}
				else {
					$dec = $tmp % 256;
					$converted .= pack("C",$dec);
				}
			}
			else {
				while ($str_array[$i] != 0x3B) { $i++; }
			}
		}
		else{
			$converted .= pack("C",$str_array[$i]);
		}
	}
	
	return $converted;
}

?>
