/*
 * @file cmdlog.c
 * @brief R}hO
 * @author BananaJinn
 * @version $Id: cmdlog.c,v 1.15 2006/05/18 15:23:25 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#if defined(_WIN32)
# include <windows.h>
#else
# include <pwd.h>
# include <unistd.h>
#endif
#if !defined(MACOSX)
# include <malloc.h>
#endif
#include "aspi.h"
#include "cmd.h"
#include "cmdlog.h"
#include "text.h"

#define CMDLOGFILE 0

int
CreateLog(CMDDRIVE *pReader, CMDDRIVE *pWriter, int nWriter)
{
	int ret;
	const BYTE inqcmd[12]={CMD_INQUIRY, 0, 0, 0, 96, 0, 0, 0, 0, 0, 0, 0};
	char path[_MAX_PATH];
#if defined(_WIN32)
	char *fname = "\\EnbanLog.txt";
#else
	char *fname = "/EnbanLog.txt";
#endif
	FILE *fp;
	int nDrive, nCount, nPos;
	DWORD nDumpPos, nDataLen;
	CMDDRIVE *pDrive;
#if defined(_WIN32)
	GetCurrentDirectory(sizeof(path), path);
#else
	struct passwd *pwent;

	pwent = getpwuid(getuid());
	strncpy(path, pwent->pw_dir, sizeof(path));
#endif
	if(strlen(path)+strlen(fname)+1 >= _MAX_PATH){
		return RET_NG;
	}
	strcat(path, fname);
  
	fp = fopen(path, "w");
	if(fp==NULL){
		return RET_NG;
	}
  
	for(nDrive=0; nDrive<1+nWriter; nDrive++){
		if(nDrive==0){
		  if(!REALDRIVE(pReader)){
			continue;
		  }
		  fprintf(fp, MSG_READER_ /*"Ǎu : "*/);
		  pDrive = pReader;
		}
		else{
		  if(!REALDRIVE(&pWriter[nDrive-1])){
			continue;
		  }
		  fprintf(fp, MSG_WRITER_ /*"u%d : "*/, nDrive);
		  pDrive = &pWriter[nDrive-1];
		}

		ret = SendCmd(pDrive, (BYTE *)inqcmd, 96, REQ_DATAIN);
		if(ret!=RET_OK){
			fputs("\n", fp);
		}
		else{
			pDrive->data_buf[8+40] = '\0';
			fprintf(fp, "%s\n", pDrive->data_buf+8);
		}

		if(pDrive->cmdlog==NULL)
			continue;
    
		for(nPos=pDrive->cmdlog_start; ; nPos++){
			if(nPos >= pDrive->cmdlog_size)
				nPos=0;
			fprintf(fp, "[%02d]", nPos);
			fputs("CDB=", fp);
			for(nCount=0; nCount<12; nCount++){
				fprintf(fp, "%02X ", pDrive->cmdlog[nPos].cdb[nCount]);
			}
			fprintf(fp, ": %X/%02X/%02X",
					pDrive->cmdlog[nPos].snskey,
					pDrive->cmdlog[nPos].asc,
					pDrive->cmdlog[nPos].ascq);
			if(pDrive->cmdlog[nPos].repeat>1){
				fprintf(fp, " : repeat %d times", pDrive->cmdlog[nPos].repeat);
			}
			fputs("\n", fp);
			if(pDrive->cmdlog[nPos].datalen>0 && pDrive->cmdlog[nPos].reqflag!=REQ_NODATA &&
			   pDrive->cmdlog[nPos].data!=NULL){
				fprintf(fp, "  DATA%s %ldbyte(s)\n",
						pDrive->cmdlog[nPos].reqflag==REQ_DATAIN ? "IN" : "OUT",
						pDrive->cmdlog[nPos].datalen);
				nDataLen = pDrive->cmdlog[nPos].datalen;
				if(nDataLen > pDrive->cmdlog_maxdatalen)
					nDataLen = pDrive->cmdlog_maxdatalen;
				for(nDumpPos=0; nDumpPos<nDataLen; nDumpPos++){
					if((nDumpPos % 16)==0)
						fputs("  ", fp);
					fprintf(fp, " %02X", pDrive->cmdlog[nPos].data[nDumpPos]);
					if((nDumpPos % 16)==15)
						fputs("\n", fp);
				}
				if((nDumpPos % 16)!=0)
					fputs("\n", fp);
			}
			if(nPos==pDrive->cmdlog_end)
				break;
		}
	}
	fclose(fp);

	return RET_OK;
}


void
CmdLog(CMDDRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag,
       int retcode)
{
	CMDLOG *cmdlog;
	int repeat_flag=0;

#if CMDLOGFILE
	{
		int i;
		DWORD len;
		FILE *fp;
		fp=fopen("cmdlog.txt", "a");
		if(fp!=NULL){
			fprintf(fp, "[%d:%d]", drive->hid, drive->tid);
			for(i=0; i<12; i++){
				fprintf(fp, " %02X", cdb[i]);
			}
			fprintf(fp, " : status=%x:%02x:%02x\n",
				drive->sense_data[2],
				drive->sense_data[12],
				drive->sense_data[13]);
			if(reqflag==REQ_DATAOUT || reqflag==REQ_DATAIN){
				fprintf(fp, "  %s(%ld):", reqflag==REQ_DATAOUT ? "DATAOUT":"DATAIN", buflen);
				len = buflen < 64 ? buflen : 64;
				for(i=0; i<len; i++){
					if((i%16)==0)
						fputs("  ", fp);
					fprintf(fp, " %02X", drive->data_buf[i]);
					if((i%16)==15)
						fputs("\n", fp);
				}
				if((i%16)!=0)
					fputs("\n", fp);
			}
			fclose(fp);
		}
	}
#endif
	if(drive->cmdlog!=NULL){
		if(drive->cmdlog_end<0){
			drive->cmdlog_end++;
		}
		else{
			cmdlog = &drive->cmdlog[drive->cmdlog_end];
			if(memcmp(cmdlog->cdb, cdb, 12)==0 &&
			   cmdlog->snskey == drive->sense_data[2] &&
			   cmdlog->asc == drive->sense_data[12] &&
			   cmdlog->ascq == drive->sense_data[13]){
				if(drive->cmdlog[drive->cmdlog_end].repeat < 65535)
					drive->cmdlog[drive->cmdlog_end].repeat++;
				repeat_flag = 1;
			}
			else{
				drive->cmdlog_end = (drive->cmdlog_end+1) % drive->cmdlog_size;
				if(drive->cmdlog_end==drive->cmdlog_start){
					drive->cmdlog_start = (drive->cmdlog_start+1) % drive->cmdlog_size;
				}
			}
		}

		if(!repeat_flag){
			cmdlog = &drive->cmdlog[drive->cmdlog_end];
			memcpy(cmdlog->cdb, cdb, 12);
			cmdlog->reqflag = reqflag;
			cmdlog->datalen = buflen;
			free(cmdlog->data);
			cmdlog->data = NULL;
			if(cdb[0]!=CMD_WRITE10 &&
			   cdb[0]!=CMD_WRITE12 &&
			   cdb[0]!=CMD_WRITE_AND_VERIFY &&
			   cdb[0]!=CMD_READ6 &&
			   cdb[0]!=CMD_READ10 &&
			   cdb[0]!=CMD_READ12 &&
			   cdb[0]!=CMD_READ_CD &&
			   cdb[0]!=CMD_READ_CD_DA){
				if(buflen>0 &&
				   (reqflag==REQ_DATAOUT ||
					(reqflag==REQ_DATAIN && retcode==RET_OK))){
					if(buflen > drive->cmdlog_maxdatalen)
						buflen = drive->cmdlog_maxdatalen;
					if(cmdlog->data!=NULL)
						free(cmdlog->data);
					cmdlog->data = malloc(buflen);
					memcpy(cmdlog->data, drive->data_buf, buflen);
				}
				else{
					if(cmdlog->data!=NULL){
						free(cmdlog->data);
						cmdlog->data = NULL;
					}
				}
			}
			cmdlog->snskey = drive->sense_data[2] & 0x0f;
			cmdlog->asc    = drive->sense_data[12];
			cmdlog->ascq   = drive->sense_data[13];
			cmdlog->repeat = 1;
		}
	}
}


int CmdLogInit(CMDDRIVE *drive, int cmdlog_size)
{
	CmdLogFree(drive);

	if(cmdlog_size>0){
		drive->cmdlog = (CMDLOG *)malloc(sizeof(CMDLOG)*cmdlog_size);
		if(drive->cmdlog==NULL){
			return RET_NG;

		}
		memset(drive->cmdlog, 0, sizeof(CMDLOG)*cmdlog_size);
		drive->cmdlog_size = cmdlog_size;
		drive->cmdlog_start = 0;
		drive->cmdlog_end = -1;
		drive->cmdlog_maxdatalen = 0x200;
	}

	return RET_OK;
}

void CmdLogFree(CMDDRIVE *drive)
{
	int i;

	if(drive->cmdlog!=NULL){
		for(i=0; i<drive->cmdlog_size; i++){
			if(drive->cmdlog[i].data!=NULL)
				free(drive->cmdlog[i].data);
		}
		free(drive->cmdlog);
		drive->cmdlog = NULL;
	}
}

