/**
 * @file copydisc.c
 * @brief פʣ
 * @author BananaJinn
 * @version $Id: copydisc.c,v 1.51 2006/07/03 15:53:41 bananajinn Exp $
 * ʣ̲
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>
#if defined(WIN32)
# include <io.h>
#else
# include <pwd.h>
# include <unistd.h>
#endif
#if !defined(MACOSX)
# include <malloc.h>
#endif
#include "aspi.h"
#include "struct.h"
#include "cmd.h"
#include "ui.h"
#include "copydisc.h"
#include "cmdlog.h"
#include "netserver.h"
#include "text.h"
#include "log.h"
#include "discinfo.h"

#define SEND_GAPDATA 1


static DWORD g_SpeedData[10];
static int g_NumSpeedData=0;
static int g_MaxSpeedData=sizeof(g_SpeedData)/sizeof(DWORD);

/**
 * Ľ®٥ǡ
 */
static void InitSpeedData()
{
  g_NumSpeedData=0;
}

/**
 * Ľ®٤ȻĤɽ
 * @param[in]	lba	ߵϿɥ쥹
 * @param[in]	rest_blocks  Ĥ֥å
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 */
static void DispSpeed(DWORD lba, DWORD rest_blocks, CMDDRIVE *src, CMDDRIVE *dst)
{
  double blocks_per_sec;
  double curr_speed;
  char info[80];
  DWORD rest_time;
  int ret;
  double buffer_capacity;
  
  if(g_NumSpeedData >= g_MaxSpeedData){
    memmove(&g_SpeedData[0], &g_SpeedData[1],
	    (g_MaxSpeedData-1)*sizeof(DWORD));
    g_NumSpeedData--;
  }
  g_SpeedData[g_NumSpeedData] = lba;
  g_NumSpeedData++;

  if(g_NumSpeedData <= 1){
    return;
  }
  
  blocks_per_sec = (double)(lba-g_SpeedData[0])/(g_NumSpeedData-1);
  if(GetOption()->flags & OPFLG_DVD){
    curr_speed = blocks_per_sec*2048/1024.0/1385;
  }
  else{
    curr_speed = blocks_per_sec*2352/1000.0/176.4;
  }

  sprintf(info, MSG_SPEED_ /* "%.1fx"*/, curr_speed);
  /* Ĥַ׻ */
  rest_time = (DWORD)(0.5+rest_blocks/blocks_per_sec);
  sprintf(info+strlen(info), MSG_REMAINS_ /*" remains=%d:%02d"*/,
	  (int)(rest_time/60), (int)(rest_time%60));
  
  if(REALDRIVE(dst)){
    ret = SendReadBufferCapacity(dst, 0);
    if(ret == RET_OK){
      buffer_capacity = 100-
	100.0*Get4bytes(dst->data_buf+8)/Get4bytes(dst->data_buf+4);
      sprintf(info+strlen(info), MSG_BUFFER_ /* " buffer=%.1f%%" */, buffer_capacity);
    }
  }
  UIDispInfo(info);
  if(src->type == CMDDRVTYPE_NET){
    NAUIDispInfo(&src->u.net, info);
  }
}



/**
 * DVD-RW/+RWեޥå
 * @param[in]	drive	ֹ¤
 * @param[in]	type	եޥåȥ
 * @param[in]	size	եޥåȥ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int FormatDVD(CMDDRIVE *drive, BYTE type, DWORD size)
{
  int ret;
  WORD len, offset;
  struct _FORMATCAPA_HEADER *fch;
  struct _FORMATLIST_HEADER *fh;
  struct _FORMATDESC *fd, fcd;
  const char *message;

  if(!REALDRIVE(drive))
    return RET_OK;

  /* Format Descriptor  */
  ret = SendReadFormatCapacities(drive);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }
  fch = (struct _FORMATCAPA_HEADER *)drive->data_buf;
  len = fch->list_len;
  offset = sizeof(struct _FORMATCAPA_HEADER) + sizeof(struct _FORMATCURMAXDESC);
  for(; offset<len; offset += sizeof(struct _FORMATDESC)){
    fd = (struct _FORMATDESC *)(drive->data_buf + offset);
    if(fd->format_type==type){
      memcpy(&fcd, fd, sizeof(struct _FORMATDESC));
      break;
    }
  }
  if(offset>=len){
    return RET_NG;
  }

  fh = (struct _FORMATLIST_HEADER *)drive->data_buf;
  fd = (struct _FORMATDESC *)(drive->data_buf+sizeof(struct _FORMATLIST_HEADER));
  memset(fh, 0, sizeof(struct _FORMATLIST_HEADER));
  memcpy(fd, &fcd, sizeof(struct _FORMATDESC));
  fh->fov = 1;
  fh->immed = 1;
  Set2bytes(fh->fmtdesc_len, sizeof(struct _FORMATDESC));
  if(Get4bytes(fd->num_blocks) > size)
    Set4bytes(fd->num_blocks, size);
  len = sizeof(struct _FORMATLIST_HEADER) + sizeof(struct _FORMATDESC);
  ret = SendFormatUnit(drive, 1, 0, FUFC_OTHER, len);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }

  if(type==FDFT_QUICK || type==FDFT_QUICKADD || type==FDFT_QUICKGROW)
    message = MSG_MIN_FORMAT;  /* ® */
  else
    message = MSG_FORMATTING;  /*  */
  ret = WaitProgress(drive, message, FALSE);
  if(ret!=RET_OK){
    if(ret==RET_CMDERR)
      DispCommandError(drive);
    return ret;
  }

  return RET_OK;
}

/**
 * ɬפХեޥå
 * @param[in]	drive	ֹ¤
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int Formatting(CMDDRIVE *drive)
{
  int ret;
  struct _DISCINFO *di;

  if(!REALDRIVE(drive)){
    return RET_OK;
  }

  if(drive->disc_type!=DT_DVDPRW){
    return RET_OK;
  }

  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }

  di = (struct _DISCINFO *)drive->data_buf;
  if(di->bgformat_stat != BGFSTAT_NOTFORMATTED){
    return RET_OK;
  }

  ret = FormatDVD(drive, FDFT_DVDPRW, 0xffffffff);
  if(ret!=RET_OK){
    return ret;
  }

  return RET_OK;
}

/**
 * ɬפХǥõ
 * @param[in]	drive	ֹ¤
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int Blanking(CMDDRIVE *drive)
{
  int ret;
  struct _DISCINFO *di;

  if(!REALDRIVE(drive)){
    return RET_OK;
  }

  if(drive->disc_type==DT_DVDRWS || drive->disc_type==DT_DVDRWO){
    if(GetOption()->dao==FALSE){
      /* QuickFormat Τ Blank  */
      return RET_OK;
    }
  }
  if(drive->disc_type==DT_DVDPRW){
    /*  */
    return RET_OK;
  }
  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }

  di = (struct _DISCINFO *)drive->data_buf;
  if(di->disc_status==DISCSTAT_EMPTY){
    return RET_OK;
  }
  if(di->erasable==0){
    /* "Ͽǥ֥󥯤ǤϤʤΤʣ̤Ǥޤ" */
    UIDispMessage(MSG_NOT_BLANK, UIDMT_ERROR);
    return RET_NG;
  }

  /* "Ͽǥ֥󥯤ǤϤޤ󡣹®õޤ?" */
  ret = UIDispMessage(MSG_NOT_BLANK_QUICK_BLANK, UIDMT_QUESTION);
  if(ret==UIDMRET_CANCEL){
    return RET_ABORT;
  }

  ret = BlankDisc(drive, 1);
  if(ret!=RET_OK){
    if(ret==RET_CMDERR){
      DispCommandError(drive);
    }
    return ret;
  }

  return RET_OK;
}

/**
 * Ͽǽ(֥å)
 * @param[in]	drive	ֹ¤
 * @param[out]	size_ret  Ͽǽ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int GetWritableSize(CMDDRIVE *drive, DWORD *size_ret)
{
  int ret;
  WORD track_num;
  struct _DISCINFO *di;
  struct _TRACKINFO *ti;

  *size_ret = 0UL;
  if(!REALDRIVE(drive))
    return RET_OK;

  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }
  di = (struct _DISCINFO *)drive->data_buf;
  track_num = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
  ret = SendReadTrackInfo(drive, track_num);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }
  ti = (struct _TRACKINFO *)drive->data_buf;
  *size_ret = Get4bytes(ti->free_blocks);

  return RET_OK;
}


/**
 * åĤ
 * @param[in]	drive	ֹ¤
 * @param[in]	num_drv	ֹ¤ο
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int CloseSession(CMDDRIVE *drive, int num_drv)
{
  int ret;
  int index;

  if(!REALDRIVE(&drive[0])){
    return RET_OK;
  }

  for(index=0; index<num_drv; index++){
    ret = SendCloseTrackSession(&drive[index], 1, CTST_CLOSESESSION, 0);
    if(ret!=RET_OK){
      DispCommandError(&drive[index]);
      return ret;
    }
  }

  index=num_drv-1;
  ret = WaitProgress(&drive[index], MSG_CLOSE_SESSION/*"åĤ"*/, FALSE);
  if(ret!=RET_OK){
    if(ret==RET_CMDERR)
      DispCommandError(&drive[index]);
    return ret;
  }

  return RET_OK;
}

/**
 * ȥåĤ
 * @param[in]	drive	ֹ¤
 * @param[in]	num_drv	ֹ¤ο
 * @param[in]	track_num  ȥåֹ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int ExecCloseTrack(CMDDRIVE *drive, int num_drv, WORD track_num)
{
  int ret;
  int index;

  if(!REALDRIVE(&drive[0]))
    return RET_OK;

  for(index=0; index<num_drv; index++){
    ret = SendCloseTrackSession(&drive[index], 1, CTST_CLOSETRACK, track_num);
    if(ret!=RET_OK){
      DispCommandError(&drive[index]);
      return ret;
    }
  }

  index = num_drv-1;
  ret = WaitProgress(&drive[index], MSG_CLOSE_TRACK/*"ȥåĤ"*/, FALSE);
  if(ret!=RET_OK){
    if(ret==RET_CMDERR)
      DispCommandError(&drive[index]);
    return ret;
  }

  return RET_OK;
}

/**
 * Ʊ(Synchronize Cache)
 * @param[in]	drive	ֹ¤
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int SyncCache(CMDDRIVE *drive)
{
  int ret;

  if(!REALDRIVE(drive))
    return RET_OK;

  ret = SendSynchronizeCache(drive, 1);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }

  ret = WaitProgress(drive, NULL, FALSE);
  if(ret!=RET_OK){
    if(ret==RET_CMDERR)
      DispCommandError(drive);
    return ret;
  }

  return RET_OK;
}

/**
 * ꥶ֥ȥå
 * @param[in]	drive	ֹ¤
 * @param[in]	size	ꥶ֥(֥å)
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int ReserveTrack(CMDDRIVE *drive, DWORD size)
{
  int ret;

  if(!REALDRIVE(drive))
    return RET_OK;

  ret = SendReserveTrack(drive, size);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }

  return RET_OK;
}


/**
 * Ͽ⡼(WriteParametersPage(05h))
 * @param[in]	drive	ֹ¤
 * @param[in]	discinfo  ǥ
 * @param[in]	track_num ȥåֹ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int SetWriteParametersPage(CMDDRIVE *drive, CPDISCINFO *discinfo,
				  WORD track_num, BOOL sao)
{
  CPTRACKINFO *cpti;
  struct _MODEPAGE05 *mp05;
  WORD sess_num;
  int ret;

  if(!REALDRIVE(drive))
    return RET_OK;

  if(track_num==0)
    track_num=1;
  cpti = &discinfo->trackinfo[track_num-1];
  sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
    (WORD)cpti->trackinfo.session_number_lsb;

  /* ͤɬפʬ񤭴 */
  ret = SendModeSense(drive, MSPC_CURRENT, 5);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }
  mp05 = (struct _MODEPAGE05 *)(drive->data_buf +
				(drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));

  if(DT_DVD_FAMILY(drive->disc_type)){
    mp05->write_type = MP05WT_PACKET;
    mp05->track_mode = MP05TM_DATA;
    mp05->dbtype = MP05DBT_MODE1;
  }
  else{
    mp05->track_mode = cpti->trackinfo.track_mode;
    if(IS_TRACKMODE_DATA(mp05->track_mode)){
      mp05->dbtype = cpti->mode2 ? MP05DBT_MIX : MP05DBT_MODE1;
      mp05->write_type = cpti->trackinfo.packet ? MP05WT_PACKET : MP05WT_TAO;
    }
    else{
      mp05->dbtype = MP05DBT_CDDA_2352;
      mp05->write_type = MP05WT_TAO;
      Set2bytes(mp05->audio_pause_len, cpti->pause_len);
    }
  }

  mp05->BUFE = GetOption()->bufe;
  mp05->test_write = GetOption()->test_write;
  if(discinfo->sessions == sess_num){
    /* ǽå */
    mp05->multi_session = discinfo->disc_stat==DISCSTAT_COMPLETE ? 0 : 3;
  }
  else{
    mp05->multi_session = 3;
  }
  mp05->fp = cpti->trackinfo.fp;
  mp05->copy = cpti->trackinfo.copy;
  mp05->session_format = discinfo->disc_type;
  memcpy(mp05->packet_size, cpti->trackinfo.packet_size, 4);

  if(sao){
    mp05->write_type = MP05WT_SAO;
    mp05->track_mode = MP05TM_DATA;
    mp05->fp = 0;
    Set4bytes(mp05->packet_size, 0UL);
  }

  /* MCN */
  if(strlen(discinfo->media_catalog_number)>0){
    memcpy(mp05->media_cat_number, discinfo->media_catalog_number, 13);
    mp05->mc_val = 1;
  }
  else{
    memset(mp05->media_cat_number, 0, 13);
    mp05->mc_val = 0;
  }
  /* ISRC */
  if(strlen(cpti->isrc)>0){
    memcpy(mp05->ISRC, cpti->isrc, 12);
    mp05->tc_val = 1;
  }
  else{
    memset(mp05->ISRC, 0, 12);
    mp05->tc_val = 0;
  }
  
  ret = SendModeSelect(drive, 5);
  if(ret!=RET_OK){
    DispCommandError(drive);
    return ret;
  }

  return RET_OK;
}


/**
 * VariablePacketΥѥåĹ
 * @param[in]	drive	ɼֹ¤
 * @param[in]	lba	ѥåȳϥɥ쥹
 * @param[out]	size_ret  ѥåȥ(֥å)
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int GetVPSize(CMDDRIVE *drive, DWORD lba, DWORD *size_ret)
{
  BYTE tmp[4];
  DWORD start_lba;
  DWORD len;
  int ret;

  if(!REALDRIVE(drive)){
    if(drive->type == CMDDRVTYPE_ISO){
      return RET_OK;
    }
    else{
      ret = ReadImageFile(&drive->u.image, tmp, 4, TRUE);
      if(ret!=RET_OK)
	return ret;
      *size_ret = Get4bytes(tmp);
    }	  
  }
  else{
    start_lba = lba;
    len = drive->bufsize / 2352;
    ret=RET_OK;
    while(TRUE){
      while(TRUE){
	if(UICheckAbort())
	  return RET_ABORT;
	ret = SendReadCD(drive, lba, len);
	if(ret!=RET_OK)
	  break;
	lba += len;
      }
      if(len==1)
	break;
      len=1;
    }
    *size_ret = lba - start_lba;
  }
  
  return RET_OK;
}

/**
 * VariablePacketΥѥåĹ(᡼եξΤ)
 * @param[in]	drive	ֹ¤
 * @param[in]	size	ѥåĹ(֥å)
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int SetVPSize(CMDDRIVE *drive, DWORD size)
{
  BYTE tmp[4];
  int ret;

  if(!REALDRIVE(drive)){
    if(drive->type == CMDDRVTYPE_ISO){
      return RET_OK;
    }
    else{
      Set4bytes(tmp, size);
      ret = WriteImageFile(&drive->u.image, tmp, 4, TRUE);
      if(ret!=RET_OK)
	return ret;
    }
  }
  
  return RET_OK;
}


/**
 * @brief	READȥ饤(ModePage01h)
 * @param[in]	drive	оݥɥ饤
 * @param[in]	count	ꤹȥ饤
 * @param[out]	current	Υȥ饤
 * @retval	RET_OK	ｪλ
 * @retval	RET_CMDERR	ޥɥ顼
 * @retval	RET_NG	顼
 */
static int SetReadRetryCount(CMDDRIVE *drive, BYTE count, BYTE *current)
{
  int ret;
  struct _MODEPAGE01 *mp01;
  ret = SendModeSense(drive, MSPC_CURRENT, 1);
  if(ret != RET_OK){
    return ret;
  }
  mp01 = (struct _MODEPAGE01 *)
    (drive->data_buf + (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));
  if(current != NULL){
    *current = mp01->rd_retry_count;
  }
  mp01->rd_retry_count = count;
  ret = SendModeSelect(drive, 1);
  if(ret != RET_OK){
    return ret;
  }

  return RET_OK;
}

/**
 * @brief	READ¹
 * @param[in]	src		ɤ߹ߥɥ饤
 * @param[in]	lba		LBA
 * @param[in]	blocksize	֥å
 * @param[in]	len		ɤ߹ߥ֥å
 * @param[in]	long_read	LONGREAD뤫ɤ
 * @param[in]	long_read_size	LONGREADΥ
 * @retval	RET_OK	ｪλ
 * @retval	RET_CMDERR	ޥɥ顼
 * @retval	RET_NG	顼
 */
static int ExecRead(CMDDRIVE *src, DWORD lba, DWORD blocksize, DWORD len,
		    BOOL long_read, DWORD long_read_size)
{
  int ret;
  BYTE *sp, *dp;
  DWORD cnt;
  
  /* Read */
  if(!REALDRIVE(src)){
    ret = ReadImageFile(&src->u.image, src->data_buf, blocksize*len,
			(src->type==CMDDRVTYPE_IMAGE) ? TRUE:FALSE);
    if(ret!=RET_OK)
      return ret;
  }
  else{
    if(long_read){
      if(long_read_size){
	/* LONGREAD */
	if(blocksize==2048){
	  ret = SendLongRead12(src, lba, (WORD)len, len*blocksize,
			       long_read_size);
	}
	else{
	  ret = SendLongReadCD(src, lba, len, long_read_size);
	}
	if(ret!=RET_OK){
	  return ret;
	}
      }
      /* LONGREAD̼ */
      if(blocksize==2048){
	ret = SendLongRead12(src, lba, (WORD)len, len*blocksize, 0);
      }
      else{
	ret = SendLongReadCD(src, lba, len, 0);
      }
      if(ret!=RET_OK){
	return ret;
      }
    }
    else{
      /* ̾READ */
      if(blocksize==2048){
	ret = SendRead10(src, lba, (WORD)len, len*blocksize);
      }
      else{
	ret = SendReadCD(src, lba, len);
      }
      
      if(ret!=RET_OK){
	return ret;
      }
    }
    
    if(blocksize==2332){
      /* ReadCD bs=2352 ɤɤ⡢
	 ɬפʤΤ 2332 ʤΤǥХåեͤ */
      sp = dp = src->data_buf;
      sp += 16;	/* sync 16bytes */
      for(cnt=0; cnt<len; cnt++){
	memmove(dp, sp, 2332);
	sp += 2352;
	dp += 2332;
      }
    }
    else if(blocksize==2336){
      /* 2336 ˥Хåեͤ */
      sp = dp = src->data_buf;
      sp += 16;	/* sync 16bytes */
      for(cnt=0; cnt<len; cnt++){
	memmove(dp, sp, 2336);
	sp += 2352;
	dp += 2336;
      }
    }
  }

  return RET_OK;
}

/**
 * ꥢɥ쥹ɼȵϿ¹
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 * @param[in]	lba	ɥ쥹
 * @param[in]	blocksize  1֥åΥ(Хȿ)
 * @param[in]	len	ɼ&Ͽ֥å
 * @param[in]	long_read  ͥåȥɥ饤֤LONGREADͭˤ뤫ɤ
 * @param[in]	long_read_size	LONGREADͭˤΥ
 * @param[in]	readin	Lead-inɤ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 * @note	blocksize  2048/2332/2336/2352 ư롣
 * 		ʳбƤʤ
 */
static int ExecReadWrite(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
			 DWORD lba, DWORD blocksize, DWORD len,
			 BOOL long_read, DWORD long_read_size,
			 BOOL leadin, BOOL zerodata)
{
  int ret=RET_OK;
  int index;
  int retry=0;
  char info[80];
  BYTE rdretry_keep=0;

  if(zerodata){
    memset(src->data_buf, 0, len*blocksize);
  }
  else{
    for(retry=0; retry<=32; retry++){
      if(retry > 0){
	if(rdretry_keep == 0){
	  /* ɥ饤֤READȥ饤䤹 */
	  ret = SetReadRetryCount(src, 0xff, &rdretry_keep);
	  if(ret != RET_OK){
	    rdretry_keep=0;
	  }
	}
	if((retry&1)==0 && lba>0){
	  ExecRead(src, lba-1, blocksize, 1, FALSE, 0);
	}
	if(retry>=16 && (retry&3)==0){
	  /* ƥԥ󥢥åפƤߤꤹ */
	  UIDispInfo(MSG_SPINUP/*"Ʋž"*/);
	  if(UICheckAbort()){
	    ret = RET_ABORT;
	    break;
	  }
	  SendStartStop(src, 1, 0, 0);
#ifdef WIN32
	  Sleep(1000);
#else
	  sleep(1);
#endif
	}
	sprintf(info, MSG_RETRY_ /*"ɹ:%d"*/, retry);
	UIDispInfo(info);
	if(UICheckAbort()){
	  ret = RET_ABORT;
	  break;
	}
      }
      ret = ExecRead(src, lba, blocksize, len, long_read, long_read_size);
      if(ret==RET_OK){
	break;
      }
      else if(ret!=RET_CMDERR){
	break;
      }
    }
    if(rdretry_keep > 0){
      /* ɥ饤֤READȥ饤᤹ */
      SetReadRetryCount(src, rdretry_keep, NULL);
    }
    if(ret!=RET_OK){
      DispCommandError(src);
      return ret;
    }
  }
  
  /* Write */
  if(!REALDRIVE(&dst[0])){
    if(!zerodata){
      ret = WriteImageFile(&dst->u.image, dst->data_buf, len*blocksize,
			   (dst->type==CMDDRVTYPE_IMAGE) ? TRUE:FALSE);
      if(ret!=RET_OK)
	return ret;
    }
  }
  else{
    if(leadin && (num_dst>1)){
      /*
       * SAOLead-inϿϤ硢ʣϿ֤Ʊ
       * Lead-inϿϤ褦ˤ롣
       */
      BOOL *started = (BOOL *)malloc(sizeof(BOOL)*num_dst);
      int start_count=0;
      if(started==NULL){
	return RET_MEMERR;
      }
      memset(started, 0, sizeof(BOOL)*num_dst);
      while(start_count<num_dst){
	for(index=0; index<num_dst; index++){
	  if(started[index]){
	    continue;
	  }
	  ret = SendWrite10(&dst[index], lba, (WORD)len, len*blocksize,
			    FALSE);
	  if(ret==RET_CMDERR){
	    if((SD_SENSEKEY(&dst[index])==0x02) &&
	       (SD_ASC(&dst[index])==0x04) &&
	       (SD_ASCQ(&dst[index])==0x08)){
	      continue;
	    }
	  }
	  if(ret!=RET_OK){
	    DispCommandError(&dst[index]);
	    free(started);
	    return ret;
	  }
	  started[index] = TRUE;
	  start_count++;
	}
      }
      free(started);
    }
    else{
      /* Lead-inϿϤʤɤϰռ̤˵Ͽ */
      for(index=0; index<num_dst; index++){
	ret = SendWrite10(&dst[index], lba, (WORD)len, len*blocksize, TRUE);
	if(ret!=RET_OK){
	  DispCommandError(&dst[index]);
	  return ret;
	}
      }
      
    }
  }
  
  return RET_OK;
}


/**
 * ȥåγ
 * @param[in]	drive	ֹ¤
 * @param[in]	discinfo  ǥ
 * @param[in]	track_num ȥåֹ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int OpenTrack(CMDDRIVE *drive, CPDISCINFO *discinfo, WORD track_num)
{
  int ret;

  if(REALDRIVE(drive)){
    if(DT_CD_FAMILY(drive->disc_type)){
      ret = SetWriteParametersPage(drive, discinfo, track_num,
				   !discinfo->trackinfo[track_num-1].tao );
      if(ret!=RET_OK)
	return ret;
    }
    else{
      if(drive->disc_type==DT_DVDR ||
	 drive->disc_type==DT_DVDRWS || drive->disc_type==DT_DVDRWO){
	/* DVD-R/-RW */
	if(drive->disc_type!=DT_DVDR && GetOption()->dao==FALSE){
	  ret = FormatDVD(drive,
			  (BYTE)(track_num==1 ? FDFT_QUICK : FDFT_QUICKADD),
			  0x00000000);
	}
	else{
	  ret = SetWriteParametersPage(drive, discinfo, track_num,
				       GetOption()->dao);
	}
	if(ret!=RET_OK)
	  return ret;
      }
    }
  }

  return RET_OK;
}


/**
 * ȥåĤ
 * @param[in]	drive	ֹ¤
 * @param[in]	discinfo  ǥ
 * @param[in]	track_num ȥåֹ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int CloseTrack(CMDDRIVE *drive, int num_drv,
		      CPDISCINFO *discinfo, WORD track_num)
{
  CPTRACKINFO *cpti;
  int ret;

  if(REALDRIVE(&drive[0])){
    cpti = &discinfo->trackinfo[track_num-1];
    if(cpti->trackinfo.packet && cpti->trackinfo.nwa_valid==0 &&
       Get4bytes(cpti->trackinfo.free_blocks)==0 &&
       drive[0].disc_type!=DT_DVDRWS &&
       drive[0].disc_type!=DT_DVDRWO &&
       GetOption()->dao==FALSE){
      ret = ExecCloseTrack(drive, num_drv, track_num);
      if(ret!=RET_OK)
	return ret;
    }
  }

  return RET_OK;
}

/**
 * CD-TEXTΥǡХåե˺
 * @param[out]	buf	ǼХåե
 * @param[in]	fillsize  륵(Хȿ)
 * @param[in]	cdtext	CD-TEXT
 * @param[in]	cdtext_size  CD-TEXTХȿ
 * @param[in]	cdtext_offset  ȳϥեå(³Ԥݤɬ)
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static void MakeCDTextBuffer(BYTE *buf, DWORD fillsize,
			     BYTE *cdtext, DWORD cdtext_size, DWORD *cdtext_offset)
{
  DWORD cdtext_restsize;
  DWORD copysize;

  while(fillsize>0){
    cdtext_restsize = cdtext_size - (*cdtext_offset);
    if(fillsize < cdtext_restsize){
      copysize = fillsize;
    }
    else{
      copysize = cdtext_restsize;
    }
	
    memcpy(buf, cdtext+(*cdtext_offset), copysize);
    buf += copysize;
    fillsize -= copysize;
    *cdtext_offset += copysize;
    if(*cdtext_offset >= cdtext_size)
      *cdtext_offset = 0;
  }
}

/*
 * CRCη׻ϥåѥޤ
 * crc.h ˽񤤤Ƥ̤ꡢcdrecord 2.0 ѥäƤƤޤ
 */
#define LOCAL
#define UInt16_t WORD
#include "crc.h"
static void CalcCDTextCRC(CPDISCINFO *discinfo)
{
  int i, j;
  WORD crc;

  for(i=0; i<discinfo->cdtext_size; i+=18){
    crc = 0;
    for(j=0; j<16; j++){
      crc = (crc<<BPB) ^ crctab[(crc>>(BPW-BPB)) ^ discinfo->cdtext[i+j]];
    }
    crc = crc ^ 0xFFFF;
    discinfo->cdtext[i+16] = (BYTE)(crc>>8);
    discinfo->cdtext[i+17] = (BYTE)(crc);
  }
}


/**
 * CD-TEXTϿ
 * @param[in]	drive	ֹ¤
 * @param[in]	num_drv	ֹ¤
 * @param[in]	discinfo  ǥ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int WriteCDText(CMDDRIVE *drive, int num_drv, CPDISCINFO *discinfo)
{
  int ret = RET_OK;
  struct _DISCINFO *di;
  DWORD lba;
  DWORD rest_blocks, total_blocks, len, deflen;
  BYTE *converted_cdtext=NULL;
  DWORD converted_cdtext_size;
  DWORD cdtext_offset=0;
  long t1, t2;
  DWORD i;
  DWORD *leadin_start;
  DWORD max_leadin;
  int index;

  if(!REALDRIVE(&drive[0]))
    return RET_OK;

  leadin_start = (DWORD *)malloc(sizeof(DWORD)*num_drv);
  if(leadin_start == NULL){
    return RET_MEMERR;
  }
  /* Lead-inϻ֤ */
  max_leadin = 0;
  for(index=0; index<num_drv; index++){
    ret = SendReadDiscInfo(&drive[index]);
    if(ret!=RET_OK){
      DispCommandError(&drive[index]);
      free(leadin_start);
      return ret;
    }
    di = (struct _DISCINFO *)drive[index].data_buf;
    leadin_start[index] = MSF2LBA(di->last_lead_in[1],
				  di->last_lead_in[2],
				  di->last_lead_in[3], FALSE);
    if(max_leadin < leadin_start[index]){
      max_leadin = leadin_start[index];
    }
  }
  /*
   * ƤǥǡLead-inϻ֤
   * ٤Τ˹碌롣
   */
  for(index=0; index<num_drv; index++){
    len = (drive[index].bufsize-1)/96;
    lba = leadin_start[index];
    rest_blocks = (DWORD)(max_leadin-lba);
    memset(drive[index].data_buf, 0, drive[index].bufsize);
    while(rest_blocks > 0){
      if(len > rest_blocks){
	len = rest_blocks;
      }
      ret = SendWrite10(&drive[index], lba, (WORD)len, len*96, TRUE);
      if(ret!=RET_OK){
	DispCommandError(&drive[index]);
	free(leadin_start);
	return ret;
      }
      rest_blocks -= len;
      lba += len;
    }
  }
  free(leadin_start);

  /* CD-TEXTǡ */
  CalcCDTextCRC(discinfo);
  converted_cdtext_size = (discinfo->cdtext_size * 4+2)/3;
  converted_cdtext = malloc(converted_cdtext_size);
  if(converted_cdtext==NULL)
    return RET_MEMERR;
  for(i=0; i<converted_cdtext_size/4; i++){
    /*   8bit        6bit
     * aaaaaaaa    00aaaaaa
     * bbbbbbbb => 00aabbbb
     * cccccccc    00bbbbcc
     *             00cccccc
     */
    converted_cdtext[i*4+0] = (discinfo->cdtext[i*3+0]>>2) & 0x3f;
    converted_cdtext[i*4+1] = ((discinfo->cdtext[i*3+0]<<4) & 0x30) |
      ((discinfo->cdtext[i*3+1]>>4) & 0x0f);
    converted_cdtext[i*4+2] = ((discinfo->cdtext[i*3+1]<<2) & 0x3c) |
      ((discinfo->cdtext[i*3+2]>>6) & 0x03);
    converted_cdtext[i*4+3] = (discinfo->cdtext[i*3+2]>>0) & 0x3f;
  }

  lba = max_leadin;
  rest_blocks = total_blocks = (DWORD)(-150-lba);

  /*
   * 1٤žǤ֥å׻(1֥å=96bytes)
   * âɥ饤֤ΥХåեƱȤ롣
   */
  deflen = (drive->bufsize-1)/96;

  /* ɽ */
  UIMeter2Initialize("CD-TEXT");
  if(drive->type==CMDDRVTYPE_NET){
    NAUIMeter2Initialize(&drive->u.net, "CD-TEXT");
  }
  t1 = t2 = time(NULL);

  while(rest_blocks>0){
    t2 = time(NULL);
    if(t1!=t2){
      UIMeter2Update((float)(total_blocks-rest_blocks)*100/total_blocks);
      if(drive->type==CMDDRVTYPE_NET){
	NAUIMeter2Update(&drive->u.net,
			 (float)(total_blocks-rest_blocks)*100/total_blocks);
      }
      t1=t2;
    }
    if(UICheckAbort()){
      ret = RET_ABORT;
      break;
    }

    len = deflen < rest_blocks ? deflen : rest_blocks;
    for(index=0; index<num_drv; index++){
      MakeCDTextBuffer(drive[index].data_buf, len*96,
		       converted_cdtext, converted_cdtext_size, &cdtext_offset);
      ret = SendWrite10(&drive[index], lba, (WORD)len, len*96, TRUE);
      if(ret!=RET_OK){
	DispCommandError(&drive[index]);
	break;
      }
    }
    if(ret!=RET_OK){
      break;
    }
    lba += len;
    rest_blocks -= len;
  }

  free(converted_cdtext);

  return ret;
}


/**
 * ɤ߽񤭤Υ롼
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 * @param[in]	lba	ϥɥ쥹
 * @param[in]	blocks	֥å
 * @param[in]	deflen	ǥեžñ(֥å)
 * @param[in]	blocksize ֥å(Хȿ)
 * @param[in]	vp_track  VariablePacketɤ
 * @param[in]	last_addr ǽɥ쥹(Ľɽ˻Ѥ)
 * @param[in]	sao	Session at once ɤ
 * @param[in]	leadin	Lead-in εϿɤ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int WriteLoop(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
		     DWORD lba, DWORD blocks, DWORD deflen,
		     DWORD blocksize, BOOL vp_track, DWORD last_addr,
		     BOOL sao, BOOL leadin, BOOL zerodata)
{
  int ret;
  DWORD rest_blocks, total_blocks, len;
  DWORD long_read_rest=0;
  DWORD long_read_size=0;
  BOOL long_read=FALSE;
  BOOL long_read_now=FALSE;
  long t1, t2;
  float percent_total;
  int index;

  InitSpeedData();
  rest_blocks = total_blocks = blocks;

  if(src->type == CMDDRVTYPE_NET){
    /* LONG READ  */
    long_read_size = (0x00ffffffUL/deflen)*deflen;
    long_read = TRUE;
  }

  t1 = t2 = time(NULL);
  ret = RET_OK;
  while(rest_blocks>0 && ret==RET_OK){
    if(vp_track){
      ret = GetVPSize(src, lba, &blocks);
      if(ret!=RET_OK)
	break;
      for(index=0; index<num_dst; index++){
	ret = SetVPSize(&dst[index], blocks);
	if(ret!=RET_OK)
	  break;
      }
      if(ret!=RET_OK)
	break;
    }
    else
      blocks = rest_blocks;

    while(blocks>0){
      t2 = time(NULL);
      if(t1!=t2){
	percent_total = (float)lba*100/last_addr;
	if(GetOption()->on_the_fly==FALSE)
	  percent_total = percent_total/2 +
	    (dst->type!=CMDDRVTYPE_IMAGE ? 50 : 0);
	UIMeter1Update(percent_total);
	UIMeter2Update((float)(total_blocks-rest_blocks)*100/total_blocks);
	if(src->type==CMDDRVTYPE_NET){
	  NAUIMeter1Update(&src->u.net, percent_total);
	  NAUIMeter2Update(&src->u.net,
			   (float)(total_blocks-rest_blocks)*100/total_blocks);
	}
	/* ®١Ĥ֤ɽ */
	DispSpeed(lba, rest_blocks, src, dst);
	t1=t2;
      }
      if(UICheckAbort()){
	ret = RET_ABORT;
	break;
      }
      len = deflen>blocks ? blocks : deflen;
      if(long_read && !zerodata){
	long_read_now = FALSE;
	if(long_read_rest == 0){
	  /* LONGREAD */
	  long_read_now = TRUE;
	  if(long_read_size > blocks){
	    long_read_size = blocks;
	  }
	  long_read_rest = long_read_size;
	}
      }
      ret = ExecReadWrite(src, dst, num_dst, lba, blocksize, len,
			  long_read, (long_read_now ? long_read_size : 0),
			  leadin, zerodata);
      if(ret!=RET_OK)
	break;
      lba += len;
      blocks -= len;
      rest_blocks -= len;
      if(long_read){
	long_read_rest -= len;
      }
    }

    percent_total = (float)lba*100/last_addr;
    if(GetOption()->on_the_fly==FALSE)
      percent_total = percent_total/2 +
	(dst->type!=CMDDRVTYPE_IMAGE ? 50 : 0);
    UIMeter1Update(percent_total);
    UIMeter2Update((float)(total_blocks-rest_blocks)*100/total_blocks);
    if(src->type==CMDDRVTYPE_NET){
      NAUIMeter1Update(&src->u.net, percent_total);
      NAUIMeter2Update(&src->u.net,
		       (float)(total_blocks-rest_blocks)*100/total_blocks);
    }
    if(ret==RET_OK){
      if(!sao){
	for(index=0; index<num_dst; index++){
	  ret = SyncCache(&dst[index]);
	  if(ret!=RET_OK)
	    break;
	}
      }
    }

    if(vp_track){
      lba += 7;
      if(rest_blocks>7)
	rest_blocks -= 7;
      if(rest_blocks<7)
	rest_blocks=0;
    }
  }

  UIDispInfo("");
  if(src->type==CMDDRVTYPE_NET){
    NAUIDispInfo(&src->u.net, "");
  }
  return ret;
}

/**
 * 1ȥåʣ
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 * @param[in]	discinfo  ǥ
 * @param[in]	track_num ȥåֹ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int CopyTrack(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
		     CPDISCINFO *discinfo, WORD track_num)
{
  int ret;
  BOOL vp_track=FALSE;
  CPTRACKINFO *cpti = &discinfo->trackinfo[track_num-1];
  DWORD len;
  DWORD blocksize;
  DWORD blocks;
  DWORD lba;
  char msgbuf[80];
  int index;

  /* VariablePacketɤ */
  if(cpti->trackinfo.packet && Get4bytes(cpti->trackinfo.packet_size)==0)
    vp_track=TRUE;
  /* Ͽ֥å */
  if(cpti->trackinfo.nwa_valid){
    blocks = Get4bytes(cpti->trackinfo.next_writable_addr) -
      Get4bytes(cpti->trackinfo.track_start);
  }
  else{
    blocks = Get4bytes(cpti->trackinfo.track_size) -
      Get4bytes(cpti->trackinfo.free_blocks);
  }
  /* ֥å */
  if(DT_DVD_FAMILY(dst->disc_type)){
    blocksize = 2048;
    /* 1ž֥å */
    len = 16;
  }
  else{
    if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
      blocksize = cpti->mode2 ? 2332 : 2048;
    }
    else{
      blocksize = 2352;
    }
    /* 1žǤ֥å */
    if(REALDRIVE(src)){
      len = src->bufsize / (blocksize==2048 ? 2048 : 2352);
    }
    else if(REALDRIVE(&dst[0])){
      len = dst->bufsize / (blocksize==2048 ? 2048 : 2352);
    }
    else{
      len = 16;
    }
  }
  if(blocksize*len >= 0x10000){
    /* wnaspi32.dll Ǥ 64KB žǤʤ餷Τ */
    len = 0xffff/blocksize;
  }

  /* Ͽɥ쥹 */
  lba = Get4bytes(cpti->trackinfo.track_start);

  for(index=0; index<num_dst; index++){
    ret = OpenTrack(&dst[index], discinfo, track_num);
    if(ret!=RET_OK)
      return ret;
  }

  /* ɽ */
  sprintf(msgbuf, MSG_TRACK_ /*"ȥå%d"*/, track_num);
  UIMeter2Initialize(msgbuf);
  if(src->type==CMDDRVTYPE_NET){
    NAUIMeter2Initialize(&src->u.net, msgbuf);
  }

  if(Get4bytes(cpti->trackinfo.free_blocks) > 0){
    for(index=0; index<num_dst; index++){
      ret = ReserveTrack(&dst[index],
			 Get4bytes(cpti->trackinfo.track_size));
      if(ret!=RET_OK)
	return ret;
    }
  }

  ret = WriteLoop(src, dst, num_dst, lba, blocks, len, blocksize,
		  vp_track, discinfo->last_addr, FALSE, FALSE, FALSE);
  if(ret!=RET_OK){
    /* 顼ξϡSyncCacheƽλ */
    for(index=0; index<num_dst; index++){
      SyncCache(&dst[index]);
    }
  }
  else{
    ret = CloseTrack(dst, num_dst, discinfo, track_num);
  }

  return ret;
}


/**
 * SAOϿCueSheetκ
 * @param[in]	drive	ֹ¤
 * @param[in]	discinfo  ǥ
 * @param[in]	track_num ȥåֹ
 * @param[out]	cs_ret	CueSheet
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int CreateCueSheet(CMDDRIVE *drive, CPDISCINFO *discinfo,
			  WORD track_num,
			  struct _CUESHEET **cs_ret)
{
  struct _CUESHEET *cs = NULL, *csp;
  int cur_cs = 0;
  int num_cs = 0;
  DWORD gap_len;
  WORD sess_num = 0;
  DWORD nwa;
  CPTRACKINFO *cpti=NULL, *lcpti=NULL;
  struct _TRACKINFO *ti;
  int ret;
  BOOL gap_2part;
  BOOL cdtext=FALSE;
  int retry;	/* CD-TEXT̤ݡȥɥ饤֤ΰ٤Υȥ饤 */

  if(track_num==1 && discinfo->cdtext_size>0)
    cdtext = TRUE;

  for(retry=0; retry<2; retry++){
    cur_cs = 0;
    num_cs = 0;
    sess_num = 0;
    /* NWA */
    if(!REALDRIVE(drive)){
      nwa = 0;
    }
    else{
      ret = SendReadTrackInfo(drive, track_num);
      if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
      }
      ti = (struct _TRACKINFO *)drive->data_buf;
      nwa = Get4bytes(ti->next_writable_addr);
    }
    nwa -= 150;

    if(strlen(discinfo->media_catalog_number)!=0){
      /* Media Catalog Number */
      DebugLog("CreateCueSheet: Media catalog number.\n");
      num_cs += 2;
      cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
      if(cs==NULL)
	return RET_MEMERR;
      csp = &cs[cur_cs++];
      csp->ctladr = CSADR_MCN;
      memcpy(&csp->tno, discinfo->media_catalog_number, 7);
      csp = &cs[cur_cs++];
      csp->ctladr = CSADR_MCN;
      memcpy(&csp->tno, discinfo->media_catalog_number+7, 7);
    }

    cpti = NULL;
    lcpti = NULL;
    ret = RET_OK;
    for( ; track_num <= discinfo->tracks; track_num++){
      lcpti = cpti;
      cpti = &discinfo->trackinfo[track_num-1];
      gap_len = 0;
      if(sess_num==0){
	DebugLog("CreateCueSheet: Lead-in.\n");
	sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
	  (WORD)cpti->trackinfo.session_number_lsb;
	/* Lead-in */
	num_cs++;
	cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
	if(cs==NULL)
	  return RET_MEMERR;
	csp = &cs[cur_cs++];
	csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
	csp->ctladr |= CSADR_NORMAL;
	csp->tno = 0;
	csp->index = 0;
	csp->dataform = cdtext ? 0x41 : 0x01;
	csp->scms = 0;
	LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
	gap_len = Get4bytes(cpti->trackinfo.track_start) - nwa;
      }
      else if(sess_num != ((WORD)cpti->trackinfo.session_number_msb<<8 |
			   (WORD)cpti->trackinfo.session_number_lsb)){
	cpti = lcpti;
	break;
      }

      if(strlen(cpti->isrc)!=0){
	/* ISRC */
	DebugLog("CreateCueSheet: ISRC.\n");
	num_cs += 2;
	cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
	if(cs==NULL)
	  return RET_MEMERR;
	csp = &cs[cur_cs++];
	csp->ctladr = CSADR_ISRC;
	csp->tno = (BYTE)track_num;
	memcpy(&csp->index, cpti->isrc, 6);
	csp = &cs[cur_cs++];
	csp->ctladr = CSADR_ISRC;
	csp->tno = (BYTE)track_num;
	memcpy(&csp->index, cpti->isrc+6, 6);
      }
      gap_2part = FALSE;
      if(gap_len==0){
#if 1	/* äɤ? */
	if(lcpti!=NULL){
	  gap_len = Get4bytes(cpti->trackinfo.track_start) -
	    (Get4bytes(lcpti->trackinfo.track_start) +
	     Get4bytes(lcpti->trackinfo.track_size));
	  if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
	    /* DATA */
	    if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
	       lcpti->mode2 != cpti->mode2){
	      /* 2part */
	      DebugLog("CreateCueSheet: Two part pregap.(cdda -> data)\n");
	      gap_2part = TRUE;
	    }
	  }
	  else{
	    /* AUDIO */
	    if(IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
	      /* DATAξ⤫? */
	      DebugLog("CreateCueSheet: Two part pregap.(data -> cdda)\n");
	      gap_2part = TRUE;
	    }
	  }
	}
#else
	if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
	  /* AUDIO */
	  gap_len = cpti->pause_len;
	}
	else if(lcpti!=NULL){
	  /* DATA  2nd ʹ */
	  gap_len = 150;
	  if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
	     lcpti->mode2 != cpti->mode2){
	    /* 2part */
	    gap_len = 75+150;
	    gap_2part = TRUE;
	  }
	}
#endif
      }
      nwa = Get4bytes(cpti->trackinfo.track_start) - gap_len;
      DebugLog("CreateCueSheet: track=%d gap=%ld nwa=0x%08lX\n",
	       track_num, gap_len, nwa);
      if(gap_len>0){
	/* pre-gap */
	if(gap_2part && gap_len>150){
	  num_cs++;
	  cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
	  if(cs==NULL)
	    return RET_MEMERR;
	  csp = &cs[cur_cs++];
	  csp->ctladr = IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
	  csp->ctladr |= CSADR_NORMAL;
	  csp->tno = (BYTE)track_num;
	  csp->index = 0;
#if SEND_GAPDATA
	  if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
	    csp->dataform = 0x00;
	  }
	  else{
	    csp->dataform = lcpti->mode2 ? 0x20 : 0x10;
	  }
#else
	  if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
	    csp->dataform = 0x01;
	  }
	  else{
	    csp->dataform = lcpti->mode2 ? 0x24 : 0x14;
	  }
#endif
	  csp->scms = lcpti->trackinfo.copy ? 0x80 : 0;
	  LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
	  nwa += (gap_len-150);
	  gap_len = 150;
	  DebugLog("CreateCueSheet: Pre-gap.\n");
	}
	num_cs++;
	cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
	if(cs==NULL)
	  return RET_MEMERR;
	csp = &cs[cur_cs++];
	csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
	csp->ctladr |= CSADR_NORMAL;
	csp->tno = (BYTE)track_num;
	csp->index = 0;
#if SEND_GAPDATA
	if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
	  csp->dataform = 0x00;
	}
	else{
	  csp->dataform = cpti->mode2 ? 0x20 : 0x10;
	}
#else
	if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
	  csp->dataform = 0x01;
	}
	else{
	  csp->dataform = cpti->mode2 ? 0x24 : 0x14;
	}
#endif
	csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
	LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
	
	nwa += gap_len;
      }
      /* Audio/Data */
      num_cs++;
      cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
      if(cs==NULL)
	return RET_MEMERR;
      csp = &cs[cur_cs++];
      csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
      csp->ctladr |= CSADR_NORMAL;
      csp->tno = (BYTE)track_num;
      csp->index = 1;
      if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
	csp->dataform = 0x00;
      else
	csp->dataform = cpti->mode2 ? 0x20 : 0x10;
      csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
      LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
      nwa += Get4bytes(cpti->trackinfo.track_size);
      DebugLog("CreateCueSheet: Track%d.\n", track_num);
    }
    /* Lead-out */
    num_cs++;
    cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
    if(cs==NULL)
      return RET_MEMERR;
    csp = &cs[cur_cs++];
    csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
    csp->ctladr |= CSADR_NORMAL;
    csp->tno = 0xAA;
    csp->index = 1;
    if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
      csp->dataform = 0x01;
    else
      csp->dataform = cpti->mode2 ? 0x24 : 0x14;
    csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
    LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
    DebugLog("CreateCueSheet: Lead-out.\n", track_num);

    *cs_ret = cs;

    if(REALDRIVE(drive)){
      ret = SendSendCueSheet(drive, cs, num_cs*sizeof(struct _CUESHEET));
      if(ret!=RET_OK){
	if(!retry && cdtext){
	  cdtext = FALSE;	/* CD-TEXT ̵ˤƥȥ饤 */
	  DebugLog("CreateCueSheet: Retry(CD-TEXT is ignored).\n");
	}
	else{
	  DispCommandError(drive);
	  *cs_ret = NULL;
	  free(cs);
	  return ret;
	}
      }
    }
    if(ret==RET_OK)
      break;
  }

  DebugLog("CreateCueSheet: Done.\n", track_num);
  return RET_OK;
}


/**
 * 1åʣ
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 * @param[in]	discinfo  ǥ
 * @param[out]	track_num_ret Υȥåֹ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int CopySession(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
		       CPDISCINFO *discinfo,
		       WORD *track_num_ret)
{
  int ret=RET_OK;
  WORD track_num = *track_num_ret;
  struct _CUESHEET *cs=NULL, *csp;
  BOOL done=FALSE;
  DWORD lba, blocks;
  DWORD translen, blocksize;
  char msgbuf[80];
  int index;
  BOOL leadin=FALSE;

  for(index=0; index<num_dst; index++){
    if(cs!=NULL){
      free(cs);
      cs=NULL;
    }
    ret = SetWriteParametersPage(&dst[index], discinfo, track_num, TRUE);
    if(ret!=RET_OK)
      return ret;

    ret = CreateCueSheet(&dst[index], discinfo, track_num, &cs);
    if(ret!=RET_OK)
      return ret;
  }

  for(csp=cs; !done; csp++){
    if((csp->ctladr & 0x0f)!=CSADR_NORMAL)
      continue;
    if(csp->tno==0xaa){
      done=TRUE;
      continue;
    }
    if(csp->dataform==0x24 || csp->dataform==0x14 || csp->dataform==0x01){
      /* ǡžʥ */
      if(csp->dataform==0x01){
	if(REALDRIVE(dst)){
	  UIDispInfo(MSG_WRITING_LEAD_IN /*"¦Ͽ"*/);
	  leadin = TRUE;
	}
      }
      continue;
    }
    if(csp->dataform==0x41){
      /* CD-TEXT */
      if(csp->dataform==0x01){
	UIDispInfo(MSG_WRITING_CDTEXT /*"CD-TEXTϿ"*/);
      }
      ret = WriteCDText(dst, num_dst, discinfo);
      if(ret!=RET_OK)
	break;
      continue;
    }
    lba = MSF2LBA(csp->min, csp->sec, csp->frame, FALSE);
#if 1
    if(csp->index==0){
      blocks = MSF2LBA((csp+1)->min, (csp+1)->sec, (csp+1)->frame, FALSE) -lba;
    }
    else{
      blocks = Get4bytes(discinfo->trackinfo[csp->tno-1].trackinfo.track_size);
    }
#else	/* CueSheetϡISRC̵뤷ͭMSG򸡺ɬפ */
    blocks = MSF2LBA((csp+1)->min, (csp+1)->sec, (csp+1)->frame, FALSE) - lba;
#endif
    switch(csp->dataform){
    case 0x20:
      blocksize = 2336;
      break;
    case 0x10:
      blocksize = 2048;
      break;
    default:
      blocksize = 2352;
    }
    if(REALDRIVE(src))
      translen = src->bufsize / (blocksize==2048 ? 2048 : 2352);
    else
      translen = dst[0].bufsize / (blocksize==2048 ? 2048 : 2352);
    if(blocksize*translen >= 0x10000){
      /* wnaspi32.dll Ǥ 64KB žǤʤ餷Τ */
      translen = 0xffff / (blocksize==2048 ? 2048 : 2352);
    }

    /* ɽ */
    sprintf(msgbuf, MSG_TRACK_ /*"ȥå%d"*/, csp->tno);
    UIMeter2Initialize(msgbuf);
    if(src->type==CMDDRVTYPE_NET){
      NAUIMeter2Initialize(&src->u.net, msgbuf);
    }

    ret = WriteLoop(src, dst, num_dst,
		    lba, blocks, translen, blocksize,
		    FALSE, discinfo->last_addr, TRUE, leadin,
		    (csp->index==0));
    if(ret!=RET_OK){
      break;
    }
    *track_num_ret = csp->tno;
    leadin = FALSE;
  }

  for(index=0; index<num_dst; index++){
    SyncCache(&dst[index]);
  }

  (*track_num_ret)++;

  free(cs);
  return ret;
}


/**
 * DAO(Disc at once)ʣ
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 * @param[in]	discinfo  ǥ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int CopyDAO(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
		   CPDISCINFO *discinfo)
{
  int disc_type;
  int ret;
  int index;

  if(!REALDRIVE(src) && !REALDRIVE(&dst[0]))
    return RET_NG;

  if(REALDRIVE(src))
    disc_type = src->disc_type;
  else
    disc_type = dst[0].disc_type;

  if(DT_CD_FAMILY(disc_type)){
    /* Ϥ䤳ˤʤ */
    UIDispMessage(MSG_CANT_WRITE_CD_DAO
		  /*"ǰʤ顢CD  DAO ϤǤޤ"*/,
		  UIDMT_ERROR);
    return RET_ABORT;
  }
  else{
    /* DVD-R/-RW */
    for(index=0; index<num_dst; index++){
      ret = SetWriteParametersPage(&dst[index], discinfo, 1,
				   GetOption()->dao);
      if(ret!=RET_OK)
	return ret;
      ret = ReserveTrack(&dst[index],
			 Get4bytes(discinfo->trackinfo[0].trackinfo.track_size));
      if(ret!=RET_OK)
	return ret;
    }

    ret = CopyTrack(src, dst, num_dst, discinfo, 1);
    if(ret!=RET_OK)
      return ret;
  }

  return RET_OK;
}


/**
 * ʣ̤μ¹
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int ExecCopy(CMDDRIVE *src, CMDDRIVE *dst, int num_dst)
{
  int ret;
  CPDISCINFO discinfo;
  DWORD free_size;
  WORD track_num;
  WORD sess_num;
  CPTRACKINFO *cpti;
  BOOL sao=FALSE;
  int index;

  for(index=0; index<num_dst; index++){
    /* Ͽ褦ȤǥBLANKǤʤBLANK¹ */
    ret = Blanking(&dst[index]);
    if(ret!=RET_OK)
      return ret;
    /* Ͽǥ DVD+RW ǡ̤եޥåȤʤեޥåȳ */
    ret = Formatting(&dst[index]);
    if(ret!=RET_OK)
      return ret;
  }
	
  /* ǥξ(ReadDiscInfo. & ReadTrackInfo.) */
  ret = GetDiscInformation(src, &discinfo);
  if(ret!=RET_OK)
    return ret;
	
  if(discinfo.last_addr==0){
    UIDispMessage(MSG_SOURCE_IS_BLANK
		  /*"ʣ̸ǥϥ֥󥯤Ǥʣ̤Ǥޤ"*/,
		  UIDMT_INFORMATION);
    free(discinfo.trackinfo);
    free(discinfo.cdtext);
    return RET_ABORT;
  }

  /* Ͽ¦ۥɥ饤֤ʤ顢᡼ե˥ǥ */
  if(num_dst==1){
    ret = SetDiscInformation(&dst[0], &discinfo);
    if(ret!=RET_OK){
      free(discinfo.trackinfo);
      free(discinfo.cdtext);
      return ret;
    }
  }

  for(index=0; index<num_dst; index++){
    if(REALDRIVE(&dst[index])){
      if(dst[index].disc_type!=DT_DVDRWO &&
	 dst[index].disc_type!=DT_DVDRWS &&
	 dst[index].disc_type!=DT_DVDPRW){
	/* DVD-RW/+RW Ǥʤ̥å */
	/* WriteParametersPageˤäƥե꡼֥å
	   ƶƤޤ */
	ret = SetWriteParametersPage(&dst[index], &discinfo, 1,
				     !discinfo.trackinfo[0].tao );
	if(ret!=RET_OK){
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return ret;
	}

	/* Ͽǥζ̤ */
	ret = GetWritableSize(&dst[index], &free_size);
	if(ret!=RET_OK){
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return ret;
	}
	if(free_size < discinfo.last_addr){
	  ret = UIDispMessage(MSG_CAPACITY_IS_INSUFFICIENT
			      /*"Ͽǥ̤­Ƥޤ\n̵뤷³Ԥޤ?"*/,
			      UIDMT_QUESTION);
	  if(ret==UIDMRET_CANCEL){
	    free(discinfo.trackinfo);
	    free(discinfo.cdtext);
	    return RET_ABORT;
	  }
	}
      }

      if(dst[0].disc_type!=DT_DVDR &&
	 dst[0].disc_type!=DT_DVDRWO &&
	 dst[0].disc_type!=DT_DVDRWS){
	/* DVD-R/-RW ʳ DAO ̵ */
	GetOption()->dao = FALSE;
      }
    }
  }

  /* ɹ® */
  ret = SetSpeed(src, GetOption()->read_speed, 0);
  if(ret!=RET_OK){
    free(discinfo.trackinfo);
    free(discinfo.cdtext);
    return ret;
  }

  for(index=0; index<num_dst; index++){
    /* Ͽ® */
    ret = SetSpeed(&dst[index],
		   GetOption()->write_speed,
		   GetOption()->write_speed);
    if(ret!=RET_OK){
      free(discinfo.trackinfo);
      free(discinfo.cdtext);
      return ret;
    }
  }

  if(GetOption()->dao){
    ret = CopyDAO(src, dst, num_dst, &discinfo);
    if(ret!=RET_OK){
      free(discinfo.trackinfo);
      free(discinfo.cdtext);
      return ret;
    }
  }
  else{
    track_num=1;
    for(sess_num=1; sess_num<=discinfo.sessions; sess_num++){
      if(track_num > discinfo.tracks)
	break;
      if(track_num==discinfo.tracks &&
	 discinfo.trackinfo[track_num-1].trackinfo.blank){
	/* ǽȥåBLANKʤ鲿⤻λ */
	break;
      }
      if(discinfo.trackinfo[track_num-1].tao==FALSE){
	/* SAOϿ */
	sao = TRUE;
	ret = CopySession(src, dst, num_dst, &discinfo, &track_num);
	if(ret!=RET_OK){
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return ret;
	}
	continue;
      }

      /* TAOϿ */
      sao = FALSE;
      for(; track_num <= discinfo.tracks; track_num++){
	cpti = &discinfo.trackinfo[track_num-1];
	if(sess_num !=
	   ((WORD)cpti->trackinfo.session_number_msb<<8 |
	    (WORD)cpti->trackinfo.session_number_lsb)){
	  /* ΥåϽλ */
	  ret = CloseSession(dst, num_dst);
	  if(ret!=RET_OK){
	    free(discinfo.trackinfo);
	    free(discinfo.cdtext);
	    return ret;
	  }
	  break;
	}
	if(track_num==discinfo.tracks &&
	   discinfo.trackinfo[track_num-1].trackinfo.blank){
	  /* ǽȥåBLANKʤ鲿⤻λ */
	  break;;
	}
	      
	ret = CopyTrack(src, dst, num_dst, &discinfo, track_num);
	if(ret!=RET_OK){
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return ret;
	}
      }
    }
	  
    if(discinfo.last_sess_stat==SESSSTAT_COMPLETE && sao==FALSE){
      ret = CloseSession(dst, num_dst);
      if(ret!=RET_OK){
	free(discinfo.trackinfo);
	free(discinfo.cdtext);
	return ret;
      }
    }
  }
	
  free(discinfo.trackinfo);
  free(discinfo.cdtext);
	
  return RET_OK;
}



/**
 * 
 * @param[in]	retcode	¹Է̥
 * @param[in]	src	ɼֹ¤
 * @param[in]	dst	ֹ¤
 * @param[in]	num_dst	ֹ¤
 */
void PostProcess(int retcode, CMDDRIVE *src, CMDDRIVE *dstp, int num_dst)
{
  int ret;
  int index;
  BOOL socket_error = FALSE;

  if(retcode==RET_SOCKET){
    if(src->type==CMDDRVTYPE_NET)
      socket_error = DispSocketError(&src->u.net, retcode);
    else
      socket_error = DispSocketError(&dstp->u.net, retcode);
  }

  if(src->type == CMDDRVTYPE_NET){
    if(retcode==RET_OK){
      NASendComplete(&src->u.net);
    }
    else if(retcode==RET_ABORT){
      NASendAbort(&src->u.net);
    }
    FreeSOCKCB(&src->u.net);
  }
  if(dstp->type == CMDDRVTYPE_NET){
    if(retcode==RET_OK){
      NASendComplete(&dstp->u.net);
    }
    else if(retcode==RET_ABORT){
      NASendAbort(&dstp->u.net);
    }
    FreeSOCKCB(&dstp->u.net);
  }
  
  if(socket_error==FALSE){
    if(retcode==RET_ABORT){
      UIDispMessage(MSG_ABORTED/*"Ǥޤ"*/, UIDMT_INFORMATION);
    }
    else if(retcode==RET_OK){
      if(!REALDRIVE(src) && !REALDRIVE(dstp)){
	UIDispMessage(MSG_COMPLETE_SUCCESS
		      /*"˽λޤ"*/,
		      UIDMT_INFORMATION);
      }
      else{
	ret = UIDispMessage(MSG_COMPLETE_SUCCESS_AND_EJECT
			    /*"˽λޤӽФޤ?"*/,
			    UIDMT_QUESTION);
	if(ret==UIDMRET_OK){
	  for(index=0; index<num_dst; index++){
	    OpenTray(&dstp[index]);
	  }
	  OpenTray(src);
	}
      }
    }
    else{
      ret = UIDispMessage(MSG_ERROR_OCCURRED
			  /*"顼ȯޤޥɥޤ?"*/,
			  UIDMT_QUESTION);
      if(ret==UIDMRET_OK){
	CreateLog(src, dstp, num_dst);
      }
    }
  }
}

/**
 * ɼ֤ν
 * @param[in]	reader ɼID
 * @param[out]	drive ɥ饤ֹ¤
 * @param[in]	data_buf ǡХåե
 * @param[in]	bufsize ǡХåե
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int OpenReader(DRIVEID *reader, CMDDRIVE *drive,
		      BYTE *data_buf, int bufsize)
{
  int ret;

  if(reader->hid == HID_VIRTUAL){
    if(reader->tid == CMDDRVTYPE_ISO){
      /* ISO᡼ */
      ret = OpenISOImageDevice(drive, TRUE, data_buf, bufsize);
      if(ret != RET_OK){
	return ret;
      }
    }
    else if(reader->tid == CMDDRVTYPE_IMAGE){
      /* ꥸʥ륤᡼ */
      ret = OpenEnbanImageDevice(drive, TRUE, data_buf, bufsize);
      if(ret != RET_OK){
	return ret;
      }
    }
    else if(reader->tid == CMDDRVTYPE_NET){
      /* ͥåȥ³줿 */
      ret = OpenNetDevice(drive, FALSE, data_buf, bufsize);
      if(ret != RET_OK){
	return ret;
      }
    }
    else{
      return RET_NG;
    }
  }
  else{
    /* ̾ΥǥХ */
    ret = OpenDevice(drive, reader->hid, reader->tid, TRUE, TRUE,
		     data_buf, bufsize);
    if(ret != RET_OK){
      return ret;
    }
  }
  return RET_OK;
}


/**
 * ɼ֤θդ
 * @param[in/out] drive ɥ饤ֹ¤
 */
static void CloseReader(CMDDRIVE *drive)
{
  CloseDevice(drive);
}


/**
 * ֤ν
 * @param[in]	writer ID
 * @param[in]	num_writer ֿ
 * @param[out]	drive ɥ饤ֹ¤
 * @param[out]	num_writable_drive ǽɥ饤ֿ
 * @param[in]	data_buf ǡХåե
 * @param[in]	bufsize ǡХåե
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
static int OpenWriter(DRIVEID *writer, int num_writer,
		      CMDDRIVE *drive, int *num_writable_drive,
		      BYTE *data_buf, int bufsize)
{
  int index;
  int ret;
  CMDDRIVE tmpdrive;

  if(writer->hid == HID_VIRTUAL){
    memset(&tmpdrive, 0, sizeof(tmpdrive));
    if(writer->tid == CMDDRVTYPE_ISO){
      /* ISO᡼ */
      ret = OpenISOImageDevice(&tmpdrive, FALSE, data_buf, bufsize);
      if(ret != RET_OK){
	return ret;
      }
    }
    else if(writer->tid == CMDDRVTYPE_IMAGE){
      /* ꥸʥ륤᡼ */
      ret = OpenEnbanImageDevice(&tmpdrive, FALSE, data_buf, bufsize);
      if(ret != RET_OK){
	return ret;
      }
    }
    else if(writer->tid == CMDDRVTYPE_NET){
      /* ͥåȥ³줿 */
      ret = OpenNetDevice(&tmpdrive, TRUE, data_buf, bufsize);
      if(ret != RET_OK){
	return ret;
      }
    }
    else{
      return RET_NG;
    }
    memcpy(&drive[0], &tmpdrive, sizeof(CMDDRIVE));
    *num_writable_drive = 1;
  }
  else{
    /* ̾ΥǥХ */
    for(index=0; index<num_writer; index++){
      memset(&tmpdrive, 0, sizeof(tmpdrive));
      ret = OpenDevice(&tmpdrive, writer[index].hid, writer[index].tid,
		       FALSE, (num_writer==1), data_buf, bufsize);
      if(ret != RET_OK){
	continue;
      }
      memcpy(&drive[*num_writable_drive], &tmpdrive, sizeof(CMDDRIVE));
      (*num_writable_drive)++;
    }
    if(*num_writable_drive == 0){
      return RET_NG;
    }
  }

  return RET_OK;
}


/**
 * ֤θդ
 * @param[in/out] drive ɥ饤ֹ¤
 * @param[in]	num_drive ɥ饤ֹ¤
 */
static void CloseWriter(CMDDRIVE *drive, int num_drive)
{
  int index;

  for(index=0; index<num_drive; index++){
    CloseDevice(&drive[index]);
  }
}

/**
 * פʣ
 * @param[in]	reader	ɼID
 * @param[in]	writer	ID
 * @param[in]	num_writer  ֿ
 * @retval	RET_OK	ｪλ
 * @retval	RET_NG	顼
 */
int CopyDisc(DRIVEID *reader, DRIVEID *writer, int num_writer)
{
  BOOL bSameDrive=FALSE;
  BOOL bDVD=FALSE;
  CMDDRIVE src, virtual_drv, *dstp=NULL;
  int ret;
  OPTIONS *option;
  int index;
  int num_writable_drive=0;
  int disc_type;
  BYTE *data_buf;
  int bufsize;
  char tmpfile[_MAX_PATH];
  
  memset(&src, 0, sizeof(src));
  memset(&virtual_drv, 0, sizeof(virtual_drv));
  
  UICheckAbort();
  
  if(reader->hid != HID_VIRTUAL && writer->hid != HID_VIRTUAL){
    if(reader->hid == writer->hid &&
       reader->tid == writer->tid){
      bSameDrive = TRUE;
    }
  }

  if(!bSameDrive){
    dstp = (CMDDRIVE *)malloc(num_writer*sizeof(CMDDRIVE));
    if(dstp==NULL){
      UIDispMessage(MSG_MEM_ALLOC_ERROR
		    /*"ݤ˼Ԥޤ"*/, UIDMT_ERROR);
      return RET_NG;
    }
    memset(dstp, 0, num_writer*sizeof(CMDDRIVE));
  }
  bufsize = 0x10000;
  data_buf = (BYTE *)malloc(bufsize);
  if(data_buf==NULL){
    UIDispMessage(MSG_MEM_ALLOC_ERROR
		  /*"ݤ˼Ԥޤ"*/, UIDMT_ERROR);
    free(dstp);
    return RET_NG;
  }
	
  /* ɼ֤Υץ */
  ret = OpenReader(reader, &src, data_buf, bufsize);
  if(ret!=RET_OK){
    free(dstp);
    free(data_buf);
    return ret;
  }
  disc_type = src.disc_type;

  /* ֤Υץ */
  if(bSameDrive){
    ret = SetOption(&src, &src, src.disc_type);
    if(ret!=RET_OK){
      CloseReader(&src);
      free(dstp);
      free(data_buf);
      return ret;
    }
    num_writable_drive = 1;
  }
  else{
    ret = OpenWriter(writer, num_writer, dstp, &num_writable_drive,
		     data_buf, bufsize);
    if(ret != RET_OK){
      CloseReader(&src);
      free(dstp);
      free(data_buf);
      return ret;
    }

    if((writer->hid == HID_VIRTUAL) &&
       (writer->tid == CMDDRVTYPE_NET)){
      /* ͥåȥ³줿֤ξ */
      /* Х⡼Ե */
      ret = WaitingNetCmd(&dstp[0], &src);
      PostProcess(ret, &src, &dstp[0], num_writable_drive);
      CloseReader(&src);
      CloseWriter(dstp, num_writable_drive);
      free(dstp);
      free(data_buf);
      return ret;
    }
    
    if(disc_type==DT_UNKNOWN){
      disc_type = dstp[0].disc_type;
    }
    
    ret = SetOption(&src, &dstp[0], disc_type);
    if(ret!=RET_OK){
      CloseReader(&src);
      CloseWriter(dstp, num_writable_drive);
      free(dstp);
      free(data_buf);
      return ret;
    }
  }
  
  /* ե̾ */
  strcpy(tmpfile, GetOption()->temppath);
  if(strlen(tmpfile)+1+7+1>=sizeof(tmpfile)){
    return RET_NG;
  }
#ifdef WIN32
  if(strlen(tmpfile)>0){
    if(tmpfile[strlen(tmpfile)-1]=='\\')
      strcat(tmpfile, "tmp.img");
    else
      strcat(tmpfile, "\\tmp.img");
  }
  else
    strcat(tmpfile, "\\tmp.img");
#else
  strcat(tmpfile, "/tmp.img");
#endif
  
  UIMeter1Initialize(MSG_TOTAL /*""*/);
  if(src.type==CMDDRVTYPE_NET){
    NAUIMeter1Initialize(&src.u.net, MSG_TOTAL /*""*/);
  }

  option = GetOption();
  if(option->on_the_fly){
    /* On-The-Fly񤭹 */
    bDVD = DT_DVD_FAMILY(disc_type);
    for(index=0; index<num_writable_drive; index++){
      if(!REALDRIVE(&dstp[index])){
	dstp[index].disc_type = disc_type;
      }
      else if((bDVD != DT_DVD_FAMILY(dstp[index].disc_type)) &&
	      REALDRIVE(&src)){
	UIDispMessage(MSG_CANT_COPY_DIFFERENT_TYPE
		      /*"CD  DVD 䡢DVD  CD ˤϥԡǤޤ"*/,
		      UIDMT_ERROR);
	CloseReader(&src);
	CloseWriter(dstp, num_writable_drive);
	free(dstp);
	free(data_buf);
	return RET_NG;
      }
    }
    ret = ExecCopy(&src, dstp, num_writable_drive);
    PostProcess(ret, &src, dstp, num_writable_drive);
    CloseReader(&src);
    CloseWriter(dstp, num_writable_drive);
    free(dstp);
    free(data_buf);
  }
  else{
    /* եͳ */
    ret = OpenTempImageDevice(&virtual_drv, FALSE, data_buf, bufsize, tmpfile);
    if(ret!=RET_OK){
      CloseReader(&src);
      if(!bSameDrive){
	CloseWriter(dstp, num_writable_drive);
      }
      free(dstp);
      free(data_buf);
      return ret;
    }
    
    virtual_drv.disc_type = src.disc_type;
    
    ret = ExecCopy(&src, &virtual_drv, 1);	/* DISC => Image file */
    if(ret==RET_OK){
      OpenTray(&src);
      if(src.type == CMDDRVTYPE_NET){
	NASendComplete(&src.u.net);
      }
    }
    else{
      PostProcess(ret, &src, &virtual_drv, 1);
    }
    if(bSameDrive){
      dstp = &src;
    }
    else{
      CloseReader(&src);
    }
    CloseDevice(&virtual_drv);
    if(ret!=RET_OK){ /* ExecCopyͳǧ */
      RemoveImageFile(tmpfile);
      CloseWriter(dstp, num_writable_drive);
      if(!bSameDrive){
	free(dstp);
      }
      free(data_buf);
      return ret;
    }
    
    ret = OpenTempImageDevice(&virtual_drv, TRUE, data_buf, bufsize, tmpfile);
    if(ret!=RET_OK){
      CloseWriter(dstp, num_writable_drive);
      if(!bSameDrive){
	free(dstp);
      }
      free(data_buf);
      return ret;
    }
    if(bSameDrive){
      /* ǥԤ */
      ret = GetDiscType(&dstp[0], &dstp[0].disc_type, TRUE);
      if(ret!=RET_OK){
	PostProcess(ret, &virtual_drv, dstp, num_writable_drive);
	CloseDevice(&virtual_drv);
	RemoveImageFile(tmpfile);
	CloseWriter(dstp, num_writable_drive);
	if(!bSameDrive){
	  free(dstp);
	}
	free(data_buf);
	return ret;
      }
    }
    
    /* Image file => DISC */
    ret = ExecCopy(&virtual_drv, dstp, num_writable_drive);
    PostProcess(ret, &virtual_drv, dstp, num_writable_drive);
    CloseDevice(&virtual_drv);
    RemoveImageFile(tmpfile);
    CloseWriter(dstp, num_writable_drive);
    if(!bSameDrive){
      free(dstp);
    }
    free(data_buf);
  }
  
  return ret;
}

