#!/bin/bash
PROG=EnbanFukusyaYa
TMPDIR=/tmp/$PROG
if [ -e /etc/vine-release ]; then
  RPMTOP=/usr/src/vine
  RPMBUILD=rpm
  SPECFILE=$PROG.spec
else
  RPMTOP=/usr/src/redhat
  RPMBUILD=rpmbuild
  SPECFILE=$PROG-fc.spec
fi

SOURCE=`grep ^Source: ../$SPECFILE`
SOURCEFILE=${SOURCE##*:\ }
VERSION=`grep ^Version: ../$SPECFILE`
VERNUM=${VERSION##*:\ }
PROGDIR=$PROG"-"$VERNUM

rm -rf $TMPDIR
mkdir $TMPDIR
cp -pr ../../../$PROG $TMPDIR/$PROGDIR
find $TMPDIR/$PROG"-"$VERNUM -type d -name CVS -exec rm -rf {} \; \
	> /dev/null 2>&1
pushd $TMPDIR > /dev/null
tar zcf $SOURCEFILE $PROGDIR
rm -rf $PROGDIR
popd > /dev/null

cp ../$SPECFILE $RPMTOP/SPECS/
mv $TMPDIR/$SOURCEFILE $RPMTOP/SOURCES/

$RPMBUILD -ba $RPMTOP/SPECS/$SPECFILE
