/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import tools.tracesviewer.AboutFrame;
import tools.tracesviewer.AlertFrame;
import tools.tracesviewer.DebugWindow;
import tools.tracesviewer.HelpBox;
import tools.tracesviewer.ScriptFrame;
import tools.tracesviewer.TracesMessage;
import tools.tracesviewer.TracesSessions;
import tools.tracesviewer.TracesSessionsDisplayer;
import tools.tracesviewer.TracesViewer;

public class ListenerTracesViewer {
    public TracesViewer tracesViewer;
    public TracesSessionsDisplayer tracesSessionsDisplayer;
    public boolean ANIMATION_STARTED;
    public AboutFrame aboutFrame;
    public HelpBox helpBox;
    public ScriptFrame scriptFrame;

    public ListenerTracesViewer(TracesViewer tracesViewer) {
        this.tracesViewer = tracesViewer;
        this.ANIMATION_STARTED = false;
        this.aboutFrame = new AboutFrame();
        this.tracesSessionsDisplayer = new TracesSessionsDisplayer();
        this.helpBox = new HelpBox();
        this.scriptFrame = new ScriptFrame();
    }

    public void debugActionPerformed(ActionEvent actionEvent) {
        TracesMessage tracesMessage = this.tracesViewer.tracesCanvas.debugTracesMessage;
        if (tracesMessage == null) {
            return;
        }
        if (tracesMessage.beforeDebug != null && tracesMessage.beforeDebug != null && !tracesMessage.beforeDebug.trim().equals("") && !tracesMessage.afterDebug.trim().equals("")) {
            DebugWindow debugWindow = new DebugWindow(tracesMessage.beforeDebug, tracesMessage.afterDebug, tracesMessage.debugLine);
            debugWindow.show();
        }
    }

    public void displayAllSessionsMouseEvent(MouseEvent mouseEvent) {
        this.tracesSessionsDisplayer.show(this.tracesViewer.getTracesSessions());
    }

    public void helpMenuMouseEvent(MouseEvent mouseEvent) {
        this.helpBox.show();
    }

    public void aboutMenuMouseEvent(MouseEvent mouseEvent) {
        this.aboutFrame.animationThread.start();
        this.aboutFrame.show();
    }

    public void animationActionPerformed(ActionEvent actionEvent) {
        if (this.tracesViewer.tracesCanvas.arrows.size() == 0) {
            new AlertFrame("Please hit Refresh, first!", 0);
        } else if (this.ANIMATION_STARTED) {
            this.tracesViewer.animationMenuItem.setBackground(Color.lightGray);
            this.tracesViewer.animationThread.stop();
            this.ANIMATION_STARTED = false;
        } else {
            this.tracesViewer.animationThread.start();
            this.tracesViewer.animationMenuItem.setBackground(Color.green);
            this.ANIMATION_STARTED = true;
        }
    }

    public void refreshActionPerformed(MouseEvent mouseEvent) {
        if (this.ANIMATION_STARTED) {
            new AlertFrame("You must stop the animation before refreshing the traces!", 0);
        } else {
            TracesSessions tracesSessions = this.tracesViewer.refreshTracesSessions();
            this.tracesViewer.tracesSessionsList.setTracesSessions(tracesSessions);
            this.tracesViewer.tracesSessionsList.updateTracesCanvas();
            if (this.tracesSessionsDisplayer.isVisible()) {
                this.tracesSessionsDisplayer.show(tracesSessions);
            }
        }
    }

    public void scriptActionPerformed(ActionEvent actionEvent) {
    }

    public void tracesSessionsListStateChanged(ItemEvent itemEvent) {
        if (this.ANIMATION_STARTED) {
            this.tracesViewer.animationMenuItem.setBackground(Color.lightGray);
            this.tracesViewer.animationThread.stop();
            this.ANIMATION_STARTED = false;
        }
        this.tracesViewer.tracesSessionsList.updateTracesCanvas(itemEvent);
    }
}

