/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import tools.tracesviewer.ListenerTracesViewer;
import tools.tracesviewer.LogFileParser;
import tools.tracesviewer.MessageLogList;
import tools.tracesviewer.PercentLayout;
import tools.tracesviewer.PercentLayoutConstraint;
import tools.tracesviewer.TracesAnimationThread;
import tools.tracesviewer.TracesCanvas;
import tools.tracesviewer.TracesSession;
import tools.tracesviewer.TracesSessions;
import tools.tracesviewer.TracesSessionsList;
import tools.tracesviewer.TracesSocket;

public class TracesViewer
extends JFrame {
    private boolean standaloneViewer = false;
    private String logFile;
    protected JMenuBar menuBar;
    protected JMenu displayAllSessionsMenu;
    protected JMenu optionsMenu;
    protected JMenu refreshMenu;
    protected JMenu aboutMenu;
    protected JMenu helpMenu;
    protected JMenu quitMenu;
    protected JMenuItem animationMenuItem;
    protected JMenuItem stackIdMenuItem;
    protected JPanel firstPanel;
    protected JPanel secondPanel;
    protected JPanel firstSubPanel;
    protected JPanel secondSubPanel;
    protected JPanel thirdSubPanel;
    protected JButton scriptButton;
    protected Choice choice;
    protected ListenerTracesViewer listenerTracesViewer;
    protected JLabel sessionsLabel;
    protected TracesSessionsList tracesSessionsList;
    protected JButton messageContentButton;
    protected TextArea messageContentTextArea;
    protected TracesSessions tracesSessions;
    protected TracesCanvas tracesCanvas;
    protected static String rmiHost;
    protected static String rmiPort;
    protected static String stackId;
    protected static Image actorsImage;
    protected static Image backgroundImage;
    protected static Image facesImage;
    protected static Image logoNist;
    protected TracesAnimationThread animationThread = null;
    static /* synthetic */ Class class$tools$tracesviewer$TracesViewer;

    public TracesViewer(Hashtable hashtable, String string, String string2, String string3) {
        TracesSessions tracesSessions = new TracesSessions();
        Enumeration enumeration = hashtable.elements();
        tracesSessions.setName(string);
        this.logFile = string;
        while (enumeration.hasMoreElements()) {
            MessageLogList messageLogList = (MessageLogList)enumeration.nextElement();
            TracesSession tracesSession = new TracesSession(messageLogList);
            tracesSession.setName(string);
            tracesSession.setInfo(string3);
            tracesSession.setLogDescription(string2);
            tracesSessions.add(tracesSession);
        }
        this.listenerTracesViewer = new ListenerTracesViewer(this);
        this.tracesSessions = tracesSessions;
        this.standaloneViewer = true;
        this.initComponents();
        this.tracesSessionsList.setTracesSessions(this.tracesSessions);
        this.animationThread = new TracesAnimationThread(this.tracesCanvas);
        this.setSize(670, 620);
        this.setLocation(0, 0);
    }

    public TracesViewer(String string, String string2, String string3, String string4) {
        super(string);
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource("images/back.gif");
            backgroundImage = toolkit.getImage(uRL);
            uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource("images/comp.gif");
            actorsImage = toolkit.getImage(uRL);
            uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource("images/faces.jpg");
            facesImage = toolkit.getImage(uRL);
            uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource("images/nistBanner.jpg");
            logoNist = toolkit.getImage(uRL);
        }
        catch (Exception exception) {
            backgroundImage = null;
            actorsImage = null;
            facesImage = null;
            logoNist = null;
            System.out.println("Problem with the Toolkit: no loaded images!!!");
            exception.printStackTrace();
        }
        rmiHost = string2;
        rmiPort = string3;
        stackId = string4;
        this.listenerTracesViewer = new ListenerTracesViewer(this);
        this.tracesSessions = this.refreshTracesSessions();
        this.initComponents();
        this.tracesSessionsList.setTracesSessions(this.tracesSessions);
        this.animationThread = new TracesAnimationThread(this.tracesCanvas);
        this.setSize(670, 620);
        this.show();
    }

    public TracesViewer(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        super(string);
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string5);
            backgroundImage = toolkit.getImage(uRL);
            uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string7);
            actorsImage = toolkit.getImage(uRL);
            uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string6);
            facesImage = toolkit.getImage(uRL);
            uRL = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string8);
            logoNist = toolkit.getImage(uRL);
        }
        catch (Exception exception) {
            backgroundImage = null;
            actorsImage = null;
            facesImage = null;
            logoNist = null;
            System.out.println("Images are not loaded.");
            exception.printStackTrace();
        }
        rmiHost = string2;
        rmiPort = string3;
        stackId = string4;
        this.listenerTracesViewer = new ListenerTracesViewer(this);
        this.tracesSessions = this.refreshTracesSessions();
        this.initComponents();
        this.tracesSessionsList.setTracesSessions(this.tracesSessions);
        this.animationThread = new TracesAnimationThread(this.tracesCanvas);
        this.setSize(670, 620);
        this.setLocation(0, 0);
        this.show();
    }

    public TracesViewer(String string, Hashtable hashtable, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        super(string5);
        Object object;
        Object object2;
        this.logFile = string;
        try {
            object2 = Toolkit.getDefaultToolkit();
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string6);
            backgroundImage = ((Toolkit)object2).getImage((URL)object);
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string8);
            actorsImage = ((Toolkit)object2).getImage((URL)object);
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string7);
            facesImage = ((Toolkit)object2).getImage((URL)object);
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string9);
            logoNist = ((Toolkit)object2).getImage((URL)object);
        }
        catch (Exception exception) {
            backgroundImage = null;
            actorsImage = null;
            facesImage = null;
            logoNist = null;
            System.out.println("Images are not loaded.");
            exception.printStackTrace();
        }
        object2 = new TracesSessions();
        ((TracesSessions)object2).setName(string2);
        if (hashtable != null) {
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                MessageLogList messageLogList = (MessageLogList)object.nextElement();
                TracesSession tracesSession = new TracesSession(messageLogList);
                tracesSession.setName(string2);
                tracesSession.setInfo(string4);
                tracesSession.setLogDescription(string3);
                ((Vector)object2).add(tracesSession);
            }
        }
        if (((Vector)object2).isEmpty()) {
            object = new TracesSession();
            ((TracesSession)object).setName("No available session, refresh");
            ((Vector)object2).add(object);
        }
        this.listenerTracesViewer = new ListenerTracesViewer(this);
        this.tracesSessions = object2;
        this.initComponents();
        this.tracesSessionsList.setTracesSessions(this.tracesSessions);
        this.animationThread = new TracesAnimationThread(this.tracesCanvas);
        this.setSize(670, 620);
        this.setLocation(0, 0);
    }

    public TracesViewer(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string);
        this.logFile = string2;
        this.listenerTracesViewer = new ListenerTracesViewer(this);
        this.tracesSessions = this.refreshTracesSessions();
        this.initComponents();
        this.tracesSessionsList.setTracesSessions(this.tracesSessions);
        this.animationThread = new TracesAnimationThread(this.tracesCanvas);
        this.setSize(670, 620);
        this.setLocation(0, 0);
        this.show();
    }

    public TracesViewer(String string, String string2, Hashtable hashtable, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        super(string6);
        Object object;
        Object object2;
        this.logFile = string2;
        try {
            object2 = Toolkit.getDefaultToolkit();
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string7);
            backgroundImage = ((Toolkit)object2).getImage((URL)object);
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string9);
            actorsImage = ((Toolkit)object2).getImage((URL)object);
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string8);
            facesImage = ((Toolkit)object2).getImage((URL)object);
            object = (class$tools$tracesviewer$TracesViewer == null ? (class$tools$tracesviewer$TracesViewer = TracesViewer.class$("tools.tracesviewer.TracesViewer")) : class$tools$tracesviewer$TracesViewer).getResource(string10);
            logoNist = ((Toolkit)object2).getImage((URL)object);
        }
        catch (Exception exception) {
            backgroundImage = null;
            actorsImage = null;
            facesImage = null;
            logoNist = null;
            System.out.println("Images are not loaded.");
            exception.printStackTrace();
        }
        object2 = new TracesSessions();
        ((TracesSessions)object2).setName(string3);
        if (hashtable != null) {
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                MessageLogList messageLogList = (MessageLogList)object.nextElement();
                TracesSession tracesSession = new TracesSession(messageLogList);
                tracesSession.setName(string3);
                tracesSession.setInfo(string5);
                tracesSession.setLogDescription(string4);
                ((Vector)object2).add(tracesSession);
            }
        }
        if (((Vector)object2).isEmpty()) {
            object = new TracesSession();
            ((TracesSession)object).setName("No available session, refresh");
            ((Vector)object2).add(object);
        }
        this.listenerTracesViewer = new ListenerTracesViewer(this);
        this.tracesSessions = object2;
        this.initComponents();
        this.tracesSessionsList.setTracesSessions(this.tracesSessions);
        this.animationThread = new TracesAnimationThread(this.tracesCanvas);
        this.setSize(670, 620);
        this.setLocation(0, 0);
        try {
            object = new TracesSocket(string2, string);
            ((Thread)object).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.show();
    }

    public TracesSessions refreshTracesSessions() {
        TracesSessions tracesSessions = null;
        TracesSessions tracesSessions2 = new TracesSessions();
        String string = null;
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.logFile != null) {
                object3 = new File(this.logFile);
                object2 = new char[(int)((File)object3).length()];
                object = new FileReader((File)object3);
                ((Reader)object).read((char[])object2);
                ((InputStreamReader)object).close();
                string = new String((char[])object2);
            }
            if (string != null && !string.equals("")) {
                object3 = new LogFileParser();
                object2 = ((LogFileParser)object3).parseLogsFromString(string);
                object = ((Hashtable)object2).elements();
                while (object.hasMoreElements()) {
                    MessageLogList messageLogList = (MessageLogList)object.nextElement();
                    TracesSession tracesSession = new TracesSession(messageLogList);
                    tracesSession.setName(((LogFileParser)object3).logName);
                    tracesSession.setLogDescription(((LogFileParser)object3).logDescription);
                    tracesSession.setInfo(((LogFileParser)object3).auxInfo);
                    tracesSessions2.add(tracesSession);
                }
                tracesSessions2.setName(((LogFileParser)object3).logName);
                tracesSessions = tracesSessions2;
            } else {
                object3 = new TracesSession();
                ((TracesSession)object3).setName("No available session, refresh");
                tracesSessions2.add(object3);
                tracesSessions = tracesSessions2;
            }
        }
        catch (Exception exception) {
            System.out.println("*** Exception retrieving trace ***");
            exception.printStackTrace();
            TracesSession tracesSession = new TracesSession();
            tracesSession.setName("No available session, refresh");
            tracesSessions2.add(tracesSession);
            tracesSessions = tracesSessions2;
        }
        this.tracesSessions = tracesSessions;
        return this.tracesSessions;
    }

    public TracesSessions getTracesSessions() {
        return this.tracesSessions;
    }

    private void initComponents() {
        Container container;
        Accessible accessible;
        Container container2 = this.getContentPane();
        container2.setLayout(new BoxLayout(container2, 1));
        container2.setBackground(Color.black);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Trace viewer closed!");
            }
        });
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.optionsMenu = new JMenu("      Options      ");
        this.optionsMenu.setBorder(new BevelBorder(0));
        this.optionsMenu.setToolTipText("Some options related to the GUI");
        this.animationMenuItem = new JMenuItem("    Animation    ");
        this.animationMenuItem.setToolTipText("Animation of the entire selected session");
        this.animationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TracesViewer.this.listenerTracesViewer.animationActionPerformed(actionEvent);
            }
        });
        this.optionsMenu.add(this.animationMenuItem);
        this.menuBar.add(this.optionsMenu);
        this.displayAllSessionsMenu = new JMenu("    Display Sessions    ");
        this.displayAllSessionsMenu.setBorder(new BevelBorder(0));
        this.displayAllSessionsMenu.setToolTipText("Display all the retrieved sessions in a separate windows");
        this.displayAllSessionsMenu.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TracesViewer.this.listenerTracesViewer.displayAllSessionsMouseEvent(mouseEvent);
            }
        });
        this.menuBar.add(this.displayAllSessionsMenu);
        this.refreshMenu = new JMenu("   Refresh   ");
        this.refreshMenu.setBorder(new BevelBorder(0));
        this.refreshMenu.setBackground(new Color(51, 153, 255));
        this.refreshMenu.setToolTipText("Get the new traces");
        this.refreshMenu.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TracesViewer.this.listenerTracesViewer.refreshActionPerformed(mouseEvent);
            }
        });
        this.menuBar.add(this.refreshMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        this.helpMenu = new JMenu("    Help    ");
        this.helpMenu.setBorder(new BevelBorder(0));
        this.helpMenu.setToolTipText("Some useful notes about this tool");
        this.helpMenu.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TracesViewer.this.listenerTracesViewer.helpMenuMouseEvent(mouseEvent);
            }
        });
        this.menuBar.add(this.helpMenu);
        this.aboutMenu = new JMenu("    About    ");
        this.aboutMenu.setBorder(new BevelBorder(0));
        this.aboutMenu.setToolTipText("Some advertises about the creators!");
        this.aboutMenu.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TracesViewer.this.listenerTracesViewer.aboutMenuMouseEvent(mouseEvent);
            }
        });
        this.menuBar.add(this.aboutMenu);
        this.quitMenu = new JMenu("    Quit    ");
        this.quitMenu.setBorder(new BevelBorder(0));
        this.quitMenu.setToolTipText("Quit the traces viewer");
        this.quitMenu.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TracesViewer.this.close();
            }
        });
        this.menuBar.add(this.quitMenu);
        this.firstPanel = new JPanel();
        this.firstPanel.setOpaque(false);
        this.firstPanel.setLayout(new PercentLayout());
        container2.add(this.firstPanel);
        PercentLayoutConstraint percentLayoutConstraint = new PercentLayoutConstraint(30.0, 0.0, 70.0, 100.0);
        this.tracesSessionsList = new TracesSessionsList();
        this.tracesSessionsList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TracesViewer.this.listenerTracesViewer.tracesSessionsListStateChanged(itemEvent);
            }
        });
        this.tracesSessionsList.setForeground(Color.black);
        this.tracesSessionsList.setFont(new Font("Dialog", 1, 14));
        ScrollPane scrollPane = new ScrollPane(1);
        TracesSession tracesSession = (TracesSession)this.tracesSessions.firstElement();
        String string = tracesSession.getName();
        String string2 = tracesSession.getLogDescription();
        String string3 = this.tracesSessionsList.getCallId(string);
        String string4 = this.tracesSessionsList.getOrigin(string);
        TextArea textArea = new TextArea();
        this.messageContentButton = new JButton("SIP Message:");
        this.tracesCanvas = string.equals("No available session, refresh") ? new TracesCanvas(tracesSession, textArea, "unknown", this) : (string2 == null || string2.trim().equals("") ? new TracesCanvas(tracesSession, textArea, string4, this) : new TracesCanvas(tracesSession, textArea, string2, this));
        this.tracesSessionsList.setTracesCanvas(this.tracesCanvas);
        scrollPane.add(this.tracesCanvas);
        this.firstPanel.add((Component)scrollPane, percentLayoutConstraint);
        this.secondPanel = new JPanel();
        this.secondPanel.setBackground(Color.black);
        this.secondPanel.setLayout(new BorderLayout());
        PercentLayoutConstraint percentLayoutConstraint2 = new PercentLayoutConstraint(0.0, 0.0, 30.0, 100.0);
        this.firstPanel.add((Component)this.secondPanel, percentLayoutConstraint2);
        this.firstSubPanel = new JPanel();
        this.firstSubPanel.setBackground(Color.black);
        this.firstSubPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 7, 5));
        if (!this.standaloneViewer) {
            this.firstSubPanel.setLayout(new GridLayout(2, 1, 3, 6));
            this.secondPanel.add((Component)this.firstSubPanel, "North");
            accessible = new JPanel();
            ((JComponent)((Object)accessible)).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ((Container)((Object)accessible)).setLayout(new GridLayout(2, 1, 0, 0));
            container = new JPanel();
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            container.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel("Display the event script:");
            jLabel.setToolTipText("Display the content of the selected script");
            jLabel.setHorizontalAlignment(0);
            jLabel.setForeground(Color.black);
            jLabel.setFont(new Font("Dialog", 1, 14));
            jLabel.setOpaque(true);
            ((Container)((Object)accessible)).add(jLabel);
            this.choice = new Choice();
            container.add((Component)this.choice, "Center");
            this.scriptButton = new JButton("Open");
            this.scriptButton.setToolTipText("Get the script controlling the current session");
            this.scriptButton.setFont(new Font("Dialog", 1, 14));
            this.scriptButton.setFocusPainted(false);
            this.scriptButton.setBackground(new Color(186, 175, 175));
            this.scriptButton.setBorder(new BevelBorder(0));
            this.scriptButton.setVerticalAlignment(0);
            this.scriptButton.setHorizontalAlignment(0);
            container.add((Component)this.scriptButton, "East");
            this.scriptButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TracesViewer.this.listenerTracesViewer.scriptActionPerformed(actionEvent);
                }
            });
            ((Container)((Object)accessible)).add(container);
            this.firstSubPanel.add((Component)((Object)accessible));
            if (logoNist != null) {
                ImageIcon imageIcon = new ImageIcon(logoNist);
                JLabel jLabel2 = new JLabel(imageIcon);
                jLabel2.setVisible(true);
                jLabel2.setToolTipText("The NIST logo!!!");
                jLabel2.setForeground(Color.black);
                jLabel2.setOpaque(false);
                this.firstSubPanel.add(jLabel2);
            }
        } else {
            this.firstSubPanel.setLayout(new GridLayout(1, 1, 3, 6));
            this.secondPanel.add((Component)this.firstSubPanel, "North");
            if (logoNist != null) {
                accessible = new ImageIcon(logoNist);
                container = new JLabel((Icon)((Object)accessible));
                ((JComponent)container).setVisible(true);
                ((JComponent)container).setToolTipText("The NIST logo!!!");
                ((JLabel)container).setHorizontalAlignment(0);
                ((JComponent)container).setForeground(Color.black);
                ((JComponent)container).setFont(new Font("Dialog", 1, 14));
                ((JComponent)container).setOpaque(false);
                this.firstSubPanel.add(container);
            }
        }
        accessible = new JPanel();
        ((Container)((Object)accessible)).setLayout(new GridLayout(2, 1, 0, 0));
        this.secondPanel.add((Component)((Object)accessible), "Center");
        this.secondSubPanel = new JPanel();
        this.secondSubPanel.setBackground(Color.black);
        this.secondSubPanel.setLayout(new BorderLayout());
        ((Container)((Object)accessible)).add(this.secondSubPanel);
        this.sessionsLabel = new JLabel("Sessions available:");
        this.sessionsLabel.setToolTipText("All the sessions currently available");
        this.sessionsLabel.setHorizontalAlignment(0);
        this.sessionsLabel.setForeground(Color.black);
        this.sessionsLabel.setFont(new Font("Dialog", 1, 14));
        this.sessionsLabel.setOpaque(true);
        this.sessionsLabel.setBackground(Color.lightGray);
        this.sessionsLabel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.secondSubPanel.add((Component)this.sessionsLabel, "North");
        container = new ScrollPane(1);
        container.add(this.tracesSessionsList);
        this.secondSubPanel.add((Component)this.tracesSessionsList, "Center");
        this.thirdSubPanel = new JPanel();
        this.thirdSubPanel.setBackground(Color.black);
        this.thirdSubPanel.setLayout(new BorderLayout());
        ((Container)((Object)accessible)).add(this.thirdSubPanel);
        this.messageContentButton.setToolTipText("Display all the content of the current SIP message");
        this.messageContentButton.setHorizontalAlignment(0);
        this.messageContentButton.setForeground(Color.black);
        this.messageContentButton.setFont(new Font("Dialog", 1, 14));
        this.messageContentButton.setOpaque(true);
        this.messageContentButton.setBackground(Color.lightGray);
        this.messageContentButton.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.messageContentButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TracesViewer.this.listenerTracesViewer.debugActionPerformed(actionEvent);
            }
        });
        textArea.setBackground(Color.white);
        textArea.setEditable(false);
        textArea.setFont(new Font("Dialog", 1, 12));
        textArea.setForeground(Color.black);
        this.thirdSubPanel.add((Component)this.messageContentButton, "North");
        this.thirdSubPanel.add((Component)textArea, "Center");
        this.validateTree();
    }

    public void close() {
        System.out.println("Trace viewer closed!");
        this.dispose();
    }

    public static void usage() {
        System.out.println("***************************************");
        System.out.println("*** missing or incorrect parameters ***");
        System.out.println("*************************************\n");
        System.out.println("When you create your SIP Stack specify");
        System.out.println("gov.nist.javax.sip.stack.SERVER_LOG = fileName\n");
        System.out.println("gov.nist.javax.sip.stack.DEBUG_LOG = debugFileName\n");
        System.out.println("*************************************");
        System.out.println("Use this tool to view the signaling trace as a sequence Diagram");
        System.out.println("Usage (if classpath correctly set):\n\n");
        System.out.println("When viewing from a server file:\n --> java tools.tracesviewer.tracesViewer -debug_file debugFileName\n");
        System.out.println("When viewing from a debug file:\n --> java tools.tracesviewer.tracesViewer -server_file fileName");
        System.out.println("*************************************\n");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                System.out.println("Using default parameters!");
                System.out.println("Everything is Ok ... Launching the Traces viewer");
                TracesViewer tracesViewer = new TracesViewer("Traces viewer", "127.0.0.1", "1099", "127.0.0.1:5060");
            } else {
                if (stringArray[0].equals("-debug_file")) {
                    String string = stringArray[1];
                    LogFileParser logFileParser = new LogFileParser();
                    Hashtable hashtable = logFileParser.parseLogsFromDebugFile(string);
                    new TracesViewer(string, hashtable, logFileParser.logName, logFileParser.logDescription, logFileParser.auxInfo, "traces viewer", "images/back.gif", "images/faces.jpg", "images/comp.gif", "images/nistBanner.jpg").show();
                    return;
                }
                if (stringArray[0].equals("-server_file")) {
                    String string = stringArray[1];
                    LogFileParser logFileParser = new LogFileParser();
                    Hashtable hashtable = logFileParser.parseLogsFromFile(string);
                    new TracesViewer(string, hashtable, logFileParser.logName, logFileParser.logDescription, logFileParser.auxInfo, "traces viewer", "images/back.gif", "images/faces.jpg", "images/comp.gif", "images/nistBanner.jpg").show();
                    return;
                }
                if (stringArray[0].equals("-daemon")) {
                    int n = stringArray.length;
                    String string = "10000";
                    String string2 = "NOT SET";
                    for (int i = 0; i < n; ++i) {
                        if (stringArray[i].equals("-server_file")) {
                            string2 = stringArray[i + 1];
                            ++i;
                            continue;
                        }
                        if (!stringArray[i].equals("-port")) continue;
                        string = stringArray[i + 1];
                        ++i;
                    }
                    LogFileParser logFileParser = new LogFileParser();
                    Hashtable hashtable = logFileParser.parseLogsFromFile(string2);
                    new TracesViewer(string, string2, hashtable, logFileParser.logName, logFileParser.logDescription, logFileParser.auxInfo, "traces viewer daemon", "images/back.gif", "images/faces.jpg", "images/comp.gif", "images/nistBanner.jpg").show();
                    return;
                }
                int n = stringArray.length;
                String string = "127.0.0.1";
                String string3 = "1099";
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                boolean bl = false;
                for (int i = 0; i < n; ++i) {
                    if (stringArray[i].equals("-rmihost")) {
                        string = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    if (stringArray[i].equals("-rmiport")) {
                        string3 = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    if (stringArray[i].equals("-stackId")) {
                        string4 = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    if (stringArray[i].equals("-back")) {
                        bl = true;
                        string5 = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    if (stringArray[i].equals("-faces")) {
                        string6 = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    if (stringArray[i].equals("-actors")) {
                        string7 = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    if (stringArray[i].equals("-logoNist")) {
                        string8 = stringArray[i + 1];
                        ++i;
                        continue;
                    }
                    TracesViewer.usage();
                }
                if (string == null) {
                    System.out.println("Assuming RMI host = 127.0.0.1");
                }
                if (string4 == null) {
                    System.out.println("Stack Id (name) not specified Bailing! Please specify stackId (JAIN stack name)  using -stackId flag");
                    System.exit(0);
                }
                if (bl) {
                    TracesViewer tracesViewer = new TracesViewer("Traces viewer", string, string3, string4, string5, string6, string7, string8);
                } else {
                    TracesViewer tracesViewer = new TracesViewer("Traces viewer", string, string3, string4);
                }
                System.out.println("Everything is Ok ... Launching the Traces viewer");
            }
        }
        catch (Exception exception) {
            System.out.println("Problem starting viewer. I give up :)");
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        actorsImage = null;
        backgroundImage = null;
        facesImage = null;
        logoNist = null;
    }
}

