/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.javax.sip.address.NetObject;

public final class UserInfo
extends NetObject {
    private static final long serialVersionUID = 7268593273924256144L;
    protected String user;
    protected String password;
    protected int userType;
    public static final int TELEPHONE_SUBSCRIBER = 1;
    public static final int USER = 2;

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        if (this.userType != other.userType) {
            return false;
        }
        if (!this.user.equalsIgnoreCase(other.user)) {
            return false;
        }
        if (this.password != null && other.password == null) {
            return false;
        }
        if (other.password != null && this.password == null) {
            return false;
        }
        if (this.password == other.password) {
            return true;
        }
        return this.password.equals(other.password);
    }

    public String encode() {
        if (this.password != null) {
            return this.user + ":" + this.password;
        }
        return this.user;
    }

    public void clearPassword() {
        this.password = null;
    }

    public int getUserType() {
        return this.userType;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
        if (user != null && (user.indexOf("#") >= 0 || user.indexOf(";") >= 0)) {
            this.setUserType(1);
        } else {
            this.setUserType(2);
        }
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setUserType(int type) throws IllegalArgumentException {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Parameter not in range");
        }
        this.userType = type;
    }
}

