/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.TimerTask;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.message.Response;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction {
    private int rseqNumber = (int)Math.random() * 1000;
    private ServerRequestInterface requestOf;
    private SIPDialog dialog;
    private SIPResponse pendingReliableResponse;
    private ProvisionalResponseTask provisionalResponseTask;
    private boolean retransmissionAlertEnabled;
    private RetransmissionAlertTimerTask retransmissionAlertTimerTask;
    protected boolean isAckSeen;
    private SIPClientTransaction pendingSubscribeTransaction;
    private SIPServerTransaction inviteTransaction;

    private void sendResponse(SIPResponse transactionResponse) throws IOException {
        if (this.isReliable()) {
            this.getMessageChannel().sendMessage(transactionResponse);
        } else {
            Via via = transactionResponse.getTopmostVia();
            String transport = via.getTransport();
            if (transport == null) {
                throw new IOException("missing transport!");
            }
            int port = via.getRPort();
            if (port == -1) {
                port = via.getPort();
            }
            if (port == -1) {
                port = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
            }
            Host maddr = via.getMaddr();
            String host = null;
            if (maddr != null) {
                host = maddr.getHostname();
            } else {
                host = via.getParameter("received");
                if (host == null) {
                    host = via.getHost();
                }
            }
            Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(host, port, transport));
            MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getPort(), hop);
            if (messageChannel != null) {
                messageChannel.sendMessage(transactionResponse);
            } else {
                throw new IOException("Could not create a message channel for " + hop);
            }
        }
    }

    protected SIPServerTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating Server Transaction" + this.getBranchId());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public void setRequestInterface(ServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        ViaList viaHeaders;
        boolean transactionMatches = false;
        String method = messageToTest.getCSeq().getMethod();
        if ((method.equals("INVITE") || !this.isTerminated()) && (viaHeaders = messageToTest.getViaHeaders()) != null) {
            Via topViaHeader = (Via)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.startsWith("z9hG4bK")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                transactionMatches = method.equals("CANCEL") ? this.getMethod().equals("CANCEL") && this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy()) : this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy());
            } else {
                String originalFromTag = this.fromTag;
                String thisFromTag = messageToTest.getFrom().getTag();
                boolean skipFrom = originalFromTag == null || thisFromTag == null;
                String originalToTag = this.toTag;
                String thisToTag = messageToTest.getTo().getTag();
                boolean skipTo = originalToTag == null || thisToTag == null;
                boolean isResponse = messageToTest instanceof SIPResponse;
                if ((isResponse || this.getOriginalRequest().getRequestURI().equals(((SIPRequest)messageToTest).getRequestURI())) && (skipFrom || originalFromTag.equalsIgnoreCase(thisFromTag)) && (skipTo || originalToTag.equalsIgnoreCase(thisToTag)) && this.getOriginalRequest().getCallId().getCallId().equalsIgnoreCase(messageToTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSeqNumber() == messageToTest.getCSeq().getSeqNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() {
        if (this.getRealState() == null || this.getRealState() == TransactionState.TRYING) {
            if (this.isInviteTransaction() && !this.isMapped && this.sipStack.timer != null) {
                this.isMapped = true;
                this.sipStack.timer.schedule((TimerTask)new SendTrying(), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(SIPRequest transactionRequest, MessageChannel sourceChannel) {
        block35: {
            boolean toTu = false;
            if (this.sipStack.logWriter.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("processRequest: " + transactionRequest.getFirstLine());
                this.sipStack.logWriter.logDebug("tx state = " + this.getRealState());
            }
            try {
                if (this.getRealState() == null) {
                    this.setOriginalRequest(transactionRequest);
                    this.setState(TransactionState.TRYING);
                    toTu = true;
                    this.setPassToListener();
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && TransactionState.COMPLETED == this.getRealState() && transactionRequest.getMethod().equals("ACK")) {
                        this.setState(TransactionState.CONFIRMED);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            this.enableTimeoutTimer(10);
                        } else {
                            this.setState(TransactionState.TERMINATED);
                        }
                        if (this.sipStack.non2XXAckPassedToListener) {
                            this.requestOf.processRequest(transactionRequest, this);
                        } else {
                            if (this.sipStack.logWriter.isLoggingEnabled()) {
                                this.sipStack.logWriter.logDebug("ACK received for server Tx " + this.getTransactionId() + " not delivering to application!");
                            }
                            this.semaphore.release();
                        }
                        return;
                    }
                    if (transactionRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                        if (TransactionState.PROCEEDING == this.getRealState() || TransactionState.COMPLETED == this.getRealState()) {
                            this.semaphore.release();
                            if (this.lastResponse != null) {
                                super.sendMessage(this.lastResponse);
                            }
                        } else if (transactionRequest.getMethod().equals("ACK")) {
                            if (this.requestOf != null) {
                                this.requestOf.processRequest(transactionRequest, this);
                            } else {
                                this.semaphore.release();
                            }
                        }
                        this.sipStack.logWriter.logDebug("completed processing retransmitted request : " + transactionRequest.getFirstLine() + this + " txState = " + this.getState() + " lastResponse = " + this.getLastResponse());
                        return;
                    }
                }
                if (TransactionState.COMPLETED != this.getRealState() && TransactionState.TERMINATED != this.getRealState() && this.requestOf != null) {
                    if (this.getOriginalRequest().getMethod().equals(transactionRequest.getMethod())) {
                        if (toTu) {
                            this.requestOf.processRequest(transactionRequest, this);
                        } else {
                            this.semaphore.release();
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(transactionRequest, this);
                    } else {
                        this.semaphore.release();
                    }
                    break block35;
                }
                if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod()) && this.getRealState() == TransactionState.TERMINATED && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog thisDialog = this.dialog;
                    if (thisDialog == null || !thisDialog.ackProcessed) {
                        if (thisDialog != null) {
                            thisDialog.ackReceived(transactionRequest);
                            thisDialog.ackProcessed = true;
                        }
                        this.requestOf.processRequest(transactionRequest, this);
                    } else {
                        this.semaphore.release();
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("Too late to cancel Transaction");
                    }
                    this.semaphore.release();
                    try {
                        this.sendMessage(transactionRequest.createResponse(200));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.sipStack.logWriter.logDebug("Dropping request " + this.getRealState());
            }
            catch (IOException e) {
                this.semaphore.release();
                this.raiseIOExceptionEvent();
            }
        }
    }

    public void sendMessage(SIPMessage messageToSend) throws IOException {
        SIPResponse transactionResponse = (SIPResponse)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        try {
            if (this.getOriginalRequest().getTopmostVia().getBranch() != null) {
                transactionResponse.getTopmostVia().setBranch(this.getBranch());
            } else {
                transactionResponse.getTopmostVia().removeParameter("branch");
            }
            if (!this.getOriginalRequest().getTopmostVia().hasPort()) {
                transactionResponse.getTopmostVia().removePort();
            }
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        if (!transactionResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
            this.sendResponse(transactionResponse);
            return;
        }
        if (this.getRealState() == TransactionState.TRYING) {
            if (statusCode / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(TransactionState.COMPLETED);
                if (!this.isReliable()) {
                    this.enableRetransmissionTimer();
                }
                this.enableTimeoutTimer(64);
            }
        } else if (this.getRealState() == TransactionState.PROCEEDING) {
            if (this.isInviteTransaction()) {
                if (statusCode / 100 == 2) {
                    if (!transactionResponse.getCSeq().getMethod().equals("CANCEL")) {
                        this.collectionTime = 64;
                        this.setState(TransactionState.TERMINATED);
                        if (!this.isReliable()) {
                            if (this.dialog != null) {
                                this.dialog.setRetransmissionTicks();
                            }
                            this.enableRetransmissionTimer();
                        }
                        this.enableTimeoutTimer(64);
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(TransactionState.COMPLETED);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                } else if (statusCode / 100 == 2) {
                    this.setState(TransactionState.TERMINATED);
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(TransactionState.COMPLETED);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getRealState()) {
            return;
        }
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("sendMessage : tx = " + this + " getState = " + this.getState());
            }
            this.lastResponse = transactionResponse;
            this.sendResponse(transactionResponse);
        }
        catch (IOException e) {
            this.setState(TransactionState.TERMINATED);
            this.collectionTime = 0;
            throw e;
        }
    }

    public String getViaHost() {
        return this.getMessageChannel().getViaHost();
    }

    public int getViaPort() {
        return this.getMessageChannel().getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("fireRetransmissionTimer() -- ");
            }
            if (this.isInviteTransaction() && this.lastResponse != null) {
                if (!this.retransmissionAlertEnabled) {
                    if (this.lastResponse.getStatusCode() / 100 > 2) {
                        super.sendMessage(this.lastResponse);
                    }
                } else {
                    SipProviderImpl sipProvider = this.getSipProvider();
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)sipProvider, this, Timeout.RETRANSMIT);
                    sipProvider.handleEvent(txTimeout, this);
                }
            }
        }
        catch (IOException e) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(e);
            }
            this.raiseErrorEvent(2);
        }
    }

    private void fireReliableResponseRetransmissionTimer() {
        try {
            super.sendMessage(this.pendingReliableResponse);
        }
        catch (IOException e) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(e);
            }
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("SIPServerTransaction.fireTimeoutTimer this = " + this + " current state = " + this.getRealState() + " method = " + this.getOriginalRequest().getMethod());
        }
        SIPDialog dialog = this.dialog;
        if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod()) && (TransactionState.CALLING == this.getRealState() || TransactionState.TRYING == this.getRealState())) {
            dialog.setState(3);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && dialog != null && dialog.isTerminatedOnBye()) {
            dialog.setState(3);
        }
        if (TransactionState.COMPLETED == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (TransactionState.COMPLETED == this.getRealState() && !this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (TransactionState.CONFIRMED == this.getRealState() && this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (!(this.isInviteTransaction() || TransactionState.COMPLETED != this.getRealState() && TransactionState.CONFIRMED != this.getRealState())) {
            this.setState(TransactionState.TERMINATED);
        } else if (this.isInviteTransaction() && TransactionState.TERMINATED == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(3);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(SIPRequest originalRequest) {
        super.setOriginalRequest(originalRequest);
    }

    public void sendResponse(Response response) throws SipException {
        SIPResponse sipResponse = (SIPResponse)response;
        SIPDialog dialog = this.dialog;
        if (response == null) {
            throw new NullPointerException("null response");
        }
        try {
            sipResponse.checkHeaders();
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        if (!sipResponse.getCSeq().getMethod().equals(this.getMethod())) {
            throw new SipException("CSeq method does not match Request method of request that created the tx.");
        }
        if (this.getMethod().equals("SUBSCRIBE") && response.getStatusCode() / 100 == 2) {
            if (response.getHeader("Expires") == null) {
                throw new SipException("Expires header is mandatory in 2xx response of SUBSCRIBE");
            }
            Expires requestExpires = (Expires)this.getOriginalRequest().getExpires();
            Expires responseExpires = (Expires)response.getExpires();
            if (requestExpires != null && responseExpires.getExpires() > requestExpires.getExpires()) {
                throw new SipException("Response Expires time exceeds request Expires time : See RFC 3265 3.1.1");
            }
        }
        if (sipResponse.getStatusCode() == 200 && sipResponse.getCSeq().getMethod().equals("INVITE") && sipResponse.getHeader("Contact") == null) {
            throw new SipException("Contact Header is mandatory for the OK to the INVITE");
        }
        if (!this.isMessagePartOfTransaction((SIPMessage)((Object)response))) {
            throw new SipException("Response does not belong to this transaction.");
        }
        try {
            String fromTag;
            if (this.pendingReliableResponse != null && response.getStatusCode() / 100 == 2 && this.pendingReliableResponse.getContentTypeHeader().getContentType().equals("application") && this.pendingReliableResponse.getContentTypeHeader().getContentSubType().equals("sdp")) {
                throw new SipException("cannot send response -- unacked povisional");
            }
            if (this.pendingReliableResponse != null && sipResponse.isFinalResponse()) {
                this.provisionalResponseTask.cancel();
                this.provisionalResponseTask = null;
            }
            if (dialog != null) {
                if (sipResponse.getStatusCode() / 100 == 2 && this.sipStack.isDialogCreated(sipResponse.getCSeq().getMethod())) {
                    if (dialog.getLocalTag() == null && sipResponse.getTo().getTag() == null) {
                        sipResponse.getTo().setTag(Utils.generateTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() == null) {
                        sipResponse.setToTag(dialog.getLocalTag());
                    } else if (dialog.getLocalTag() != null && sipResponse.getToTag() != null && !dialog.getLocalTag().equals(sipResponse.getToTag())) {
                        throw new SipException("Tag mismatch dialogTag is " + dialog.getLocalTag() + " responseTag is " + sipResponse.getToTag());
                    }
                }
                if (!sipResponse.getCallId().getCallId().equals(dialog.getCallId().getCallId())) {
                    throw new SipException("Dialog mismatch!");
                }
            }
            if (dialog != null && dialog.getLocalTag() != null && sipResponse.getTo().getTag() == null && sipResponse.getStatusCode() != 100) {
                sipResponse.getTo().setTag(dialog.getLocalTag());
            }
            if ((fromTag = ((SIPRequest)this.getRequest()).getFrom().getTag()) != null && sipResponse.getFromTag() != null && !sipResponse.getFromTag().equals(fromTag)) {
                throw new SipException("From tag of response does not match sipResponse from tag");
            }
            if (fromTag != null) {
                sipResponse.getFrom().setTag(fromTag);
            } else if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("WARNING -- Null From tag in request!!");
            }
            if (dialog != null && response.getStatusCode() != 100) {
                if (!dialog.checkResponseTags(sipResponse)) {
                    throw new SipException("Response tags dont match with Dialog tags");
                }
                DialogState oldState = dialog.getState();
                dialog.setLastResponse(this, (SIPResponse)response);
                if (oldState == null && dialog.getState() == DialogState.TERMINATED) {
                    DialogTerminatedEvent event = new DialogTerminatedEvent(dialog.getSipProvider(), dialog);
                    dialog.getSipProvider().handleEvent(event, this);
                }
            } else if (dialog == null && this.getMethod().equals("INVITE") && this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask == null && response.getStatusCode() / 100 == 2) {
                String dialogId = ((SIPResponse)response).getDialogId(true);
                this.retransmissionAlertTimerTask = new RetransmissionAlertTimerTask(dialogId);
                this.sipStack.retransmissionAlertTransactions.put((Object)dialogId, (Object)this);
                this.sipStack.timer.schedule((TimerTask)this.retransmissionAlertTimerTask, 0L, 500L);
            }
            this.sendMessage((SIPResponse)response);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
        catch (ParseException ex1) {
            throw new SipException(ex1.getMessage());
        }
    }

    private TransactionState getRealState() {
        return super.getState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && TransactionState.TRYING == super.getState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(TransactionState newState) {
        if (newState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
        }
        super.setState(newState);
    }

    protected void startTransactionTimer() {
        if (this.sipStack.timer != null) {
            TransactionTimer myTimer = new TransactionTimer();
            this.sipStack.timer.schedule((TimerTask)myTimer, 0L, 500L);
        }
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sst = (SIPServerTransaction)other;
        return this.getBranch().equalsIgnoreCase(sst.getBranch());
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (this.sipStack.logWriter.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setDialog " + this + " dialog = " + sipDialog);
        }
        this.dialog = sipDialog;
        if (dialogId != null) {
            this.dialog.setAssigned();
        }
        if (this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask != null) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertTimerTask = null;
            this.sipStack.retransmissionAlertTransactions.remove((Object)this.retransmissionAlertTimerTask.dialogId);
        }
        this.retransmissionAlertEnabled = false;
    }

    public void terminate() throws ObjectInUseException {
        this.setState(TransactionState.TERMINATED);
        if (this.retransmissionAlertTimerTask != null) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertTimerTask = null;
            this.sipStack.retransmissionAlertTransactions.remove((Object)this.retransmissionAlertTimerTask.dialogId);
        }
    }

    protected void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (this.pendingReliableResponse != null) {
            throw new SipException("Unacknowledged response");
        }
        this.pendingReliableResponse = (SIPResponse)relResponse;
        RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
        if (relResponse.getHeader("RSeq") == null) {
            rseq = new RSeq();
            relResponse.setHeader(rseq);
        }
        try {
            ++this.rseqNumber;
            rseq.setSeqNumber(this.rseqNumber);
            this.lastResponse = (SIPResponse)relResponse;
            this.sendMessage((SIPMessage)((Object)relResponse));
            this.provisionalResponseTask = new ProvisionalResponseTask();
            this.sipStack.timer.schedule((TimerTask)this.provisionalResponseTask, 0L, 500L);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public SIPResponse getReliableProvisionalResponse() {
        return this.pendingReliableResponse;
    }

    public boolean prackRecieved() {
        if (this.pendingReliableResponse == null) {
            return false;
        }
        this.provisionalResponseTask.cancel();
        this.pendingReliableResponse = null;
        return true;
    }

    public void enableRetransmissionAlerts() throws SipException {
        if (this.getDialog() != null) {
            throw new SipException("Dialog associated with tx");
        }
        if (!this.getMethod().equals("INVITE")) {
            throw new SipException("Request Method must be INVITE");
        }
        this.retransmissionAlertEnabled = true;
    }

    public boolean isRetransmissionAlertEnabled() {
        return this.retransmissionAlertEnabled;
    }

    public void disableRetransmissionAlerts() {
        if (this.retransmissionAlertTimerTask != null && this.retransmissionAlertEnabled) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertEnabled = false;
            this.retransmissionAlertTimerTask = null;
            String dialogId = this.retransmissionAlertTimerTask.dialogId;
            this.sipStack.retransmissionAlertTransactions.remove((Object)dialogId);
        }
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setMapped(boolean b) {
        this.isMapped = true;
    }

    public void setPendingSubscribe(SIPClientTransaction pendingSubscribeClientTx) {
        this.pendingSubscribeTransaction = pendingSubscribeClientTx;
    }

    public void releaseSem() {
        if (this.pendingSubscribeTransaction != null) {
            this.pendingSubscribeTransaction.releaseSem();
        } else if (this.inviteTransaction != null && this.getMethod().equals("CANCEL")) {
            this.inviteTransaction.releaseSem();
        }
        super.releaseSem();
    }

    public void setInviteTransaction(SIPServerTransaction st) {
        this.inviteTransaction = st;
    }

    class TransactionTimer
    extends TimerTask {
        public TransactionTimer() {
            if (SIPServerTransaction.this.sipStack.logWriter.isLoggingEnabled()) {
                SIPServerTransaction.this.sipStack.logWriter.logDebug("TransactionTimer() : " + SIPServerTransaction.this.getTransactionId());
            }
        }

        public void run() {
            if (SIPServerTransaction.this.isTerminated()) {
                block4: {
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException ex) {
                        if (SIPServerTransaction.this.sipStack.isAlive()) break block4;
                        return;
                    }
                }
                SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer(SIPServerTransaction.this);
                SIPServerTransaction.this.sipStack.timer.schedule((TimerTask)myTimer, 8000L);
            } else {
                SIPServerTransaction.this.fireTimer();
            }
        }
    }

    class SendTrying
    extends TimerTask {
        protected SendTrying() {
            if (SIPServerTransaction.this.sipStack.isLoggingEnabled()) {
                SIPServerTransaction.this.sipStack.logWriter.logDebug("scheduled timer for " + SIPServerTransaction.this);
            }
        }

        public void run() {
            block5: {
                SIPServerTransaction serverTransaction = SIPServerTransaction.this;
                if (serverTransaction.getRealState() == null || TransactionState.TRYING == serverTransaction.getRealState()) {
                    if (SIPServerTransaction.this.sipStack.isLoggingEnabled()) {
                        SIPServerTransaction.this.sipStack.logWriter.logDebug(" sending Trying current state = " + serverTransaction.getRealState());
                    }
                    try {
                        serverTransaction.sendMessage(serverTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (serverTransaction.sipStack.isLoggingEnabled()) {
                            SIPServerTransaction.this.sipStack.logWriter.logDebug(" trying sent " + serverTransaction.getRealState());
                        }
                    }
                    catch (IOException ex) {
                        if (!serverTransaction.sipStack.isLoggingEnabled()) break block5;
                        SIPServerTransaction.this.sipStack.logWriter.logError("IO error sending  TRYING");
                    }
                }
            }
        }
    }

    class ProvisionalResponseTask
    extends TimerTask {
        int ticks;
        int ticksLeft;

        public ProvisionalResponseTask() {
            this.ticksLeft = this.ticks = 1;
        }

        public void run() {
            SIPServerTransaction serverTransaction = SIPServerTransaction.this;
            if (serverTransaction.isTerminated()) {
                this.cancel();
            } else {
                --this.ticksLeft;
                if (this.ticksLeft == -1) {
                    serverTransaction.fireReliableResponseRetransmissionTimer();
                    this.ticksLeft = 2 * this.ticks;
                }
            }
        }
    }

    class RetransmissionAlertTimerTask
    extends TimerTask {
        String dialogId;
        int ticks;
        int ticksLeft;

        public RetransmissionAlertTimerTask(String dialogId) {
            this.ticksLeft = this.ticks = 1;
        }

        public void run() {
            SIPServerTransaction serverTransaction = SIPServerTransaction.this;
            --this.ticksLeft;
            if (this.ticksLeft == -1) {
                serverTransaction.fireRetransmissionTimer();
                this.ticksLeft = 2 * this.ticks;
            }
        }
    }
}

