/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Vector;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;

public class Media
implements Field {
    private static final long serialVersionUID = 8009552820375695269L;
    protected String media;
    protected int port;
    protected int portsNumber;
    protected String protocol;
    protected Vector formats;

    protected Media() {
    }

    public Media(String media, int port, String protocol, String format) throws SdpException {
        this(media, port, 1, protocol, format);
    }

    public Media(String media, int port, int portsCount, String protocol, String format) throws SdpException {
        this.setMediaType(media);
        this.setPort(port);
        this.setPortsCount(portsCount);
        this.setProtocol(protocol);
        this.formats = new Vector(3);
        this.addMediaFormat(format);
    }

    public void addMediaFormat(String format) throws SdpException {
        if (!Pattern.matches("\\w+", format)) {
            throw new SdpException("Invalid media format : " + format);
        }
        this.formats.add(format);
    }

    public Object clone() {
        Media field = new Media();
        field.media = new String(this.media);
        field.port = this.port;
        field.portsNumber = this.portsNumber;
        field.protocol = new String(this.protocol);
        field.formats = (Vector)this.formats.clone();
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public char getFieldType() {
        return 'm';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer(this.media);
        result.append(" " + this.port);
        if (this.portsNumber > 1) {
            result.append("/" + this.portsNumber);
        }
        result.append(" " + this.protocol);
        for (int i = 0; i < this.formats.size(); ++i) {
            result.append(" " + this.formats.get(i));
        }
        return result.toString();
    }

    public String[] getMediaFormats() {
        return this.formats.toArray(new String[this.formats.size()]);
    }

    public String getMediaType() {
        return this.media;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortsCount() {
        return this.portsNumber;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setMediaFormats(String[] formats) throws SdpException {
        Vector temp = (Vector)this.formats.clone();
        this.formats.clear();
        try {
            for (int i = 0; i < formats.length; ++i) {
                this.addMediaFormat(formats[i]);
            }
        }
        catch (SdpException invalidFormat) {
            this.formats = temp;
            temp = null;
            throw new SdpException("Invalid media formats");
        }
    }

    public void setMediaType(String media) throws SdpException {
        if (!Pattern.matches("\\w+", media)) {
            throw new SdpException("Invalid media type : " + media);
        }
        this.media = media;
    }

    public void setPort(int port) throws SdpException {
        if (port < 0) {
            throw new SdpException("The transport port must be > 0");
        }
        this.port = port;
    }

    public void setPortsCount(int n) {
        if (n < 1) {
            throw new SdpException("The ports count must be > 0");
        }
        this.portsNumber = n;
    }

    public void setProtocol(String protocol) {
        if (!Pattern.matches("[\\w/]+", protocol)) {
            throw new SdpException("Invalid protocol : " + protocol);
        }
        this.protocol = protocol;
    }

    public String toString() {
        return "m=" + this.getFieldValue();
    }
}

