/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Bandwith;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Description;
import net.sourceforge.jsdp.Information;
import net.sourceforge.jsdp.Key;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.SdpElement;
import net.sourceforge.jsdp.SdpException;

public class MediaDescription
implements Description {
    private static final long serialVersionUID = 2260842521161330113L;
    protected Media m;
    protected Information i;
    protected Connection c;
    protected Hashtable bandwiths;
    protected Key k;
    protected Vector attributes;

    public MediaDescription(Media mediaField) throws SdpException {
        this.setMedia(mediaField);
        this.bandwiths = new Hashtable();
        this.attributes = new Vector();
    }

    public MediaDescription(MediaDescription mediaDescriptionObject) {
        this.m = (Media)mediaDescriptionObject.m.clone();
        this.i = (Information)mediaDescriptionObject.i.clone();
        this.c = (Connection)mediaDescriptionObject.c.clone();
        this.bandwiths = (Hashtable)mediaDescriptionObject.bandwiths.clone();
        this.k = (Key)mediaDescriptionObject.k.clone();
        this.attributes = (Vector)mediaDescriptionObject.attributes.clone();
    }

    public Object clone() {
        return new MediaDescription(this);
    }

    public String encode() {
        SdpElement e;
        int j;
        StringBuffer result = new StringBuffer();
        result.append(this.m.encode());
        if (this.i != null) {
            result.append(this.i.encode());
        }
        if (this.c != null) {
            result.append(this.c.encode());
        }
        Enumeration bandwithsEnum = this.bandwiths.elements();
        for (j = 0; j < this.bandwiths.size(); ++j) {
            e = (SdpElement)bandwithsEnum.nextElement();
            result.append(e.encode());
        }
        if (this.k != null) {
            result.append(this.k.encode());
        }
        for (j = 0; j < this.attributes.size(); ++j) {
            e = (SdpElement)this.attributes.get(j);
            result.append(e.encode());
        }
        return result.toString();
    }

    public Media getMedia() {
        return this.m;
    }

    public void setMedia(Media m) throws SdpException {
        if (m == null) {
            throw new SdpException();
        }
        this.m = m;
    }

    public Information getInformation() {
        return this.i;
    }

    public void setInformation(Information i) {
        this.i = i;
    }

    public Connection getConnection() {
        return this.c;
    }

    public boolean hasConnection() {
        return this.c != null;
    }

    public void setConnection(Connection c) {
        this.c = c;
    }

    public void clearBandwiths() {
        this.bandwiths.clear();
    }

    public Bandwith getBandwith(String modifier) {
        return (Bandwith)this.bandwiths.get(modifier);
    }

    public Bandwith[] getBandwiths() {
        Bandwith[] values = new Bandwith[this.bandwiths.size()];
        Enumeration enumeration = this.bandwiths.elements();
        for (int j = 0; j < values.length; ++j) {
            values[j] = (Bandwith)enumeration.nextElement();
        }
        return values;
    }

    public void removeBandwith(String modifier) {
        if (modifier != null) {
            this.bandwiths.remove(modifier);
        }
    }

    public void setBandwith(Bandwith bandwith) throws SdpException {
        if (bandwith == null) {
            throw new SdpException();
        }
        this.bandwiths.put(bandwith.getModifier(), bandwith);
    }

    public Key getKey() {
        return this.k;
    }

    public void setKey(Key k) {
        this.k = k;
    }

    public void addAttribute(Attribute field) throws SdpException {
        if (field == null) {
            throw new SdpException();
        }
        this.attributes.add(field);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Attribute[] getAttributes() {
        return this.attributes.toArray(new Attribute[this.attributes.size()]);
    }

    public void setAttributes(Attribute[] attributes) throws SdpException {
        Vector<Attribute> attributesTemp = new Vector<Attribute>(attributes.length);
        for (int j = 0; j < attributes.length; ++j) {
            if (attributes[j] == null) {
                throw new SdpException();
            }
            attributesTemp.add(attributes[j]);
        }
        this.attributes = attributesTemp;
    }

    public String toString() {
        return this.encode();
    }
}

