/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.Time;
import net.sourceforge.jsdp.util.Address;

public class Origin
implements Field {
    private static final long serialVersionUID = 8892230839201408790L;
    private String user;
    private long sessionID;
    private long sessionVersion;
    private Address address;

    private Origin(Origin origin) {
        this.user = new String(origin.user);
        this.sessionID = origin.sessionID;
        this.sessionVersion = origin.sessionVersion;
        this.address = (Address)origin.address.clone();
    }

    public Origin() throws SdpException {
        this.setUser(System.getProperty("user.name"));
        this.sessionID = Time.getNTP(new Date());
        this.sessionVersion = Time.getNTP(new Date());
        try {
            this.address = new Address(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException noLocalHost) {
            noLocalHost.printStackTrace();
            throw new SdpException();
        }
    }

    public Origin(String address) throws SdpException {
        this.setUser(System.getProperty("user.name"));
        this.sessionID = Time.getNTP(new Date());
        this.sessionVersion = Time.getNTP(new Date());
        this.address = new Address(address);
    }

    public Origin(long sessionVersion, String address) throws SdpException {
        this.setUser(System.getProperty("user.name"));
        this.sessionID = Time.getNTP(new Date());
        this.setSessionVersion(sessionVersion);
        this.address = new Address(address);
    }

    public Origin(String user, long sessionVersion, String address) throws SdpException {
        this.setUser(user);
        this.sessionID = Time.getNTP(new Date());
        this.setSessionVersion(sessionVersion);
        this.address = new Address(address);
    }

    public Origin(String user, long sessionID, long sessionVersion, String address) throws SdpException {
        this.setUser(user);
        this.setSessionID(sessionID);
        this.setSessionVersion(sessionVersion);
        this.address = new Address(address);
    }

    public Object clone() {
        return new Origin(this);
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public String getAddress() {
        return this.address.getAddress();
    }

    public String getAddressType() {
        return this.address.getAddressType();
    }

    public char getFieldType() {
        return 'o';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer();
        result.append(this.user + " ");
        result.append(this.sessionID + " ");
        result.append(this.sessionVersion);
        result.append(" IN ");
        result.append(this.address.toString());
        return result.toString();
    }

    public String getNetType() {
        return "IN";
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public long getSessionVersion() {
        return this.sessionVersion;
    }

    public String getUser() {
        return this.user;
    }

    public void setAddress(String address) throws SdpException {
        this.address.setAddress(address);
    }

    public void setSessionID(long sessionID) throws SdpException {
        if (sessionID < 0L) {
            throw new SdpException();
        }
        this.sessionID = sessionID;
    }

    public void setSessionVersion(long sessionVersion) throws SdpException {
        if (sessionVersion < 0L) {
            throw new SdpException();
        }
        this.sessionVersion = sessionVersion;
    }

    public void setUser(String user) throws SdpException {
        if (!Pattern.matches("[\\w'-\\./:?#\\$&\\*;=@\\[\\]\\^_`\\{\\}\\|\\+\\~]+", user)) {
            throw new SdpException("Invalid user name : " + user);
        }
        this.user = user;
    }

    public String toString() {
        return "o=" + this.getFieldValue();
    }
}

