/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Vector;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.util.TypedTime;

public class RepeatTime
implements Field {
    private static final long serialVersionUID = -7772961172651467572L;
    protected long repeatInterval;
    protected long activeDuration;
    protected Vector offsets;
    protected boolean isTyped;

    protected RepeatTime() {
    }

    public RepeatTime(long repeatInterval, long activeDuration, long offset) throws SdpException {
        this.isTyped = true;
        this.setActiveDuration(activeDuration);
        this.setRepeatInterval(repeatInterval);
        this.offsets = new Vector(3);
        this.addOffset(offset);
    }

    public RepeatTime(long repeatInterval, long activeDuration, long[] offsets) throws SdpException {
        this.isTyped = true;
        this.setRepeatInterval(repeatInterval);
        this.setActiveDuration(activeDuration);
        this.offsets = new Vector(offsets.length);
        for (int i = 0; i < offsets.length; ++i) {
            this.addOffset(offsets[i]);
        }
    }

    public void addOffset(long offset) throws SdpException {
        if (offset < 0L) {
            throw new SdpException("Offset must be >= 0");
        }
        this.offsets.add(new Long(offset));
    }

    public Object clone() {
        RepeatTime field = new RepeatTime();
        field.isTyped = this.isTyped;
        field.activeDuration = this.activeDuration;
        field.repeatInterval = this.repeatInterval;
        field.offsets = (Vector)this.offsets.clone();
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public long getActiveDuration() {
        return this.activeDuration;
    }

    public char getFieldType() {
        return 'r';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer(this.repeatInterval + " ");
        if (this.isTyped) {
            result.append(TypedTime.toString(this.activeDuration));
            for (int i = 0; i < this.offsets.size(); ++i) {
                Long offset = (Long)this.offsets.get(i);
                result.append(" " + TypedTime.toString(offset));
            }
        } else {
            result.append(this.activeDuration);
            for (int i = 0; i < this.offsets.size(); ++i) {
                result.append(" " + this.offsets.get(i));
            }
        }
        return result.toString();
    }

    public long[] getOffsets() {
        long[] values = new long[this.offsets.size()];
        for (int i = 0; i < values.length; ++i) {
            Long offset = (Long)this.offsets.get(i);
            values[i] = offset;
        }
        return values;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public boolean isTypedTime() {
        return this.isTyped;
    }

    public void setActiveDuration(long activeDuration) throws SdpException {
        if (activeDuration < 0L) {
            throw new SdpException("The active duration is < 0");
        }
        this.activeDuration = activeDuration;
    }

    public void setRepeatInterval(long repeatInterval) throws SdpException {
        if (repeatInterval < 0L) {
            throw new SdpException("The repeat interval is < 0");
        }
        this.repeatInterval = repeatInterval;
    }

    public void setTypedTime(boolean typedTime) {
        this.isTyped = typedTime;
    }

    public void setOffset(long[] offsets) throws SdpException {
        Vector<Long> temp = new Vector<Long>(offsets.length);
        for (int i = 0; i < offsets.length; ++i) {
            if (offsets[i] < 0L) {
                throw new SdpException("Offsets must be >= 0");
            }
            temp.add(new Long(offsets[i]));
        }
        this.offsets = temp;
    }

    public String toString() {
        return "r=" + this.getFieldValue();
    }
}

