/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Bandwith;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Description;
import net.sourceforge.jsdp.Email;
import net.sourceforge.jsdp.Information;
import net.sourceforge.jsdp.Key;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.Origin;
import net.sourceforge.jsdp.Phone;
import net.sourceforge.jsdp.SdpElement;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.SessionName;
import net.sourceforge.jsdp.TimeDescription;
import net.sourceforge.jsdp.TimeZone;
import net.sourceforge.jsdp.Uri;
import net.sourceforge.jsdp.Version;

public class SessionDescription
implements Description {
    private static final long serialVersionUID = -2804972731894656668L;
    protected Version v;
    protected Origin o;
    protected SessionName s;
    protected Information i;
    protected Uri u;
    protected Vector emails;
    protected Vector phones;
    protected Connection c;
    protected Hashtable bandwiths;
    protected Vector timeDescriptions;
    protected TimeZone z;
    protected Key k;
    protected Hashtable attributes;
    protected Vector mediaDescriptions;

    public SessionDescription(Version versionField, Origin originField, SessionName sessionNameField, TimeDescription timeDescription) throws SdpException {
        this.setVersion(versionField);
        this.setOrigin(originField);
        this.setSessionName(sessionNameField);
        this.emails = new Vector();
        this.phones = new Vector();
        this.bandwiths = new Hashtable();
        this.timeDescriptions = new Vector();
        this.addTimeDescription(timeDescription);
        this.attributes = new Hashtable();
        this.mediaDescriptions = new Vector();
    }

    public SessionDescription(SessionDescription sessionDescriptionObject) {
        this.v = (Version)sessionDescriptionObject.v.clone();
        this.o = (Origin)sessionDescriptionObject.o.clone();
        this.s = (SessionName)sessionDescriptionObject.s.clone();
        this.i = (Information)sessionDescriptionObject.i.clone();
        this.u = (Uri)sessionDescriptionObject.u.clone();
        this.emails = (Vector)sessionDescriptionObject.emails.clone();
        this.phones = (Vector)sessionDescriptionObject.phones.clone();
        this.c = (Connection)sessionDescriptionObject.c.clone();
        this.bandwiths = (Hashtable)sessionDescriptionObject.bandwiths.clone();
        this.timeDescriptions = (Vector)sessionDescriptionObject.timeDescriptions.clone();
        this.z = (TimeZone)sessionDescriptionObject.z.clone();
        this.attributes = (Hashtable)sessionDescriptionObject.attributes.clone();
        this.mediaDescriptions = (Vector)sessionDescriptionObject.mediaDescriptions.clone();
    }

    public Object clone() {
        return new SessionDescription(this);
    }

    public String encode() {
        SdpElement e;
        int j;
        SdpElement e2;
        int j2;
        SdpElement e3;
        int j3;
        StringBuffer result = new StringBuffer();
        result.append(this.v.encode());
        result.append(this.o.encode());
        result.append(this.s.encode());
        if (this.i != null) {
            result.append(this.i.encode());
        }
        if (this.u != null) {
            result.append(this.u.encode());
        }
        for (j3 = 0; j3 < this.emails.size(); ++j3) {
            e3 = (SdpElement)this.emails.get(j3);
            result.append(e3.encode());
        }
        for (j3 = 0; j3 < this.phones.size(); ++j3) {
            e3 = (SdpElement)this.phones.get(j3);
            result.append(e3.encode());
        }
        if (this.c != null) {
            result.append(this.c.encode());
        }
        Enumeration bandwithsEnum = this.bandwiths.elements();
        for (j2 = 0; j2 < this.bandwiths.size(); ++j2) {
            e2 = (SdpElement)bandwithsEnum.nextElement();
            result.append(e2.encode());
        }
        for (j2 = 0; j2 < this.timeDescriptions.size(); ++j2) {
            e2 = (SdpElement)this.timeDescriptions.get(j2);
            result.append(e2.encode());
        }
        if (this.z != null) {
            result.append(this.z.encode());
        }
        if (this.k != null) {
            result.append(this.k.encode());
        }
        Enumeration attributesEnum = this.attributes.elements();
        for (j = 0; j < this.attributes.size(); ++j) {
            e = (SdpElement)attributesEnum.nextElement();
            result.append(e.encode());
        }
        for (j = 0; j < this.mediaDescriptions.size(); ++j) {
            e = (SdpElement)this.mediaDescriptions.get(j);
            result.append(e.encode());
        }
        return result.toString();
    }

    public Version getVersion() {
        return this.v;
    }

    public void setVersion(Version v) throws SdpException {
        if (v == null) {
            throw new SdpException();
        }
        this.v = v;
    }

    public Origin getOrigin() {
        return this.o;
    }

    public void setOrigin(Origin o) throws SdpException {
        if (o == null) {
            throw new SdpException();
        }
        this.o = o;
    }

    public SessionName getSessionName() {
        return this.s;
    }

    public void setSessionName(SessionName s) throws SdpException {
        if (s == null) {
            throw new SdpException();
        }
        this.s = s;
    }

    public Information getInformation() {
        return this.i;
    }

    public void setInformation(Information i) {
        this.i = i;
    }

    public Uri getUri() {
        return this.u;
    }

    public void setUri(Uri u) {
        this.u = u;
    }

    public void addEmail(Email field) throws SdpException {
        if (field == null) {
            throw new SdpException();
        }
        this.emails.add(field);
    }

    public void clearEmails() {
        this.emails.clear();
    }

    public Email[] getEmails() {
        return this.emails.toArray(new Email[this.emails.size()]);
    }

    public void setEmails(Email[] emails) throws SdpException {
        Vector<Email[]> emailsTemp = new Vector<Email[]>(emails.length);
        for (int j = 0; j < emails.length; ++j) {
            if (emails[j] == null) {
                throw new SdpException();
            }
            emailsTemp.add(emails);
        }
        this.emails = emailsTemp;
    }

    public void addPhone(Phone field) throws SdpException {
        if (field == null) {
            throw new SdpException();
        }
        this.phones.add(field);
    }

    public void clearPhones() {
        this.phones.clear();
    }

    public Phone[] getPhones() {
        return this.phones.toArray(new Phone[this.phones.size()]);
    }

    public void setPhones(Phone[] phones) throws SdpException {
        Vector<Phone[]> phonesTemp = new Vector<Phone[]>(phones.length);
        for (int j = 0; j < phones.length; ++j) {
            if (phones[j] == null) {
                throw new SdpException();
            }
            phonesTemp.add(phones);
        }
        this.phones = phonesTemp;
    }

    public Connection getConnection() {
        return this.c;
    }

    public boolean hasConnection() {
        return this.c != null;
    }

    public void setConnection(Connection c) {
        this.c = c;
    }

    public void clearBandwiths() {
        this.bandwiths.clear();
    }

    public Bandwith getBandwith(String modifier) {
        return (Bandwith)this.bandwiths.get(modifier);
    }

    public Bandwith[] getBandwiths() {
        Bandwith[] values = new Bandwith[this.bandwiths.size()];
        Enumeration enumeration = this.bandwiths.elements();
        for (int j = 0; j < values.length; ++j) {
            values[j] = (Bandwith)enumeration.nextElement();
        }
        return values;
    }

    public void removeBandwith(String modifier) {
        if (modifier != null) {
            this.bandwiths.remove(modifier);
        }
    }

    public void setBandwith(Bandwith bandwith) throws SdpException {
        if (bandwith == null) {
            throw new SdpException();
        }
        this.bandwiths.put(bandwith.getModifier(), bandwith);
    }

    public void addTimeDescription(TimeDescription element) throws SdpException {
        if (element == null) {
            throw new SdpException();
        }
        this.timeDescriptions.add(element);
    }

    public TimeDescription[] getTimeDescriptions() {
        return this.timeDescriptions.toArray(new TimeDescription[this.timeDescriptions.size()]);
    }

    public void setTimeDescriptions(TimeDescription[] timeDescriptions) throws SdpException {
        if (timeDescriptions == null) {
            throw new SdpException();
        }
        Vector<TimeDescription[]> timeDescriptionsTemp = new Vector<TimeDescription[]>(timeDescriptions.length);
        for (int j = 0; j < timeDescriptions.length; ++j) {
            if (timeDescriptions[j] == null) {
                throw new SdpException();
            }
            timeDescriptionsTemp.add(timeDescriptions);
        }
        this.timeDescriptions = timeDescriptionsTemp;
    }

    public TimeZone getTimeZone() {
        return this.z;
    }

    public void setTimeZone(TimeZone z) {
        this.z = z;
    }

    public Key getKey() {
        return this.k;
    }

    public void setKey(Key k) {
        this.k = k;
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Attribute getAttribute(String name) {
        return (Attribute)this.attributes.get(name);
    }

    public Attribute[] getAttributes() {
        Attribute[] values = new Attribute[this.attributes.size()];
        Enumeration enumeration = this.attributes.elements();
        for (int j = 0; j < values.length; ++j) {
            values[j] = (Attribute)enumeration.nextElement();
        }
        return values;
    }

    public void removeAttribute(String name) {
        if (name != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(Attribute attribute) throws SdpException {
        if (attribute == null) {
            throw new SdpException();
        }
        this.attributes.put(attribute.getName(), attribute);
    }

    public void addMediaDescription(MediaDescription element) throws SdpException {
        if (element == null) {
            throw new SdpException("The media description is null");
        }
        if (!this.hasConnection() && !element.hasConnection()) {
            throw new SdpException("The media description must have a connection field");
        }
        this.mediaDescriptions.add(element);
    }

    public void clearMediaDescriptions() {
        this.mediaDescriptions.clear();
    }

    public MediaDescription[] getMediaDescriptions() {
        return this.mediaDescriptions.toArray(new MediaDescription[this.mediaDescriptions.size()]);
    }

    public void setMediaDescriptions(MediaDescription[] mediaDescriptions) throws SdpException {
        Vector<MediaDescription[]> mediaDescriptionsTemp = new Vector<MediaDescription[]>(mediaDescriptions.length);
        for (int j = 0; j < mediaDescriptions.length; ++j) {
            if (mediaDescriptions[j] == null) {
                throw new SdpException();
            }
            mediaDescriptionsTemp.add(mediaDescriptions);
        }
        this.mediaDescriptions = mediaDescriptionsTemp;
    }

    public String toString() {
        return this.encode();
    }
}

