/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.Date;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;

public class Time
implements Field {
    private static final long serialVersionUID = -4529219101991941664L;
    public static final long NTP_CONSTANT = 2208988800L;
    protected long startTime;
    protected long stopTime;

    public Time() {
        this.setZero();
    }

    public Time(long startTime, long stopTime) throws SdpException {
        this.setStartTime(startTime);
        this.setStopTime(stopTime);
    }

    public Time(Date startTime, Date stopTime) {
        this.setStartTime(startTime);
        this.setStopTime(stopTime);
    }

    public Object clone() {
        Time field = new Time();
        field.startTime = this.startTime;
        field.stopTime = this.stopTime;
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public char getFieldType() {
        return 't';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer();
        result.append(this.startTime);
        result.append(" ");
        result.append(this.stopTime);
        return result.toString();
    }

    public Date getStartTime() {
        return Time.getDateFromNtp(this.startTime);
    }

    public Date getStopTime() {
        return Time.getDateFromNtp(this.stopTime);
    }

    public static Date getDateFromNtp(long ntpTime) {
        return new Date((ntpTime - 2208988800L) * 1000L);
    }

    public static long getNTP(Date date) {
        long result = 0L;
        result = date == null ? -1L : date.getTime() / 1000L + 2208988800L;
        return result;
    }

    public static boolean isValidNTP(String input) {
        return Pattern.matches("[1-9](\\d){0,9})", input);
    }

    public boolean isZero() {
        return this.stopTime == 0L && this.startTime == 0L;
    }

    public void setStartTime(long startTime) throws SdpException {
        if (startTime < 0L) {
            throw new SdpException("The session start time must be >= 0");
        }
        this.startTime = startTime;
    }

    public void setStartTime(Date start) throws SdpException {
        if (start == null) {
            throw new SdpException("The date is null");
        }
        this.setStartTime(Time.getNTP(start));
    }

    public void setStopTime(long stopTime) throws SdpException {
        if (stopTime < 0L) {
            throw new SdpException("The session stop time must be >= 0");
        }
        this.stopTime = stopTime;
    }

    public void setStopTime(Date stop) throws SdpException {
        if (stop == null) {
            throw new SdpException("The date is null");
        }
        this.setStopTime(Time.getNTP(stop));
    }

    public void setZero() {
        this.startTime = 0L;
        this.stopTime = 0L;
    }

    public String toString() {
        return "t=" + this.getFieldValue();
    }
}

