/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Bandwith;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Email;
import net.sourceforge.jsdp.Information;
import net.sourceforge.jsdp.Key;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.Origin;
import net.sourceforge.jsdp.Phone;
import net.sourceforge.jsdp.RepeatTime;
import net.sourceforge.jsdp.SessionName;
import net.sourceforge.jsdp.Time;
import net.sourceforge.jsdp.TimeZone;
import net.sourceforge.jsdp.Uri;
import net.sourceforge.jsdp.Version;
import net.sourceforge.jsdp.parser.AttributeParser;
import net.sourceforge.jsdp.parser.BandwithParser;
import net.sourceforge.jsdp.parser.ConnectionParser;
import net.sourceforge.jsdp.parser.EmailParser;
import net.sourceforge.jsdp.parser.InformationParser;
import net.sourceforge.jsdp.parser.KeyParser;
import net.sourceforge.jsdp.parser.MediaParser;
import net.sourceforge.jsdp.parser.OriginParser;
import net.sourceforge.jsdp.parser.PhoneParser;
import net.sourceforge.jsdp.parser.RepeatTimeParser;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.SessionNameParser;
import net.sourceforge.jsdp.parser.TimeParser;
import net.sourceforge.jsdp.parser.TimeZoneParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;
import net.sourceforge.jsdp.parser.UnknowFieldException;
import net.sourceforge.jsdp.parser.UriParser;
import net.sourceforge.jsdp.parser.VersionParser;

public class ParserFactory {
    private static Hashtable parserTable;
    private static Class[] constructorArgs;
    private static HashMap fieldTable;

    private ParserFactory() {
    }

    public static SdpFieldParser getParser(Class field, String value) throws UnknowFieldException, UnexpectedFieldException {
        SdpFieldParser parser;
        Class parserClass = (Class)parserTable.get(field);
        if (parserClass != null) {
            try {
                Constructor constructor = parserClass.getConstructor(constructorArgs);
                Object[] args = new Object[]{value};
                parser = (SdpFieldParser)constructor.newInstance(args);
            }
            catch (Exception ex) {
                throw new UnexpectedFieldException();
            }
        } else {
            throw new UnknowFieldException("Unknown field : " + field);
        }
        return parser;
    }

    static {
        constructorArgs = new Class[1];
        ParserFactory.constructorArgs[0] = String.class;
        parserTable = new Hashtable(15, 1.0f);
        parserTable.put(Attribute.class, AttributeParser.class);
        parserTable.put(Bandwith.class, BandwithParser.class);
        parserTable.put(Connection.class, ConnectionParser.class);
        parserTable.put(Email.class, EmailParser.class);
        parserTable.put(Information.class, InformationParser.class);
        parserTable.put(Key.class, KeyParser.class);
        parserTable.put(Media.class, MediaParser.class);
        parserTable.put(Origin.class, OriginParser.class);
        parserTable.put(Phone.class, PhoneParser.class);
        parserTable.put(RepeatTime.class, RepeatTimeParser.class);
        parserTable.put(SessionName.class, SessionNameParser.class);
        parserTable.put(Time.class, TimeParser.class);
        parserTable.put(TimeZone.class, TimeZoneParser.class);
        parserTable.put(Uri.class, UriParser.class);
        parserTable.put(Version.class, VersionParser.class);
        fieldTable = new HashMap(15, 1.0f);
        fieldTable.put("a", null);
        fieldTable.put("b", null);
        fieldTable.put("c", null);
        fieldTable.put("e", null);
        fieldTable.put("i", null);
        fieldTable.put("k", null);
        fieldTable.put("m", null);
        fieldTable.put("o", null);
        fieldTable.put("p", null);
        fieldTable.put("r", null);
        fieldTable.put("s", null);
        fieldTable.put("t", null);
        fieldTable.put("z", null);
        fieldTable.put("u", null);
        fieldTable.put("v", null);
    }
}

