/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.RepeatTime;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;
import net.sourceforge.jsdp.util.TypedTime;

public class RepeatTimeParser
extends SdpFieldParser {
    public RepeatTimeParser(String input) {
        super(input);
    }

    public Field parse() throws UnexpectedFieldException, SdpException {
        if (!this.type.equals("r=")) {
            throw new UnexpectedFieldException("This is not a RepeatTime field : " + this.type + this.value);
        }
        String[] values = this.value.split(" ");
        switch (values.length) {
            case 0: {
                throw new SdpException();
            }
            case 1: {
                throw new SdpException();
            }
            case 2: {
                throw new SdpException();
            }
        }
        long repeatInterval = TypedTime.getTime(values[0]);
        long activeDuration = TypedTime.getTime(values[1]);
        long[] offsets = new long[values.length - 2];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = TypedTime.getTime(values[i + 2]);
        }
        return new RepeatTime(repeatInterval, activeDuration, offsets);
    }
}

