/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.TimeZone;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;
import net.sourceforge.jsdp.util.TypedTime;
import net.sourceforge.jsdp.util.ZoneAdjustment;

public class TimeZoneParser
extends SdpFieldParser {
    public TimeZoneParser(String input) {
        super(input);
    }

    private ZoneAdjustment createZoneAdjustment(String adjustment, String offset) throws SdpException {
        ZoneAdjustment zone = null;
        try {
            zone = new ZoneAdjustment(Long.parseLong(adjustment), TypedTime.getTime(offset));
        }
        catch (Exception anyException) {
            anyException.printStackTrace();
            throw new SdpException();
        }
        return zone;
    }

    public Field parse() throws UnexpectedFieldException, SdpException {
        if (!this.type.equals("z=")) {
            throw new UnexpectedFieldException("This is not a TimeZone field : " + this.type + this.value);
        }
        String[] values = this.value.split(" ");
        if (values.length < 2 || values.length % 2 != 0) {
            throw new SdpException();
        }
        TimeZone field = new TimeZone(this.createZoneAdjustment(values[0], values[1]));
        for (int i = 2; i < values.length; i += 2) {
            field.addZoneAdjustment(this.createZoneAdjustment(values[i], values[i + 1]));
        }
        return field;
    }
}

