/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;

public class SdpMessageParserApplet
extends JApplet {
    private static final long serialVersionUID = -1939523078186985634L;
    private static final String ABOUT = "jSDP : A Java implementation of SDP protocol\n\nCopyright \ufffd 2004 Claudio Di Vita\n\nVersion 0.1.2 - 7 June 2004\n\n";
    private JButton aboutButton;
    private JPanel buttonPanel;
    private JTextArea messageArea;
    private JScrollPane scrollPane;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JButton validateButton;

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception lookAndFeelException) {
            lookAndFeelException.printStackTrace();
        }
        this.initComponents();
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.messageArea = new JTextArea();
        this.buttonPanel = new JPanel();
        this.validateButton = new JButton();
        this.aboutButton = new JButton();
        this.setFont(new Font("Default", 0, 10));
        this.titlePanel.setFont(new Font("Default", 0, 11));
        this.titleLabel.setFont(new Font("Default", 0, 14));
        this.titleLabel.setText("SDP Message validation");
        this.titlePanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setFont(new Font("Default", 0, 11));
        this.scrollPane.setMinimumSize(new Dimension(200, 150));
        this.scrollPane.setPreferredSize(new Dimension(500, 350));
        this.messageArea.setMargin(new Insets(2, 5, 2, 5));
        this.messageArea.setMaximumSize(null);
        this.messageArea.setMinimumSize(null);
        this.messageArea.setPreferredSize(null);
        this.scrollPane.setViewportView(this.messageArea);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonPanel.setFont(new Font("Default", 0, 11));
        this.validateButton.setFont(new Font("Default", 0, 11));
        this.validateButton.setMnemonic('v');
        this.validateButton.setText("Validate");
        this.validateButton.setToolTipText("Validate the SDP message");
        this.validateButton.setMaximumSize(new Dimension(75, 25));
        this.validateButton.setMinimumSize(new Dimension(75, 25));
        this.validateButton.setPreferredSize(new Dimension(75, 25));
        this.validateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserApplet.this.validateButtonActionPerformed(event);
            }
        });
        this.buttonPanel.add(this.validateButton);
        this.aboutButton.setFont(new Font("Default", 0, 11));
        this.aboutButton.setMnemonic('a');
        this.aboutButton.setText("About");
        this.aboutButton.setToolTipText("About this applet");
        this.aboutButton.setMaximumSize(new Dimension(75, 25));
        this.aboutButton.setMinimumSize(new Dimension(75, 25));
        this.aboutButton.setPreferredSize(new Dimension(75, 25));
        this.aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserApplet.this.aboutButtonActionPerformed(event);
            }
        });
        this.buttonPanel.add(this.aboutButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    private void aboutButtonActionPerformed(ActionEvent event) {
        JOptionPane.showMessageDialog(this, ABOUT, "About jSDP", 1);
    }

    private void validateButtonActionPerformed(ActionEvent event) {
        this.validateMessage();
    }

    private SessionDescription validateMessage() {
        SessionDescription message = null;
        try {
            message = SdpMessageParser.getSessionDescription(this.messageArea.getText());
            JOptionPane.showMessageDialog(this, "This is a valid SDP message !!!", "jSDP 0.1.2", 1);
        }
        catch (UnexpectedFieldException unexpectedField) {
            JOptionPane.showMessageDialog(this, unexpectedField.getMessage(), "jSDP 0.1.2", 0);
        }
        catch (SdpException invalidSyntax) {
            JOptionPane.showMessageDialog(this, invalidSyntax.getMessage(), "jSDP 0.1.2", 0);
        }
        return message;
    }
}

