/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.util;

import net.sourceforge.jsdp.util.Address;
import net.sourceforge.jsdp.util.InvalidValueException;

public class Resource
extends Address {
    private static final long serialVersionUID = 1512624495750991087L;
    protected int ttl;
    protected int addresses;

    protected Resource() {
    }

    public Resource(String address) throws InvalidValueException {
        if (address == null) {
            throw new InvalidValueException("Invalid resource");
        }
        String[] values = address.split("/");
        switch (values.length) {
            case 1: {
                this.setAddress(values[0]);
                this.ttl = 0;
                this.addresses = 1;
                break;
            }
            case 2: {
                this.setAddress(values[0]);
                this.setTTL(Integer.parseInt(values[1]));
                this.addresses = 1;
                break;
            }
            case 3: {
                this.setAddress(values[0]);
                this.setTTL(Integer.parseInt(values[1]));
                this.setAddresses(Integer.parseInt(values[2]));
                break;
            }
            default: {
                throw new InvalidValueException("Invalid resource");
            }
        }
    }

    public Resource(String address, int ttl) throws InvalidValueException {
        super(address);
        this.setTTL(ttl);
        this.addresses = 1;
    }

    public Resource(String address, int ttl, int addresses) throws InvalidValueException {
        super(address);
        this.setTTL(ttl);
        this.setAddresses(addresses);
    }

    public Object clone() {
        Resource host = new Resource();
        host.addressType = this.addressType;
        host.address = new String(this.address);
        host.ttl = this.ttl;
        host.addresses = this.addresses;
        return host;
    }

    public int getTTL() {
        return this.ttl;
    }

    public boolean hasTTL() {
        return this.ttl > 0;
    }

    public void removeTTL() {
        this.ttl = 0;
        this.addresses = 1;
    }

    public void setTTL(int ttl) throws InvalidValueException {
        if (ttl < 1 || ttl > 255) {
            throw new InvalidValueException();
        }
        this.ttl = ttl;
    }

    public void setAddresses(int addresses) throws InvalidValueException {
        if (addresses < 1) {
            throw new InvalidValueException();
        }
        this.addresses = addresses;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        if (this.hasTTL()) {
            result.append("/" + this.ttl);
            if (this.addresses > 1) {
                result.append("/" + this.addresses);
            }
        }
        return result.toString();
    }
}

