/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import net.sourceforge.jsdp.SessionDescription;

public abstract class AbstractEntity
extends EntityImpl {
    public static EventDispatcher dispatcher = TupleSpaceAdapter.getInstance();

    public AbstractEntity() {
        this.init();
    }

    public abstract void init();

    public abstract void receiveMessage(EntityEvent var1);

    public boolean sendOffer(SessionDescription sdp, Entity target) {
        if (sdp == null) {
            return false;
        }
        if (!this.isLocal()) {
            return false;
        }
        EntityEvent evt = new EntityEvent(sdp, (EntityListener)target, (Entity)this);
        evt.setEventType(EntityEvent.EventType.OFFER);
        dispatcher.dispatchEvent(evt);
        return true;
    }

    public void sendMessage(String msg) {
        EntityContainer target = this.getContainer();
        EntityEvent e = new EntityEvent(msg, (EntityListener)target, (Entity)this);
        e.setBroadcast(true);
        dispatcher.dispatchEvent(e);
    }

    public void sendMessage(String msg, String targetName) {
        if (!this.hasParent()) {
            throw new NullPointerException("Container is null!!");
        }
        Entity target = this.getContainer().getEntity(targetName);
        if (target == null) {
            return;
        }
        EntityEvent e = new EntityEvent(msg, (EntityListener)target, (Entity)this);
        dispatcher.dispatchEvent(e);
    }

    public void sendMessage(String msg, EntityListener target) {
        if (!this.hasParent()) {
            throw new NullPointerException("Container is null!!");
        }
        EntityEvent e = new EntityEvent(msg, target, (Entity)this);
        dispatcher.dispatchEvent(e);
    }

    public boolean sendBye(EntityListener target) {
        EntityEvent evt = new EntityEvent(target, this, EntityEvent.EventType.BYE);
        dispatcher.dispatchEvent(evt);
        return true;
    }
}

