/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestMessage {
    String methodName;
    static String[] supports = new String[]{"String", "Integer", "Float", "Long"};
    List paramList = new ArrayList();

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public Object[] getParamList() {
        Object[] params = this.paramList.size() != 0 ? this.paramList.toArray() : null;
        return params;
    }

    public void addParam(Object param) {
        this.paramList.add(param);
    }

    public String toXMLForm() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version='1.0' encoding='UTF-8' ?>\r\n");
        builder.append("<message>");
        builder.append("<method>");
        builder.append(this.methodName);
        builder.append("</method>");
        this.getParamXMLForm(builder);
        builder.append("</message>");
        return builder.toString();
    }

    private void getParamXMLForm(StringBuilder builder) {
        if (this.paramList.size() != 0) {
            builder.append("<paramList>");
            for (Object obj : this.paramList) {
                builder.append("<param>");
                if (obj instanceof String) {
                    builder.append("<String>");
                    builder.append((String)obj);
                    builder.append("</String>");
                } else if (obj instanceof Integer) {
                    builder.append("<Integer>");
                    builder.append((Integer)obj);
                    builder.append("</Integer>");
                } else if (obj instanceof Float) {
                    builder.append("<Float>");
                    builder.append(((Float)obj).floatValue());
                    builder.append("</Float>");
                } else if (obj instanceof Long) {
                    builder.append("<Long>");
                    builder.append((Long)obj);
                    builder.append("</Long>");
                } else {
                    System.err.println("Not Support Type: " + obj.getClass().toString());
                    throw new UnsupportedOperationException("Not Support Type: " + obj.getClass().toString());
                }
                builder.append("</param>");
            }
            builder.append("</paramList>");
        }
    }

    public static RequestMessage parse(Document doc) throws ParseException {
        RequestMessage message = new RequestMessage();
        Element root = doc.getDocumentElement();
        Node method = root.getFirstChild();
        Node paramList = method.getNextSibling();
        message.methodName = method.getFirstChild().getNodeValue();
        if (paramList == null) {
            return message;
        }
        NodeList list = paramList.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            Node typeNode = node.getFirstChild();
            String type = typeNode.getNodeName();
            String value = typeNode.getFirstChild().getNodeValue();
            if (type.equals("String")) {
                message.addParam(value);
            } else if (type.equals("Integer")) {
                message.addParam(Integer.valueOf(value));
            } else if (type.equals("Float")) {
                message.addParam(Float.valueOf(value));
            } else {
                new UnsupportedOperationException("Invalid Type :" + type);
            }
            ++i;
        }
        return message;
    }

    public static RequestMessage parse(String doc) throws ParseException {
        RequestMessage message = new RequestMessage();
        int begin = RequestMessage.getPosition(doc, "<method>");
        int end = doc.indexOf("</method>");
        if (begin < 0 || end < 0) {
            throw new ParseException("Invalid message : " + doc, begin);
        }
        String temp = doc.substring(begin, end);
        message.setMethod(temp);
        begin = RequestMessage.getPosition(doc, "<paramList>");
        end = doc.indexOf("</paramList>");
        temp = doc.substring(begin, end);
        while ((begin = RequestMessage.getPosition(temp, "<param>")) != -1 && !temp.equals("")) {
            end = temp.indexOf("</param>");
            String param = temp.substring(begin, end);
            Object obj = RequestMessage.findParam(param);
            message.addParam(obj);
            temp = temp.substring(end + "</param>".length());
        }
        return message;
    }

    private static Object findParam(String param) {
        int i = 0;
        Object retval = null;
        String[] stringArray = supports;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String support = stringArray[n];
            String start_tag = "<" + support + ">";
            String end_tag = "</" + support + ">";
            int begin = param.indexOf(start_tag);
            if (begin != -1) {
                int end = param.indexOf(end_tag);
                String value = param.substring(begin += start_tag.length(), end);
                switch (i) {
                    case 0: {
                        retval = value;
                        break;
                    }
                    case 1: {
                        retval = Integer.parseInt(value);
                        break;
                    }
                    case 2: {
                        retval = Float.valueOf(Float.parseFloat(value));
                        break;
                    }
                    case 3: {
                        retval = Long.parseLong(value);
                    }
                }
                return retval;
            }
            ++i;
            ++n;
        }
        throw new UnsupportedOperationException("Invalid Value : " + param);
    }

    private static int getPosition(String doc, String str) {
        return doc.indexOf(str) + str.length();
    }

    public String toString() {
        String temp = "Method :" + this.methodName + ", Param :";
        for (Object obj : this.paramList) {
            temp = String.valueOf(temp) + obj.toString() + ", ";
        }
        return temp;
    }
}

