/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Set;
import javax.media.MediaException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.MediaReceiver;
import net.sourceforge.jsdp.SessionDescription;

public class MediaReceiverEntity
extends AbstractEntity
implements MediaListener {
    MediaReceiver receiver;
    ButtonFrame button;
    JTextArea field = new JTextArea();
    Entity callee;
    Component prev;

    public void init() {
        this.setName("VideoReceiver");
        this.setEntityType(EntityType.MEDIA_RECEIVER);
        this.receiver = new MediaReceiver();
        this.receiver.addMediaListener(this);
        this.button = new ButtonFrame("MediaSender");
    }

    public void receiveMessage(EntityEvent e) {
        StringBuilder st = new StringBuilder();
        st.append(this.field.getText());
        st.append(String.valueOf(e.getMessage()) + "\n");
        this.field.setText(st.toString());
    }

    public void receiveAnswer(EntityEvent evt) {
        SessionDescription sdp = evt.getSessionDescription();
        try {
            System.out.println(sdp.toString());
            this.receiver.receiveMedia(sdp);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void requestMedia() {
        EntityContainer con = this.getContainer();
        Set<Entity> set = con.getEntities();
        SessionDescription sdp = null;
        try {
            sdp = this.receiver.getRequestSessionDescription();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        for (Entity entity : set) {
            if (entity.getEntityType() != EntityType.MEDIA_TRANSMITTER || entity.isLocal()) continue;
            this.sendOffer(sdp, entity);
            this.callee = entity;
            break;
        }
    }

    public void receiveMedia(MediaReceiveEvent e) {
        System.out.println("start");
        this.prev = this.receiver.getVisualComponent();
        this.button.add(this.prev);
        this.button.pack();
        this.button.repaint();
    }

    public void terminateMedia(MediaReceiveEvent e) {
        System.out.println("end");
        this.button.remove(this.prev);
    }

    private class ButtonFrame
    extends JFrame {
        JButton jb;
        JButton bye;
        JPanel panel;

        public ButtonFrame(String name) {
            super(name);
            this.jb = new JButton("Request Media!");
            this.bye = new JButton("BYE");
            this.panel = new JPanel();
            this.panel.add(this.jb);
            this.panel.add(this.bye);
            this.setLayout(new GridLayout(3, 1));
            this.jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MediaReceiverEntity.this.requestMedia();
                }
            });
            this.bye.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((ButtonFrame)ButtonFrame.this).MediaReceiverEntity.this.callee != null) {
                        MediaReceiverEntity.this.sendBye(((ButtonFrame)ButtonFrame.this).MediaReceiverEntity.this.callee);
                    }
                }
            });
            this.getContentPane().add(new JScrollPane(MediaReceiverEntity.this.field));
            this.getContentPane().add(this.panel);
            this.pack();
            this.setDefaultCloseOperation(3);
            this.setVisible(true);
        }
    }
}

