/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.serial;

import java.util.Date;
import jp.ac.naka.ec.serial.MoxaDeviceType;
import jp.ac.naka.ec.serial.SensorData;

public class MoxaSensorData
implements SensorData {
    int sensor_type = 0;
    int id = 0;
    String sensor_value;
    int seqNumber = 0;
    int srcAddr;
    int srcPanId = 0;
    int rssi;
    long timestamp;

    public MoxaSensorData(int type, int seq, int addr, int id, String value, int rssi) {
        this.sensor_type = type;
        this.sensor_value = value;
        this.srcAddr = addr;
        this.seqNumber = seq;
        this.srcPanId = id;
        this.rssi = rssi;
        this.timestamp = new Date().getTime();
    }

    public MoxaSensorData(int type, String value, int addr, int panId, long timestamp2) {
        this(type, 0, addr, panId, value, 0);
        this.timestamp = timestamp2;
    }

    public String toString() {
        return "Sensor Type:" + MoxaDeviceType.getSensorTypeString(this.sensor_type) + ", Sensor Value:" + this.sensor_value;
    }

    public int getSensorType() {
        return this.sensor_type;
    }

    public int getRssi() {
        return this.rssi;
    }

    public String getSensorValue() {
        return this.sensor_value;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public int getSrcAddr() {
        return this.srcAddr;
    }

    public int getSrcPanId() {
        return this.srcPanId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setId(int num) {
        this.id = num;
    }

    public int getId() {
        return this.id;
    }
}

