/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.serial;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.DatabaseConnector;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.serial.SensorData;
import jp.ac.naka.ec.serial.SerialEvent;
import jp.ac.naka.ec.serial.SerialInputParser;
import jp.ac.naka.ec.serial.SerialListener;
import jp.ac.naka.ec.serial.TemperatureParser;
import org.apache.log4j.Logger;

public class SerialManager
extends EventSource
implements SerialPortEventListener {
    private static DatabaseConnector con;
    private static Logger logger;
    private Entity source;
    List<SerialListener> listeners = new ArrayList<SerialListener>();
    private SerialInputParser parser;
    private String commPort = "COM1";
    private int baud_rate = 9600;
    private final int timeout = 20000;
    BufferedReader comReader;

    static {
        logger = Logger.getLogger(SerialManager.class);
    }

    public void init(EntityContainer source, Properties prop) throws Exception {
        String a;
        String baud;
        String port;
        this.source = source;
        if (Main.con != null) {
            con = Main.con;
        }
        if ((port = prop.getProperty("port")) != null && !port.equals("")) {
            this.commPort = port;
        }
        if ((baud = prop.getProperty("baudRate")) != null && !baud.equals("")) {
            this.baud_rate = Integer.valueOf(baud);
        }
        if ((a = prop.getProperty("SerialInputParser")) != null && !a.equals("")) {
            try {
                Class<?> clz = Class.forName(a);
                this.parser = (SerialInputParser)clz.newInstance();
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid SerialInputParser Class :" + a), (Throwable)e);
            }
        }
        if (this.parser == null) {
            this.parser = new TemperatureParser();
        }
        this.initialize();
    }

    public void initialize() throws IOException {
        try {
            CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.commPort);
            if (portIdentifier.isCurrentlyOwned()) {
                logger.error((Object)"Error: Port is currently in use");
            } else {
                CommPort commPort = portIdentifier.open(this.getClass().getName(), 20000);
                if (commPort instanceof SerialPort) {
                    SerialPort serialPort = (SerialPort)commPort;
                    serialPort.setSerialPortParams(this.baud_rate, 8, 1, 0);
                    serialPort.addEventListener((SerialPortEventListener)this);
                    serialPort.notifyOnDataAvailable(true);
                    InputStream in = serialPort.getInputStream();
                    this.comReader = new BufferedReader(new InputStreamReader(in));
                } else {
                    logger.error((Object)"Error: Only serial ports are handled by this example.");
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void addSerialListener(SerialListener listener) {
        this.listeners.add(listener);
    }

    public void removeSerialListener(SerialListener listener) {
        for (SerialListener l : this.listeners) {
            if (l != listener) continue;
            this.listeners.remove(l);
            break;
        }
    }

    void dispatchEvent(SerialEvent evt) {
        if (con != null) {
            try {
                int num = con.store(EntityType.SENSOR, evt.getSensorData(), this.source);
                evt.getSensorData().setId(num);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        for (SerialListener listener : this.listeners) {
            listener.serialPerformed(evt);
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                String buffer = null;
                SensorData data = null;
                try {
                    while (this.comReader.ready()) {
                        buffer = this.comReader.readLine();
                        data = this.parser.parse(buffer);
                        if (data == null) continue;
                        this.dispatchEvent(new SerialEvent(this, data));
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            SerialManager sc = new SerialManager();
            sc.initialize();
            con = DatabaseConnector.getInstance();
            SerialListener l1 = new SerialListener(){

                public void serialPerformed(SerialEvent e) {
                    System.out.println(e.getSensorData().toString());
                }
            };
            SerialListener l2 = new SerialListener(){

                public void serialPerformed(SerialEvent e) {
                    System.out.println(e.getSensorData().toString());
                }
            };
            sc.addSerialListener(l1);
            sc.addSerialListener(l2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void input(String str) {
    }
}

