/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

class InviteDelegate
extends MethodDelegate {
    private static Logger logger = Logger.getLogger(InviteDelegate.class);

    public InviteDelegate() {
        PropertyConfigurator.configure((String)Main.log4j_properties);
        this.dispatcher = EntityEventDispatcher.getInstance();
        this.core = SipCore.getInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        ContentTypeHeader type = (ContentTypeHeader)req.getHeader("Content-Type");
        FromHeader from = (FromHeader)req.getHeader("From");
        if (type.getContentType().equals("application") && type.getContentSubType().equals("sdp")) {
            byte[] raw;
            block7: {
                try {
                    raw = req.getRawContent();
                    if (!this.isMidRequest(evt)) break block7;
                    this.core.sendResponse(500, evt, from.getAddress().getURI().toString());
                    return false;
                }
                catch (Exception e) {
                    logger.warn((Object)"Error while processing SDP.", (Throwable)e);
                    try {
                        this.core.sendResponse(500, evt, from.getAddress().getURI().toString());
                        return false;
                    }
                    catch (Exception e1) {
                        logger.warn((Object)"Cannot send a error Response.", (Throwable)e);
                    }
                    return false;
                }
            }
            SessionDescription sdp = null;
            if (raw != null) {
                String sdp_str = new String(raw, "UTF-8");
                sdp = SdpMessageParser.getSessionDescription((String)sdp_str);
            }
            ToHeader to = (ToHeader)req.getHeader("To");
            SipURI targetURI = (SipURI)to.getAddress().getURI();
            SipURI sourceURI = (SipURI)from.getAddress().getURI();
            EntityImpl target = new EntityImpl(targetURI);
            EntityImpl source = new EntityImpl(sourceURI);
            source.setLocal(false);
            EntityEvent e = new EntityEvent(sdp, (EntityListener)target, (Entity)source);
            this.core.sendResponse(100, evt, sourceURI.toString());
            e.setEventType(EntityEvent.EventType.OFFER);
            e.setRequest(req);
            this.dispatcher.dispatchEvent(e);
            return true;
        }
        logger.warn((Object)("Unsuported Content-Type: +" + type.toString()));
        return false;
    }

    private boolean isMidRequest(RequestEvent evt) {
        ServerTransaction st = evt.getServerTransaction();
        return st != null;
    }
}

