/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFParser;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.SAXException;

class MessageDelegate
extends MethodDelegate {
    private static Logger logger = Logger.getLogger(MessageDelegate.class);
    PIDFParser parser = PIDFParserImpl.getInatance();

    public MessageDelegate() throws ParserConfigurationException, SAXException {
        PropertyConfigurator.configure((String)Main.log4j_properties);
        this.dispatcher = TupleSpaceAdapter.getInstance();
        this.core = SipCore.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        byte[] content = req.getRawContent();
        ToHeader to = (ToHeader)req.getHeader("To");
        SipURI toUri = (SipURI)to.getAddress().getURI();
        FromHeader from = (FromHeader)req.getHeader("From");
        SipURI fromUri = (SipURI)from.getAddress().getURI();
        ContentTypeHeader content_type = (ContentTypeHeader)req.getHeader("Content-Type");
        try {
            EntityImpl source = new EntityImpl(fromUri);
            source.setLocal(false);
            EntityImpl target = new EntityImpl(toUri);
            String message = new String(content, "UTF-8");
            EntityEvent e = null;
            if (content_type.getContentType().equals("text") && content_type.getContentSubType().equals("plain")) {
                e = new EntityEvent(message, (EntityListener)target, (Entity)source);
            } else if (content_type.getContentType().equals("application") && content_type.getContentSubType().equals("pidf+xml")) {
                PIDFData data = this.parser.parse(content);
                Entity[] entities = this.makeEntitiesFromPIDF(data);
                e = new EntityEvent(entities);
                e.setEventType(EntityEvent.EventType.ADD);
            } else {
                throw new IllegalArgumentException("Can not handle ContentType :" + content_type);
            }
            this.dispatcher.dispatchEvent(e);
            this.core.sendResponse(200, req);
        }
        catch (Exception e) {
            logger.warn((Object)"Error occures while processing SIP Message :", (Throwable)e);
            return false;
        }
        return true;
    }
}

