/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import gov.nist.javax.sip.address.SipUri;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.TreeNode;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.sip.DefaultListener;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFFactory;
import jp.ac.naka.ec.sip.pidf.PIDFFactoryImpl;
import net.sourceforge.jsdp.SessionDescription;
import org.apache.log4j.Logger;

public class SipCore
extends EventSource {
    private static SipProvider provider;
    private static SipListener listener;
    private static MessageFactory messageFactory;
    private static AddressFactory addressFactory;
    private static HeaderFactory headerFactory;
    private SipURI uri;
    private static boolean initialized;
    private static EntityContainer con;
    private static SipCore instance;
    public static int DEFAULT_EXPIRES;
    public static String event_package;
    private static Map<String, Dialog> dialogTable;
    private static final String pathname = "gov.nist";
    private static final String TRANSPORT = "udp";
    private static Logger logger;
    private PIDFFactory pidfFactory;
    Random rand = new Random();
    NotifyTask task;

    static {
        initialized = false;
        instance = new SipCore();
        DEFAULT_EXPIRES = 3600;
        event_package = "presence";
        dialogTable = new HashMap<String, Dialog>();
        logger = Logger.getLogger(SipCore.class);
    }

    public static void initialize(String user_name, String hostname, int sip_port, String sip_config) throws SipException, IOException, ParseException, InvalidArgumentException, TooManyListenersException {
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName(pathname);
        Properties prop = new Properties();
        prop.load(new FileInputStream(sip_config));
        SipStack sipStack = null;
        sipStack = sipFactory.createSipStack(prop);
        addressFactory = sipFactory.createAddressFactory();
        SipURI uri = addressFactory.createSipURI(user_name, String.valueOf(hostname) + ":" + sip_port);
        logger.info((Object)("getHostAddress:\t" + uri.toString()));
        ListeningPoint lp = sipStack.createListeningPoint(hostname, sip_port, TRANSPORT);
        SipProvider sipProvider = sipStack.createSipProvider(lp);
        listener = new DefaultListener();
        sipProvider.addSipListener(listener);
        provider = sipProvider;
        messageFactory = sipFactory.createMessageFactory();
        headerFactory = sipFactory.createHeaderFactory();
        EventDispatcher dispatcher = instance.getEventDispatcher();
        dispatcher.addEntityListener(new EntityListener(){

            public void receiveMessage(EntityEvent e) {
                Entity target2 = (Entity)e.getTarget();
                switch (e.getEventType()) {
                    case INIT: {
                        try {
                            instance.sendRequest((Entity)e.getTarget(), "REGISTER");
                        }
                        catch (SipException se) {
                            logger.error((Object)("Error while sending REGISTER to " + target2.getURI()));
                        }
                        break;
                    }
                    case ACK: {
                        Dialog dialog = (Dialog)dialogTable.get(target2.getURI().toString());
                        try {
                            Request ack = dialog.createAck(dialog.getLocalSeqNumber());
                            logger.info((Object)("Send ACK to " + dialog.getRemoteTarget()));
                            dialog.sendAck(ack);
                        }
                        catch (Exception e1) {
                            logger.warn((Object)"Error while sending ACK", (Throwable)e1);
                        }
                        break;
                    }
                    case MESSAGE: {
                        if (e.isBroadcast()) {
                            Set<Entity> entities = con.getEntities();
                            for (Entity target2 : entities) {
                                if (target2.isLocal() || !(target2 instanceof EntityContainer)) continue;
                                try {
                                    Request req = instance.createRequest(target2, con, "MESSAGE");
                                    req.setContent((Object)e.getMessage(), headerFactory.createContentTypeHeader("text", "plain"));
                                    provider.sendRequest(req);
                                }
                                catch (Exception e1) {
                                    logger.warn((Object)("Error while sending MESSAGE to " + target2), (Throwable)e1);
                                }
                                logger.info((Object)("Send MESSAGE to " + target2.getURI()));
                            }
                            break;
                        }
                        Entity source = (Entity)e.getSource();
                        Set<TreeNode> set = con.getChildNodes();
                        if (!source.isLocal() || target2.isLocal()) {
                            return;
                        }
                        if (!set.contains(target2) && con.include(target2) && !target2.equals(con)) {
                            try {
                                Request req = instance.createRequest(target2, con, "MESSAGE");
                                req.setContent((Object)e.getMessage(), headerFactory.createContentTypeHeader("text", "plain"));
                                provider.sendRequest(req);
                            }
                            catch (Exception e1) {
                                logger.warn((Object)("Error while sending MESSAGE to " + target2), (Throwable)e1);
                            }
                            break;
                        }
                        logger.info((Object)("No External Entry :" + target2.getURI()));
                    }
                }
            }

            public SessionDescription receiveOffer(EntityEvent evt) {
                Entity target = (Entity)evt.getTarget();
                if (target.isLocal()) {
                    return null;
                }
                Entity source = (Entity)evt.getSource();
                try {
                    instance.sendRequest(evt.getSessionDescription().toString(), target, source, "INVITE");
                }
                catch (Exception e) {
                    logger.warn((Object)("Error while sending INVITE to " + target), (Throwable)e);
                }
                return null;
            }

            public void receiveBye(EntityEvent evt) {
                Entity target = (Entity)evt.getTarget();
                if (target.isLocal()) {
                    return;
                }
                Entity source = (Entity)evt.getSource();
                try {
                    instance.sendRequest("", target, source, "BYE");
                }
                catch (Exception e) {
                    logger.warn((Object)("Error while sending BYE to " + target), (Throwable)e);
                }
            }

            public void receiveAnswer(EntityEvent e) {
                Entity source = (Entity)e.getSource();
                Request req = e.getRequest();
                Response res = null;
                if (req == null) {
                    return;
                }
                try {
                    res = messageFactory.createResponse(200, req);
                    if (e.getSessionDescription() != null) {
                        ContentTypeHeader type = headerFactory.createContentTypeHeader("application", "sdp");
                        res.setContent((Object)e.getSessionDescription().toString(), type);
                    }
                    Address contact_addr = addressFactory.createAddress(source.getURI());
                    contact_addr.setDisplayName(source.getName());
                    ContactHeader contact = headerFactory.createContactHeader(contact_addr);
                    res.setHeader((Header)contact);
                    Entity target = (Entity)e.getTarget();
                    String uri = target.getURI().toString();
                    Dialog dialog = (Dialog)dialogTable.get(uri);
                    ServerTransaction st = (ServerTransaction)dialog.getApplicationData();
                    st.sendResponse(res);
                    logger.info((Object)("Sending Response 200(OK) to " + uri));
                }
                catch (Exception e1) {
                    logger.warn((Object)"Error while creating Response", (Throwable)e1);
                    return;
                }
            }

            public void addedNewEntity(EntityEvent e) {
                switch (e.getEventType()) {
                    case REGISTER: {
                        Entity target = (Entity)e.getSource();
                        try {
                            instance.sendRequest(target, "SUBSCRIBE");
                        }
                        catch (SipException e1) {
                            logger.warn((Object)("Error while sending SUBSCRIBE to " + target.getURI()), (Throwable)e1);
                        }
                        break;
                    }
                    case SUBSCRIBE: {
                        Entity[] entities = (Entity[])e.getSource();
                        String target_uri = entities[0].getURI().toString();
                        Dialog dialog = (Dialog)dialogTable.get(target_uri);
                        try {
                            instance.startNotify(target_uri, dialog);
                        }
                        catch (ParseException e2) {
                            logger.warn((Object)("Error while sending NOTIFY to " + target_uri), (Throwable)e2);
                        }
                        break;
                    }
                    case NOTIFY: {
                        if (instance.task != null) {
                            instance.task.refresh();
                            try {
                                instance.task.sendNotify();
                            }
                            catch (Exception e1) {
                                logger.warn((Object)("Error while sending NOTIFY message to " + con.getParent()), (Throwable)e1);
                            }
                        }
                        Entity[] entities = (Entity[])e.getSource();
                        String target_uri = entities[0].getURI().toString();
                        Set set = dialogTable.keySet();
                        String pidf = instance.pidfFactory.createPIDF().toString();
                        for (String uri : set) {
                            if (uri.equals(target_uri)) continue;
                            Dialog dialog = (Dialog)dialogTable.get(uri);
                            try {
                                Request req = dialog.createRequest("MESSAGE");
                                ClientTransaction ct = provider.getNewClientTransaction(req);
                                req.setContent((Object)pidf, headerFactory.createContentTypeHeader("application", "pidf+xml"));
                                dialog.sendRequest(ct);
                                logger.info((Object)("Forwarding PIDF to :" + uri));
                            }
                            catch (Exception e1) {
                                logger.error((Object)("Error while sending MESSAGE message to " + uri), (Throwable)e1);
                            }
                        }
                        break;
                    }
                    case ADD: {
                        if (!(e.getSource() instanceof Entity[])) break;
                        Entity[] entities = (Entity[])e.getSource();
                        String target_uri = entities[0].getURI().toString();
                        Set set = dialogTable.keySet();
                        String pidf = instance.pidfFactory.createPIDF().toString();
                        for (String uri : set) {
                            if (uri.equals(target_uri)) continue;
                            Dialog dialog = (Dialog)dialogTable.get(uri);
                            try {
                                Request req = dialog.createRequest("MESSAGE");
                                ClientTransaction ct = provider.getNewClientTransaction(req);
                                req.setContent((Object)pidf, headerFactory.createContentTypeHeader("application", "pidf+xml"));
                                dialog.sendRequest(ct);
                                logger.info((Object)("Forwarding PIDF to :" + uri));
                            }
                            catch (Exception e1) {
                                logger.error((Object)("Error while sending MESSAGE message to " + uri), (Throwable)e1);
                            }
                        }
                        break;
                    }
                    default: {
                        logger.warn((Object)"Invalid Operation");
                    }
                }
            }
        });
        initialized = true;
    }

    public static SipCore getInstance() {
        return instance;
    }

    public void setEntityContainer(EntityContainer container) {
        con = container;
        this.uri = (SipURI)con.getURI();
        this.pidfFactory = new PIDFFactoryImpl(con);
    }

    public void sendResponse(int num, Request req) throws ParseException, InvalidArgumentException, SipException {
        Response res = messageFactory.createResponse(num, req);
        ToHeader to = (ToHeader)res.getHeader("To");
        logger.info((Object)("Sending Response (" + num + ") to " + to.getAddress()));
        provider.sendResponse(res);
    }

    public void sendResponse(int num, RequestEvent evt, String sender_uri) throws ParseException, SipException, InvalidArgumentException {
        ServerTransaction st;
        if (!initialized) {
            return;
        }
        Request req = evt.getRequest();
        Response res = messageFactory.createResponse(num, req);
        if (req.getMethod().equals("SUBSCRIBE")) {
            this.prepareResponse(res);
            ExpiresHeader expiresHeader = req.getExpires();
            int expires = expiresHeader.getExpires() - 1;
            res.setHeader((Header)headerFactory.createExpiresHeader(expires));
        }
        if ((st = evt.getServerTransaction()) == null) {
            st = provider.getNewServerTransaction(req);
        }
        logger.info((Object)("Sending " + req.getMethod() + " Response to " + sender_uri));
        st.sendResponse(res);
        if (req.getMethod().equals("SUBSCRIBE") || req.getMethod().equals("NOTIFY")) {
            Dialog dialog = st.getDialog();
            dialogTable.put(sender_uri, dialog);
        } else if (num == 100) {
            Dialog dialog = st.getDialog();
            dialogTable.put(sender_uri, dialog);
            dialog.setApplicationData((Object)st);
        }
    }

    private void prepareResponse(Response res) throws ParseException, InvalidArgumentException {
        ToHeader to = (ToHeader)res.getHeader("To");
        Random rand = new Random();
        to.setTag(String.valueOf(rand.nextInt(999999)));
        Address addr = addressFactory.createAddress((URI)this.uri);
        ContactHeader contact = headerFactory.createContactHeader(addr);
        res.setHeader((Header)contact);
    }

    void sendRequest(Entity target, String method) throws SipException {
        Request req = this.createRequest(target, con, method);
        if (method.equals("REGISTER")) {
            try {
                ExpiresHeader expires = headerFactory.createExpiresHeader(DEFAULT_EXPIRES);
                req.setExpires(expires);
                Address contact_addr = addressFactory.createAddress(con.getURI());
                contact_addr.setDisplayName(con.getName());
                ContactHeader contact = headerFactory.createContactHeader(contact_addr);
                req.setHeader((Header)contact);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage());
            }
        }
        if (method.equals("SUBSCRIBE")) {
            PIDFFactoryImpl pidf_fac = new PIDFFactoryImpl(con);
            PIDFData data = pidf_fac.createPIDF();
            try {
                req.setContent((Object)data.toString(), headerFactory.createContentTypeHeader("application", "pidf+xml"));
                ExpiresHeader expires = headerFactory.createExpiresHeader(DEFAULT_EXPIRES);
                req.setExpires(expires);
                EventHeader event = headerFactory.createEventHeader(event_package);
                req.setHeader((Header)event);
                Address contact_addr = addressFactory.createAddress(con.getURI());
                contact_addr.setDisplayName(con.getName());
                ContactHeader contact = headerFactory.createContactHeader(contact_addr);
                req.setHeader((Header)contact);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage());
            }
        }
        ClientTransaction ct = provider.getNewClientTransaction(req);
        ct.sendRequest();
        logger.info((Object)("Sending " + method + " to " + target.getURI()));
        Dialog dialog = ct.getDialog();
        if (dialog != null) {
            dialogTable.put(target.getURI().toString(), dialog);
        }
    }

    void sendRequest(String message, Entity target, Entity source, String method) throws SipException, ParseException {
        String name = target.getURI().toString();
        if (method.equals("INVITE")) {
            Request req = this.createRequest(target, source, method);
            Address contact_addr = addressFactory.createAddress(source.getURI());
            ContactHeader contact = headerFactory.createContactHeader(contact_addr);
            req.setHeader((Header)contact);
            req.setContent((Object)message, headerFactory.createContentTypeHeader("application", "sdp"));
            ClientTransaction ct = provider.getNewClientTransaction(req);
            ct.sendRequest();
            dialogTable.put(name, ct.getDialog());
        } else if (method.equals("MESSAGE")) {
            Request req = this.createRequest(target, source, method);
            FromHeader from = (FromHeader)req.getHeader("From");
            Address addr = addressFactory.createAddress(source.getURI());
            addr.setDisplayName(source.getFullyQualifiedName());
            from.setAddress(addr);
            req.setContent((Object)message, headerFactory.createContentTypeHeader("text", "plain"));
            provider.sendRequest(req);
        } else {
            Dialog dialog = dialogTable.get(name);
            Request req = dialog.createRequest(method);
            ClientTransaction ct = provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
        }
    }

    private Request createRequest(Entity target, Entity source, String method) throws SipException {
        Request req;
        Address toAddress = addressFactory.createAddress(target.getURI());
        String transport = TRANSPORT;
        String branch = null;
        String tag = "" + this.rand.nextInt(100000000);
        try {
            ToHeader to = headerFactory.createToHeader(toAddress, null);
            Address fromAddress = addressFactory.createAddress(source.getURI());
            fromAddress.setDisplayName(source.getName());
            FromHeader from = headerFactory.createFromHeader(fromAddress, tag);
            CSeqHeader cSeq = headerFactory.createCSeqHeader(1L, method);
            CallIdHeader callId = provider.getNewCallId();
            MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            String ipAddr = provider.getListeningPoint(transport).getIPAddress();
            int port = provider.getListeningPoint(transport).getPort();
            ViaHeader viaHeader = headerFactory.createViaHeader(ipAddr, port, transport, branch);
            viaHeaders.add(viaHeader);
            req = messageFactory.createRequest(to.getAddress().getURI(), method, callId, cSeq, from, to, viaHeaders, maxForwards);
        }
        catch (Exception e) {
            throw new SipException(e.getMessage());
        }
        return req;
    }

    void startNotify(String sender_name, Dialog dialog) throws ParseException {
        logger.info((Object)("Start NotifyTask to:" + sender_name));
        this.task = new NotifyTask(dialog);
        this.task.start();
    }

    public void refresh() {
        this.task.refresh();
    }

    public URI createURI(String temp) {
        URI uri;
        try {
            if (addressFactory != null) {
                uri = addressFactory.createURI(temp);
            } else {
                SipUri s_uri = new SipUri();
                StringTokenizer stToken = new StringTokenizer(temp, "@:");
                String scheme = stToken.nextToken();
                if (!scheme.equals("sip") && !scheme.equals("pres")) {
                    throw new IllegalArgumentException("Bad uri scheme :" + scheme);
                }
                String user = stToken.nextToken();
                String host = stToken.nextToken();
                int port = Integer.parseInt(stToken.nextToken());
                s_uri.setUser(user);
                s_uri.setHost(host);
                s_uri.setPort(port);
                uri = s_uri;
            }
        }
        catch (ParseException e) {
            return null;
        }
        return uri;
    }

    public void init(EntityContainer source, Properties prop) throws Exception {
    }

    private class NotifyTask
    extends TimerTask {
        private EntityContainer target = null;
        private static final String eventPackage = "presence";
        private PIDFData temp = null;
        private Dialog dialog;
        private boolean alive = false;
        private Timer timer;
        Address fromAddress;

        public NotifyTask(Dialog dialog) throws ParseException {
            this.dialog = dialog;
            this.alive = true;
            this.fromAddress = addressFactory.createAddress(con.getURI());
            this.fromAddress.setDisplayName(con.getName());
        }

        public void start() {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 1000L, (long)(DEFAULT_EXPIRES * 1000));
        }

        public void run() {
            try {
                this.sendNotify();
            }
            catch (Exception e) {
                logger.warn((Object)("Error occure, remove Entity :" + this.target), (Throwable)e);
                con.removeChild(this.target);
            }
        }

        public void sendNotify() throws SipException, ParseException {
            Request notify = this.dialog.createRequest("NOTIFY");
            SubscriptionStateHeader state = headerFactory.createSubscriptionStateHeader("Active");
            EventHeader event = headerFactory.createEventHeader(eventPackage);
            PIDFData pidf = SipCore.this.pidfFactory.createPIDF();
            if (this.temp == null || !this.temp.equals(pidf)) {
                ContentTypeHeader contentType = headerFactory.createContentTypeHeader("application", "pidf+xml");
                notify.addHeader((Header)state);
                notify.addHeader((Header)event);
                notify.setContent((Object)pidf.toString(), contentType);
            }
            ClientTransaction ct = provider.getNewClientTransaction(notify);
            if (this.alive) {
                logger.info((Object)("Sending NOTIFY to " + this.dialog.getRemoteTarget()));
                this.dialog.sendRequest(ct);
                this.alive = false;
            } else {
                logger.info((Object)("Expires out, remove Entity" + this.target));
                con.removeChild(this.target);
            }
        }

        public void refresh() {
            this.alive = true;
        }
    }
}

