/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity;

import javax.sip.address.URI;

import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.TreeNode;

/**
 * 
 * @author Takashi Kasuya
 *
 */
public interface Entity extends TreeNode, EntityListener {

	/**
	 * SDPw肵ăZbṼNGXg
	 * 
	 * @param sdp
	 * @param target
	 * @return
	 */
	public boolean sendOffer(net.sourceforge.jsdp.SessionDescription sdp,
			Entity target);

	/**
	 * SDPw肹ɃNGXgASDPɂtH[}bg̎wɏ]B
	 * 
	 * @param target
	 * @return
	 */
	public boolean sendOffer(Entity target);

	/**
	 * bZ[WSẴXiɑ΂ĔzM
	 * 
	 * @param msg
	 */
	public void sendMessage(String msg) ;

	/**
	 * ^[Qbgw肵ăbZ[W̑M
	 * 
	 * @param msg
	 * @param targetName
	 */
	public void sendMessage(String msg, String targetName);
			

	/**
	 * ^[Qbgw肵ăbZ[W̑M
	 * 
	 * @param msg
	 * @param targetName
	 */
	public void sendMessage(String msg, EntityListener target);

	

	/**
	 * BYEbZ[W̑M
	 * 
	 * @param target
	 * @return
	 */
	public boolean sendBye(EntityListener target) ;

	

	/**
	 * EntityType̎擾
	 * 
	 * @return
	 */
	public EntityType getEntityType();

	/**
	 * 
	 * @param type
	 */
	public void setEntityType(EntityType type);

	/**
	 * EntityContainer̎擾
	 * 
	 * @return
	 */
	public EntityContainer getContainer();

	/**
	 * 
	 * @param uri
	 */
	public void setURI(URI uri);

	/**
	 * 
	 * @return
	 */
	public URI getURI();

	/**
	 * 
	 * @param id
	 */
	public void setTupleId(String id);

	/**
	 * 
	 * @return
	 */
	public String getTupleId();

	/**
	 * 
	 * @param priority
	 */
	public void setPriority(float priority);

	/**
	 * 
	 * @return
	 */
	public float getPriority();

	/**
	 * 
	 * @return
	 */
	public String getDescription();

	/**
	 * [JɂEntityǂB
	 * 
	 * @return
	 */
	public boolean isLocal();

	/**
	 * 
	 * @param a
	 */
	public void setLocal(boolean a);

	/**
	 * 
	 * @return
	 */
	public Location getLocation();

	/**
	 * 
	 * @param location
	 */
	public void setLocation(Location location);

}
