/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Set;

import javax.media.MediaException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.media.MediaListener;
import jp.ac.naka.ec.media.MediaReceiveEvent;
import jp.ac.naka.ec.media.MediaReceiver;
import net.sourceforge.jsdp.SessionDescription;

/**
 * {^ƁAlbg[NrfI\[XāAZbV𒣂̂\B
 * 
 * @author Takashi Kasuya
 * 
 */
public class MediaReceiverEntity extends AbstractEntity implements
		MediaListener {

	MediaReceiver receiver;

	ButtonFrame button;

	JTextArea field = new JTextArea();

	Entity callee;

	@Override
	public void init() {
		setName("VideoReceiver");
		setEntityType(EntityType.MEDIA_RECEIVER);
		receiver = new MediaReceiver();
		receiver.addMediaListener(this);
		button = new ButtonFrame("MediaSender");
	}

	@Override
	public void receiveMessage(EntityEvent e) {
		StringBuilder st = new StringBuilder();
		st.append(field.getText());
		st.append(e.getMessage() + "\n");
		field.setText(st.toString());
	}

	@Override
	public void receiveAnswer(EntityEvent evt) {
		SessionDescription sdp = evt.getSessionDescription();
		try {
			System.out.println(sdp.toString());

			receiver.receiveMedia(sdp);
		} catch (MediaException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private void requestMedia() {
		EntityContainer con = getContainer();
		Set<Entity> set = con.getEntities();
		SessionDescription sdp = null;
		try {
			sdp = receiver.getRequestSessionDescription();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}

		for (Entity entity : set) {
			if (entity.getEntityType() == EntityType.MEDIA_TRANSMITTER
					&& !entity.isLocal()) {
				sendOffer(sdp, entity);
				callee = entity;
				break;
			}
		}

	}

	private class ButtonFrame extends JFrame {
		JButton jb = new JButton("Request Media!");

		JButton bye = new JButton("BYE");

		JPanel panel = new JPanel();

		public ButtonFrame(String name) {
			super(name);
			panel.add(jb);
			panel.add(bye);
			setLayout(new GridLayout(3, 1));
			jb.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					requestMedia();
				}

			});

			bye.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {

					if (callee != null)
						sendBye(callee);
				}
			});
			getContentPane().add(new JScrollPane(field));
			getContentPane().add(panel);
			pack();
			this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			setVisible(true);
		}
	}

	Component prev;

	public void receiveMedia(MediaReceiveEvent e) {
		System.out.println("start");
		prev = receiver.getVisualComponent();
		button.add(prev);
		button.pack();
		button.repaint();
	}

	public void terminateMedia(MediaReceiveEvent e) {
		System.out.println("end");
		button.remove(prev);
	}
}
