/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.xml.parsers.ParserConfigurationException;

import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEvent.EventType;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFParser;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.SAXException;

/**
 * @author Takashi Kasuya
 * 
 */
class NotifyDelegate extends MethodDelegate {

	private static Logger logger = Logger.getLogger(NotifyDelegate.class);
	private PIDFParser parser;

	/**
	 * 
	 * @throws ParserConfigurationException
	 * @throws SAXException
	 */
	public NotifyDelegate() throws ParserConfigurationException, SAXException {
		parser = PIDFParserImpl.getInatance();
		PropertyConfigurator.configure(Main.log4j_properties);
		dispatcher = TupleSpaceAdapter.getInstance();
		core = SipCore.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.ac.naka.sip.delegate.MethodDelegate#forward(javax.sip.RequestEvent)
	 */
	public boolean forward(RequestEvent evt) {
		// logger.info("Notify Request from " +
		// evt.getRequest().getRequestURI().toString());

		Request req = evt.getRequest();
		byte[] content = req.getRawContent();

		PIDFData data;
		try {
			FromHeader from = (FromHeader) req.getHeader(FromHeader.NAME);
			Address addr = from.getAddress();

			if (content == null) {
				core.sendResponse(Response.OK, evt, addr.getURI().toString());
				return false;
			}
			data = parser.parse(content);
			Entity[] entities = makeEntitiesFromPIDF(data);

			if (entities != null) {
				EntityEvent ee = new EntityEvent(entities);
				//ee.setMessage(new String(content, "UTF-8"));
				ee.setEventType(EventType.NOTIFY);
				dispatcher.dispatchEvent(ee);
			}

			// 200 OK
			core.sendResponse(Response.OK, evt, addr.getURI().toString());
		} catch (Exception e) {
			logger.warn("Error occures while processing PIDF :", e);
			return false;
		}
		return true;
	}

	
}
