/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityEvent.EventType;

import org.apache.log4j.Logger;

/**
 * 
 * @author Takashi Kasuya
 * 
 */
class RegisterDelegate extends MethodDelegate {

	private static Logger logger = Logger.getLogger(RegisterDelegate.class);
	public static int default_expires = 3600;

	/**
	 * 
	 *
	 */
	public RegisterDelegate(){
		core = SipCore.getInstance();
		dispatcher = EntityEventDispatcher.getInstance();
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.ac.naka.ec.sip.MethodDelegate#forward(javax.sip.RequestEvent)
	 */
	public boolean forward(RequestEvent evt) {
		Request req = evt.getRequest();

		try {
			//FromHeader from = (FromHeader) req.getHeader(FromHeader.NAME);
			ToHeader to = (ToHeader) req.getHeader(ToHeader.NAME);
			ContactHeader contact = (ContactHeader) req
					.getHeader(ContactHeader.NAME);
			ExpiresHeader expiresHeader = (ExpiresHeader) req
					.getHeader(ExpiresHeader.NAME);
			int expires = expiresHeader.getExpires();
			// contactexpiresp^D
			if (contact.getParameter("expires") != null) {
				String t = contact.getParameter("expires");
				expires = Integer.valueOf(t);
			}

			// TODO
			int ret = registration(to, contact, expires);
			switch (ret) {
			case Response.OK:
				break;
			case Response.UNAUTHORIZED:
			case Response.FORBIDDEN:
			case Response.NOT_FOUND:
			case Response.INTERVAL_TOO_BRIEF:
			case Response.SERVER_INTERNAL_ERROR:
				core.sendResponse(ret, req);
			}
			Address addr = contact.getAddress();

			// o^
			core.sendResponse(Response.OK, evt, addr.getURI().toString());
			EntityContainer con = new EntityContainerImpl();
			con.setName(addr.getDisplayName());
			con.setURI(addr.getURI());
			con.setLocal(false);
			EntityEvent e = new EntityEvent(con);
			e.setEventType(EventType.REGISTER);
			dispatcher.dispatchEvent(e);
		} catch (Exception e) {
			logger.warn("Error occures while processing REGISTER :", e);
			return false;
		}
		return true;
	}

	private int registration(ToHeader to, ContactHeader contact, int expires) {
		// TODO Auto-generated method stub
		return 200;
	}

}
