/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package jp.ac.naka.ec.sip.pidf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.sip.address.URI;

import jp.ac.naka.ec.Location;

/**
 * PIDFtH[}bgf[^i[f[^^B
 * @author Takashi Kasuya
 *
 */

public class PIDFData {

	public final static String CONTENT_TYPE = "application";

	public final static String CONTENT_SUBTYPE = "pidf+xml";

	public final static String NAME_SPACE = "urn:ietf:params:xml:ns:pidf";

	private String entryTag;

	private String name;
	private Location location;

	private URI entity; // preURI of PRESENTITY

	// private String id;

	private List<Tuple> tuples = new ArrayList<Tuple>();

	private Map<String, String> extensions;

	// private String comment;
	private List<String> notes;

	/**
	 * 
	 *
	 */
	public PIDFData() {
		notes = new ArrayList<String>();
	}

	/**
	 * 
	 * @param entity
	 */
	public PIDFData(URI entity) {
		this();
		this.entity = entity;
	}

	/**
	 * 
	 * @param tuple
	 */
	public void addTuple(Tuple tuple) {
		this.tuples.add(tuple);
	}

	/**
	 * 
	 * @return
	 */
	public List<Tuple> getTuples() {
		return tuples;
	}

	/**
	 * 
	 * @return
	 */
	public List<String> getNotes() {
		return notes;
	}

	/**
	 * 
	 * @param comment
	 */
	public void addNote(String comment) {
		this.notes.add(comment);
	}

	/**
	 * 
	 * @return
	 */
	public URI getURI() {
		return entity;
	}

	/**
	 * 
	 * @param entity
	 */
	public void setURI(URI entity) {
		this.entity = entity;
	}

	/**
	 * 
	 * @return
	 */
	public String getEntryTag() {
		return entryTag;
	}

	/**
	 * 
	 * @param entryTag
	 */
	public void setEntryTag(String entryTag) {
		this.entryTag = entryTag;
	}

	/**
	 * 
	 * @param key
	 * @param value
	 */
	public void putExtensions(String key, String value) {
		if (extensions == null) {
			extensions = new HashMap<String, String>();
		}
		extensions.put(key, value);
	}

	/*
	 * (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		builder.append("<presence xmlns=\"");
		builder.append(NAME_SPACE);
		builder.append("\" entity=\"");
		builder.append(entity + "\">\r\n");

		for (Tuple tuple : tuples) {
			builder.append("<tuple id=\"");
			builder.append(getTupleId());
			builder.append("\">");
			builder.append(tuple.toString());
			builder.append("</tuple>\r\n");
		}
		if (extensions != null) {
			Set<String> set = extensions.keySet();
			for (String key : set) {
				String value = extensions.get(key);
				builder.append("<" + key + ">");
				builder.append(value);
				builder.append("</" + key + ">");
				builder.append("\r\n");
			}
		}

		if (location != null) {
			builder.append("<location><name>");
			builder.append(location.getName());
			builder.append("</name><latitude>");
			builder.append(location.getLatitude());
			builder.append("</latitude><longitude>");
			builder.append(location.getLongitude());
			builder.append("</longitude></location>\r\n");
		}

		for (String note : notes) {
			builder.append("<note>");
			builder.append(note);
			builder.append("</note>");
			builder.append("\r\n");
		}

		builder.append("</presence>");
		return builder.toString();
	}

	/**
	 * ʒu̎擾
	 * @return
	 */
	public Location getLocation() {
		return location;
	}

	/**
	 * 
	 * @param location
	 */
	public void setLocation(Location location) {
		this.location = location;
	}

	private static int id = 0;

	/**
	 * 
	 * @return
	 */
	String getTupleId() {
		String temp = name;
		if (id < 10) {
			temp += "000" + id++;
		} else if (id < 100) {
			temp += "00" + id++;
		} else if (id < 1000) {
			temp += "0" + id++;
		} else {
			temp += id;
		}
		return temp;
	}
	public void setName (String name) {
		this.name = name;
	}
	/*
	 * public static void main (String[] args) { SensorDataManager m
	 * =SensorDataManager.getInstance(); PIDFData data = new PIDFData ();
	 * data.addExpiresEventListener(m); m.addSensorData(data); data.start(); }
	 */
}
