/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private int andOrType;
    private Expression left;
    private Expression right;

    public ConditionAndOr(int andOrType, Expression left, Expression right) {
        this.andOrType = andOrType;
        this.left = left;
        this.right = right;
        if (Constants.CHECK && (left == null || right == null)) {
            throw Message.internal();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getSQL() {
        void var1_1;
        switch (this.andOrType) {
            case 0: {
                String sql = this.left.getSQL() + " AND " + this.right.getSQL();
                break;
            }
            case 1: {
                String sql = this.left.getSQL() + " OR " + this.right.getSQL();
                break;
            }
            default: {
                throw Message.internal("andOrType=" + this.andOrType);
            }
        }
        return "(" + (String)var1_1 + ")";
    }

    public void createIndexConditions(TableFilter filter) throws SQLException {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(filter);
            this.right.createIndexConditions(filter);
        }
    }

    public Value getValue(Session session) throws SQLException {
        Value l = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                if (Boolean.FALSE.equals(l.getBoolean())) {
                    return l;
                }
                Value r = this.right.getValue(session);
                if (Boolean.FALSE.equals(r.getBoolean())) {
                    return r;
                }
                if (l == ValueNull.INSTANCE) {
                    return l;
                }
                if (r == ValueNull.INSTANCE) {
                    return r;
                }
                return ValueBoolean.get(true);
            }
            case 1: {
                if (Boolean.TRUE.equals(l.getBoolean())) {
                    return l;
                }
                Value r = this.right.getValue(session);
                if (Boolean.TRUE.equals(r.getBoolean())) {
                    return r;
                }
                if (l == ValueNull.INSTANCE) {
                    return l;
                }
                if (r == ValueNull.INSTANCE) {
                    return r;
                }
                return ValueBoolean.get(false);
            }
        }
        throw Message.internal("type=" + this.andOrType);
    }

    public Expression optimize(Session session) throws SQLException {
        Value r;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        Value l = this.left.isConstant() ? this.left.getValue(session) : null;
        Value value = r = this.right.isConstant() ? this.right.getValue(session) : null;
        if (l == null && r == null) {
            return this;
        }
        if (l != null && r != null) {
            return ValueExpression.get(this.getValue(session));
        }
        switch (this.andOrType) {
            case 0: {
                if (l != null) {
                    if (Boolean.FALSE.equals(l.getBoolean())) {
                        return ValueExpression.get(l);
                    }
                    if (!Boolean.TRUE.equals(l.getBoolean())) break;
                    return this.right;
                }
                if (r == null) break;
                if (Boolean.FALSE.equals(r.getBoolean())) {
                    return ValueExpression.get(r);
                }
                if (!Boolean.TRUE.equals(r.getBoolean())) break;
                return this.left;
            }
            case 1: {
                if (l != null) {
                    if (Boolean.TRUE.equals(l.getBoolean())) {
                        return ValueExpression.get(l);
                    }
                    if (!Boolean.FALSE.equals(l.getBoolean())) break;
                    return this.right;
                }
                if (r == null) break;
                if (Boolean.TRUE.equals(r.getBoolean())) {
                    return ValueExpression.get(r);
                }
                if (!Boolean.FALSE.equals(r.getBoolean())) break;
                return this.left;
            }
            default: {
                throw Message.internal("type=" + this.andOrType);
            }
        }
        return this;
    }

    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(filter, outerJoin);
            this.right.addFilterConditions(filter, outerJoin);
        } else {
            super.addFilterConditions(filter, outerJoin);
        }
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.left.mapColumns(resolver, level);
        this.right.mapColumns(resolver, level);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }
}

