/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.regex.Pattern;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;

public class Phone
implements Field {
    private static final long serialVersionUID = 4792028746712967047L;
    private static final String PHONE = "\\+([1-9])+[ -](\\d)+([ -](\\d)+)*";
    protected String name;
    protected String phoneNumber;

    private Phone() {
    }

    public Phone(String phoneNumber) throws SdpException {
        this.setPhoneNumber(phoneNumber);
    }

    public Object clone() {
        Phone field = new Phone();
        field.phoneNumber = this.phoneNumber;
        if (this.name != null) {
            field.name = new String(this.name);
        }
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public String getName() {
        return this.name;
    }

    public char getFieldType() {
        return 'p';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer();
        if (this.name != null) {
            result.append(this.name);
            result.append("<" + this.phoneNumber + ">");
        } else {
            result.append(this.phoneNumber);
        }
        return result.toString();
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setName(String name) throws SdpException {
        this.name = name;
    }

    public void setPhoneNumber(String phoneNumber) throws SdpException {
        if (!Pattern.matches(PHONE, phoneNumber)) {
            throw new SdpException();
        }
        this.phoneNumber = phoneNumber;
    }

    public String toString() {
        return "p=" + this.getFieldValue();
    }
}

