/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.util.Hashtable;
import tools.tracesviewer.Arrow;
import tools.tracesviewer.TracesCanvas;

public class TracesAnimationThread
implements Runnable {
    public Thread tracesThread = null;
    TracesCanvas tracesCanvas;
    Hashtable arrows = null;
    int delay = 2000;

    public TracesAnimationThread(TracesCanvas tracesCanvas) {
        this.tracesCanvas = tracesCanvas;
        this.arrows = tracesCanvas.arrows;
    }

    public void start() {
        try {
            this.tracesThread = new Thread(this);
            this.tracesThread.setPriority(1);
            this.tracesThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            this.tracesThread = null;
            this.tracesCanvas.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this.arrows = this.tracesCanvas.arrows;
            if (this.arrows.size() != 0) {
                while (this.tracesThread != null) {
                    this.tracesCanvas.unvisibleAllArrows();
                    for (int i = 0; i < this.arrows.size() && this.tracesThread != null; ++i) {
                        Arrow arrow = (Arrow)this.arrows.get("arrow" + (i + 1));
                        arrow.visible = true;
                        this.tracesCanvas.unselectAllArrows();
                        arrow.selected = true;
                        this.tracesCanvas.repaint();
                        if (this.tracesThread == null) continue;
                        Thread.sleep(this.delay);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDelay(int n) {
        this.delay = n * 1000;
    }

    public int getDelay() {
        return this.delay / 1000;
    }
}

