/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextArea;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import tools.tracesviewer.Arrow;
import tools.tracesviewer.CircleArrow;
import tools.tracesviewer.StraightArrow;
import tools.tracesviewer.TracesMessage;
import tools.tracesviewer.TracesSession;
import tools.tracesviewer.TracesViewer;

public class TracesCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static int FIRST_ACTOR_GAP = 100;
    public int HORIZONTAL_GAP = 350;
    public static int ACTORS_STRIPE = 120;
    public static int FIRST_ARROW_GAP = 50;
    public static int VERTICAL_GAP = 60;
    public static int LAST_ARROW_GAP = 30;
    public static int LAST_ACTOR_GAP = 100;
    public Color SELECTED_COLOR = Color.red;
    public Color[] ARROWS_COLOR = new Color[]{Color.blue, new Color(94, 151, 185), Color.green, new Color(55, 223, 131), Color.orange, new Color(209, 177, 69), Color.magenta, new Color(187, 91, 185), Color.cyan, new Color(199, 239, 39)};
    public String selectedArrowName;
    public Arrow newArrow;
    public Arrow oldArrow;
    public Image actorsImage;
    public Image backgroundImage;
    public TracesSession tracesSession = null;
    public TextArea messageContentTextArea = null;
    public String tracesOrigin;
    public Hashtable actors = new Hashtable();
    public Hashtable arrows = new Hashtable();
    public Hashtable arrowsColors = new Hashtable();
    public boolean isAnimated = false;
    public Arrow arrowTipTool = null;
    public TracesViewer tracesViewer;
    public TracesMessage debugTracesMessage;

    public Dimension getPreferredSize() {
        int n = FIRST_ACTOR_GAP + LAST_ACTOR_GAP + this.HORIZONTAL_GAP * (this.actors.size() - 1);
        int n2 = ACTORS_STRIPE + FIRST_ARROW_GAP + LAST_ARROW_GAP + VERTICAL_GAP * (this.arrows.size() - 1);
        return new Dimension(n, n2);
    }

    public TracesCanvas(TracesSession tracesSession, TextArea textArea, String string, TracesViewer tracesViewer) {
        this.tracesViewer = tracesViewer;
        this.backgroundImage = TracesViewer.backgroundImage;
        this.actorsImage = TracesViewer.actorsImage;
        this.tracesSession = tracesSession;
        this.messageContentTextArea = textArea;
        this.refreshTracesCanvas(tracesSession, string);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public TracesCanvas(TracesSession tracesSession, Image image, String string, int n, TracesViewer tracesViewer) {
        this.tracesViewer = tracesViewer;
        this.backgroundImage = image;
        this.HORIZONTAL_GAP = n;
        this.actorsImage = TracesViewer.actorsImage;
        this.tracesSession = tracesSession;
        this.messageContentTextArea = null;
        this.refreshTracesCanvas(tracesSession, string);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void refreshTracesCanvas(TracesSession tracesSession, String string) {
        this.tracesSession = tracesSession;
        this.tracesOrigin = string;
        this.constructActors();
        this.constructArrows();
        this.selectMessage(FIRST_ACTOR_GAP + this.HORIZONTAL_GAP / 2, ACTORS_STRIPE + FIRST_ARROW_GAP);
    }

    public void drawTop(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(new Color(0, 0, 125));
        graphics.fillRect(0, 0, n, ACTORS_STRIPE - 5);
        graphics.setColor(Color.white);
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), 3, 17);
        graphics.setFont(font2);
        graphics.drawString("Trace retrieved from " + this.tracesOrigin, 40, 25);
        graphics.setColor(Color.black);
        graphics.drawLine(0, ACTORS_STRIPE, n, ACTORS_STRIPE);
        Enumeration enumeration = this.actors.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n3 = (Integer)this.actors.get(string);
            graphics.setColor(Color.white);
            font = graphics.getFont();
            font2 = new Font(font.getName(), 3, 14);
            graphics.setFont(font2);
            graphics.drawString(string, n3 - this.getFontMetrics(graphics.getFont()).stringWidth(string) / 2, ACTORS_STRIPE - 15);
            if (this.actorsImage != null) {
                graphics.drawImage(this.actorsImage, n3 - this.actorsImage.getWidth(this) / 2, ACTORS_STRIPE / 3, this);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n3, ACTORS_STRIPE, n3, n2);
        }
    }

    public void constructActors() {
        try {
            this.actors = new Hashtable();
            for (int i = 0; i < this.tracesSession.size(); ++i) {
                TracesMessage tracesMessage = (TracesMessage)this.tracesSession.elementAt(i);
                String string = tracesMessage.getFrom().trim();
                String string2 = tracesMessage.getTo().trim();
                int n = this.actors.size();
                if (this.actors.get(string) == null) {
                    this.actors.put(string, new Integer(n * this.HORIZONTAL_GAP + FIRST_ACTOR_GAP));
                }
                n = this.actors.size();
                if (this.actors.get(string2) != null) continue;
                this.actors.put(string2, new Integer(n * this.HORIZONTAL_GAP + FIRST_ACTOR_GAP));
            }
        }
        catch (Exception exception) {
            System.out.println("Error in trying to construct the actors");
        }
    }

    public void constructArrows() {
        this.arrows = new Hashtable();
        String string = null;
        String string2 = null;
        this.assignColors();
        this.selectedArrowName = "arrow1";
        for (int i = 0; i < this.tracesSession.size(); ++i) {
            Arrow arrow;
            Color color;
            TracesMessage tracesMessage = (TracesMessage)this.tracesSession.elementAt(i);
            string = tracesMessage.getFrom();
            string2 = tracesMessage.getTo();
            int n = (Integer)this.actors.get(string);
            int n2 = (Integer)this.actors.get(string2);
            int n3 = i * VERTICAL_GAP + ACTORS_STRIPE + FIRST_ARROW_GAP;
            boolean bl = tracesMessage.getStatusInfo() != null;
            String string3 = "arrow" + (i + 1);
            boolean bl2 = false;
            String string4 = tracesMessage.getTransactionId();
            if (string4 != null) {
                color = (Color)this.arrowsColors.get(string4);
                if (color == null) {
                    color = Color.black;
                }
            } else {
                color = Color.black;
            }
            if (n == n2) {
                arrow = new CircleArrow(bl2, string3, n, n3 - 20, n3 + 20, 40, true, bl);
                arrow.setColor(color);
                arrow.setTracesMessage(tracesMessage);
                arrow.setTracesCanvas(this);
                this.arrows.put(string3, arrow);
                continue;
            }
            arrow = new StraightArrow(bl2, string3, n, n2, n3 - 31, n3 + 31, true, bl);
            arrow.setColor(color);
            arrow.setTracesMessage(tracesMessage);
            arrow.setTracesCanvas(this);
            this.arrows.put(string3, arrow);
        }
    }

    public void assignColors() {
        this.arrowsColors = new Hashtable();
        TracesMessage tracesMessage = null;
        int n = 0;
        for (int i = 0; i < this.tracesSession.size(); ++i) {
            Color color;
            tracesMessage = (TracesMessage)this.tracesSession.elementAt(i);
            String string = tracesMessage.getTransactionId();
            if (string == null || (color = (Color)this.arrowsColors.get(string)) != null) continue;
            color = n >= 10 ? Color.black : this.ARROWS_COLOR[n];
            this.arrowsColors.put(string, color);
            ++n;
        }
    }

    public Arrow getArrow(int n, int n2) {
        Enumeration enumeration = this.arrows.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Arrow arrow = (Arrow)this.arrows.get(string);
            if (arrow == null) {
                return null;
            }
            if (!arrow.isCollisionArrow(n, n2)) continue;
            return arrow;
        }
        return null;
    }

    public Arrow getArrowInfo(int n, int n2) {
        Enumeration enumeration = this.arrows.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Arrow arrow = (Arrow)this.arrows.get(string);
            if (arrow == null) {
                return null;
            }
            if (!arrow.statusInfo || !arrow.isCollisionInfo(n, n2)) continue;
            return arrow;
        }
        return null;
    }

    public void selectMessage(int n, int n2) {
        this.newArrow = this.getArrow(n, n2);
        if (this.newArrow != null) {
            TracesMessage tracesMessage = this.newArrow.getTracesMessage();
            if (this.messageContentTextArea != null) {
                this.messageContentTextArea.setText(tracesMessage.getMessageString());
                if (tracesMessage.debugLine != null && !tracesMessage.debugLine.equals("")) {
                    this.tracesViewer.messageContentButton.setText("SIP message: (debug log line: " + tracesMessage.debugLine + " )");
                }
            }
            this.debugTracesMessage = tracesMessage;
            this.oldArrow = (Arrow)this.arrows.get(this.selectedArrowName);
            this.oldArrow.selected = false;
            this.newArrow.selected = true;
            this.selectedArrowName = this.newArrow.arrowName;
            this.repaint();
        }
    }

    public void showTipTool(int n, int n2) {
        Arrow arrow = this.arrowTipTool;
        this.arrowTipTool = this.getArrow(n, n2);
        if (arrow != null) {
            if (!arrow.arrowName.equals(this.arrowTipTool.arrowName)) {
                arrow.displayTipTool = false;
                this.arrowTipTool.displayTipTool = true;
                this.repaint();
            }
        } else {
            this.arrowTipTool.displayTipTool = true;
            this.repaint();
        }
    }

    public void unShowTipTool() {
        if (this.arrowTipTool != null) {
            this.arrowTipTool.displayTipTool = false;
            this.repaint();
            this.arrowTipTool = null;
        }
    }

    public void drawArrows(Graphics graphics) {
        Enumeration enumeration = this.arrows.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Arrow arrow = (Arrow)this.arrows.get(string);
            if (!arrow.visible) continue;
            arrow.draw(graphics);
        }
        if (this.getParent() != null) {
            this.getParent().doLayout();
            this.getParent().validate();
        }
    }

    public void unvisibleAllArrows() {
        Enumeration enumeration = this.arrows.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Arrow arrow = (Arrow)this.arrows.get(string);
            arrow.visible = false;
        }
    }

    public void unselectAllArrows() {
        Enumeration enumeration = this.arrows.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Arrow arrow = (Arrow)this.arrows.get(string);
            arrow.selected = false;
        }
    }

    public boolean isOnArrow(int n, int n2) {
        Arrow arrow = this.getArrow(n, n2);
        return arrow != null;
    }

    public boolean isOnInfo(int n, int n2) {
        Arrow arrow = this.getArrowInfo(n, n2);
        return arrow != null;
    }

    public void displayInfo(int n, int n2) {
        Arrow arrow = this.getArrow(n, n2);
        arrow.displayInfo = true;
        this.repaint();
    }

    public void unDisplayInfo() {
        Enumeration enumeration = this.arrows.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Arrow arrow = (Arrow)this.arrows.get(string);
            if (arrow == null || !arrow.displayInfo) continue;
            arrow.displayInfo = false;
            bl = true;
        }
        this.repaint();
    }

    public void setBackground(Graphics graphics) {
        if (this.backgroundImage != null && this.backgroundImage.getWidth(this) != -1 && this.backgroundImage.getHeight(this) != -1) {
            int n = this.backgroundImage.getWidth(this);
            int n2 = this.backgroundImage.getHeight(this);
            int n3 = this.getSize().width / n + 1;
            int n4 = this.getSize().height / n2 + 1;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    graphics.drawImage(this.backgroundImage, i * n, j * n2 + 95, this);
                }
            }
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 95, this.getSize().width, this.getSize().height);
        }
    }

    public void paint(Graphics graphics) {
        try {
            this.setBackground(graphics);
            this.drawTop(graphics);
            this.drawArrows(graphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if ((mouseEvent.getModifiers() & 4) == 4) {
                if (this.isOnArrow(n, n2)) {
                    this.arrowTipTool.displayTipTool = false;
                    this.arrowTipTool = null;
                    this.displayInfo(n, n2);
                }
            } else if (this.isOnArrow(n, n2)) {
                this.selectMessage(n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.unDisplayInfo();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.isOnArrow(n2, n = mouseEvent.getY())) {
            this.showTipTool(n2, n);
        } else {
            this.unShowTipTool();
        }
    }
}

