/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.awt.List;
import java.awt.event.ItemEvent;
import tools.tracesviewer.TracesCanvas;
import tools.tracesviewer.TracesSession;
import tools.tracesviewer.TracesSessions;
import tools.tracesviewer.TracesViewer;

public class TracesSessionsList
extends List {
    protected TracesSessions tracesSessions;
    protected TracesCanvas tracesCanvas;
    protected int index = 0;

    public void setTracesCanvas(TracesCanvas tracesCanvas) {
        this.tracesCanvas = tracesCanvas;
    }

    public String getCallId(String string) {
        try {
            int n = string.indexOf("//");
            int n2 = string.indexOf("/", n + 2);
            return string.substring(n2 + 1);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String getOrigin(String string) {
        try {
            int n = string.indexOf("//");
            int n2 = string.indexOf("/", 2);
            String string2 = string.substring(2, n2);
            if (string2.equals(TracesViewer.stackId)) {
                return "the proxy";
            }
            return "a user agent (" + string2 + ")";
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public void setTracesSessions(TracesSessions tracesSessions) {
        this.removeAll();
        this.tracesSessions = tracesSessions;
        for (int i = 0; i < tracesSessions.size(); ++i) {
            TracesSession tracesSession = (TracesSession)tracesSessions.elementAt(i);
            String string = tracesSession.getName();
            String string2 = tracesSession.getLogDescription();
            String string3 = this.getCallId(string);
            String string4 = this.getOrigin(string);
            if (string.equals("No available session, refresh")) {
                this.add(string);
                continue;
            }
            if (string2 == null || string2.trim().equals("")) {
                this.add("Trace " + (i + 1) + " from " + string4 + "; callId: " + string3);
                continue;
            }
            this.add("Trace " + (i + 1) + " from " + string2 + "; callId: " + string3);
        }
        if (tracesSessions.size() != 0) {
            this.select(0);
        }
    }

    public void updateTracesCanvas() {
        if (this.tracesSessions == null || this.tracesSessions.isEmpty()) {
            return;
        }
        TracesSession tracesSession = (TracesSession)this.tracesSessions.firstElement();
        String string = tracesSession.getName();
        String string2 = tracesSession.getLogDescription();
        String string3 = this.getCallId(string);
        String string4 = this.getOrigin(string);
        if (string.equals("No available session, refresh")) {
            this.tracesCanvas.refreshTracesCanvas(tracesSession, "unknown");
        } else if (string2 == null || string2.trim().equals("")) {
            this.tracesCanvas.refreshTracesCanvas(tracesSession, string4);
        } else {
            this.tracesCanvas.refreshTracesCanvas(tracesSession, string2);
        }
    }

    public void updateTracesCanvas(ItemEvent itemEvent) {
        if (this.tracesSessions == null || this.tracesSessions.isEmpty()) {
            return;
        }
        this.index = (Integer)itemEvent.getItem();
        TracesSession tracesSession = (TracesSession)this.tracesSessions.elementAt(this.index);
        String string = tracesSession.getName();
        String string2 = tracesSession.getLogDescription();
        String string3 = this.getCallId(string);
        String string4 = this.getOrigin(string);
        if (string.equals("No available session, refresh")) {
            this.tracesCanvas.refreshTracesCanvas(tracesSession, "unknown");
        } else if (string2 == null || string2.trim().equals("")) {
            this.tracesCanvas.refreshTracesCanvas(tracesSession, string4);
        } else {
            System.out.println("logDesc33:" + string2);
            this.tracesCanvas.refreshTracesCanvas(tracesSession, string2);
        }
    }
}

