/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.AlertInfo;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.ErrorInfo;
import gov.nist.javax.sip.header.ErrorInfoList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.InReplyTo;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.Priority;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.ProxyAuthorization;
import gov.nist.javax.sip.header.ProxyRequire;
import gov.nist.javax.sip.header.ProxyRequireList;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPETag;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.SIPIfMatch;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Subject;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Unsupported;
import gov.nist.javax.sip.header.UserAgent;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.header.Warning;
import gov.nist.javax.sip.message.HeaderIterator;
import gov.nist.javax.sip.message.ListMap;
import gov.nist.javax.sip.message.MessageObject;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.ParserFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentEncodingHeader;
import javax.sip.header.ContentLanguageHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;

public abstract class SIPMessage
extends MessageObject
implements Message {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected LinkedList unrecognizedHeaders = new LinkedList();
    protected LinkedList headers = new LinkedList();
    protected From fromHeader;
    protected To toHeader;
    protected CSeq cSeqHeader;
    protected CallID callIdHeader;
    protected ContentLength contentLengthHeader;
    protected MaxForwards maxForwardsHeader;
    protected int size;
    private String messageContent;
    private byte[] messageContentBytes;
    private Object messageContentObject;
    private Hashtable nameTable = new Hashtable();

    public static boolean isRequestHeader(SIPHeader sipHeader) {
        return sipHeader instanceof AlertInfo || sipHeader instanceof InReplyTo || sipHeader instanceof Authorization || sipHeader instanceof MaxForwards || sipHeader instanceof UserAgent || sipHeader instanceof Priority || sipHeader instanceof ProxyAuthorization || sipHeader instanceof ProxyRequire || sipHeader instanceof ProxyRequireList || sipHeader instanceof Route || sipHeader instanceof RouteList || sipHeader instanceof Subject || sipHeader instanceof SIPIfMatch;
    }

    public static boolean isResponseHeader(SIPHeader sipHeader) {
        return sipHeader instanceof ErrorInfo || sipHeader instanceof ProxyAuthenticate || sipHeader instanceof Server || sipHeader instanceof Unsupported || sipHeader instanceof RetryAfter || sipHeader instanceof Warning || sipHeader instanceof WWWAuthenticate || sipHeader instanceof SIPETag || sipHeader instanceof RSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getMessageAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        LinkedList linkedList = this.headers;
        synchronized (linkedList) {
            ListIterator li = this.headers.listIterator();
            while (li.hasNext()) {
                SIPHeader sipHeader = (SIPHeader)li.next();
                if (sipHeader instanceof SIPHeaderList) {
                    SIPHeaderList shl = (SIPHeaderList)sipHeader;
                    retval.addAll(shl.getHeadersAsEncodedStrings());
                    continue;
                }
                retval.add(sipHeader.encode());
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeSIPHeaders() {
        StringBuffer encoding = new StringBuffer();
        LinkedList linkedList = this.headers;
        synchronized (linkedList) {
            ListIterator it = this.headers.listIterator();
            while (it.hasNext()) {
                SIPHeader siphdr = (SIPHeader)it.next();
                if (siphdr instanceof ContentLength) continue;
                encoding.append(siphdr.encode());
            }
        }
        return encoding.append(this.contentLengthHeader.encode()).append("\r\n").toString();
    }

    public abstract String encodeMessage();

    public abstract String getDialogId(boolean var1);

    public boolean match(Object other) {
        if (other == null) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage matchObj = (SIPMessage)other;
        ListIterator li = matchObj.getHeaders();
        while (li.hasNext()) {
            SIPHeader hisHeaders = (SIPHeader)li.next();
            LinkedList myHeaders = this.getHeaderList(hisHeaders.getHeaderName());
            if (myHeaders == null || myHeaders.size() == 0) {
                return false;
            }
            if (hisHeaders instanceof SIPHeaderList) {
                ListIterator outerIterator = ((SIPHeaderList)hisHeaders).listIterator();
                while (outerIterator.hasNext()) {
                    SIPHeader hisHeader = (SIPHeader)outerIterator.next();
                    ListIterator innerIterator = myHeaders.listIterator();
                    boolean found = false;
                    while (innerIterator.hasNext()) {
                        SIPHeader myHeader = (SIPHeader)innerIterator.next();
                        if (!myHeader.match(hisHeader)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                continue;
            }
            SIPHeader hisHeader = hisHeaders;
            ListIterator innerIterator = myHeaders.listIterator();
            boolean found = false;
            while (innerIterator.hasNext()) {
                SIPHeader myHeader = (SIPHeader)innerIterator.next();
                if (!myHeader.match(hisHeader)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void merge(Object template) {
        if (!template.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad class " + template.getClass());
        }
        SIPMessage templateMessage = (SIPMessage)template;
        Object[] templateHeaders = templateMessage.headers.toArray();
        for (int i = 0; i < templateHeaders.length; ++i) {
            SIPHeader hdr = (SIPHeader)templateHeaders[i];
            String hdrName = hdr.getHeaderName();
            LinkedList myHdrs = this.getHeaderList(hdrName);
            if (myHdrs == null) {
                this.attachHeader(hdr);
                continue;
            }
            ListIterator it = myHdrs.listIterator();
            while (it.hasNext()) {
                SIPHeader sipHdr = (SIPHeader)it.next();
                sipHdr.merge(hdr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        StringBuffer encoding = new StringBuffer();
        LinkedList linkedList = this.headers;
        synchronized (linkedList) {
            ListIterator it = this.headers.listIterator();
            while (it.hasNext()) {
                SIPHeader siphdr = (SIPHeader)it.next();
                if (siphdr instanceof ContentLength) continue;
                encoding.append(siphdr.encode());
            }
        }
        encoding.append(this.contentLengthHeader.encode()).append("\r\n");
        if (this.messageContentObject != null) {
            String mbody = this.getContent().toString();
            encoding.append(mbody);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            String content = null;
            try {
                content = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                content = "";
            }
            encoding.append(content);
        }
        return encoding.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeAsBytes() {
        StringBuffer encoding = new StringBuffer();
        LinkedList linkedList = this.headers;
        synchronized (linkedList) {
            ListIterator it = this.headers.listIterator();
            while (it.hasNext()) {
                SIPHeader siphdr = (SIPHeader)it.next();
                if (siphdr instanceof ContentLength) continue;
                encoding.append(siphdr.encode());
            }
        }
        encoding.append(this.contentLengthHeader.encode()).append("\r\n");
        byte[] retval = null;
        byte[] content = this.getRawContent();
        if (content != null) {
            byte[] msgarray = null;
            try {
                msgarray = encoding.toString().getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
            retval = new byte[msgarray.length + content.length];
            System.arraycopy(msgarray, 0, retval, 0, msgarray.length);
            System.arraycopy(content, 0, retval, msgarray.length, content.length);
        } else {
            try {
                retval = encoding.toString().getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        return retval;
    }

    public Object clone() {
        SIPMessage retval = (SIPMessage)super.clone();
        retval.nameTable = new Hashtable();
        retval.fromHeader = null;
        retval.toHeader = null;
        retval.cSeqHeader = null;
        retval.callIdHeader = null;
        retval.contentLengthHeader = null;
        retval.maxForwardsHeader = null;
        if (this.headers != null) {
            retval.headers = new LinkedList();
            Iterator iter = this.headers.iterator();
            while (iter.hasNext()) {
                SIPHeader hdr = (SIPHeader)iter.next();
                retval.attachHeader((SIPHeader)hdr.clone());
            }
        }
        if (this.messageContentBytes != null) {
            retval.messageContentBytes = (byte[])this.messageContentBytes.clone();
        }
        if (this.messageContentObject != null) {
            retval.messageContentObject = SIPMessage.makeClone(this.messageContentObject);
        }
        return retval;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        this.sprint("SIPMessage:");
        this.sprint("{");
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Class<?> fieldType = f.getType();
                String fieldName = f.getName();
                if (f.get(this) == null || !Class.forName("gov.nist.javax.sip.header.SIPHeader").isAssignableFrom(fieldType) || fieldName.compareTo("headers") == 0) continue;
                this.sprint(fieldName + "=");
                this.sprint(((SIPHeader)f.get(this)).debugDump());
            }
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
        this.sprint("List of headers : ");
        this.sprint(this.headers.toString());
        this.sprint("messageContent = ");
        this.sprint("{");
        this.sprint(this.messageContent);
        this.sprint("}");
        if (this.getContent() != null) {
            this.sprint(this.getContent().toString());
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public SIPMessage() {
        try {
            this.attachHeader(new ContentLength(0), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attachHeader(SIPHeader h) {
        if (h == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList hl;
            if (h instanceof SIPHeaderList && (hl = (SIPHeaderList)h).isEmpty()) {
                return;
            }
            this.attachHeader(h, false, false);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            // empty catch block
        }
    }

    public void setHeader(Header sipHeader) {
        SIPHeader header = (SIPHeader)sipHeader;
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList hl;
            if (header instanceof SIPHeaderList && (hl = (SIPHeaderList)header).isEmpty()) {
                return;
            }
            this.removeHeader(header.getHeaderName());
            this.attachHeader(header, true, false);
        }
        catch (SIPDuplicateHeaderException ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public void setHeaders(List headers) {
        ListIterator listIterator = headers.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)listIterator.next();
            try {
                this.attachHeader(sipHeader, false);
            }
            catch (SIPDuplicateHeaderException ex) {}
        }
    }

    public void attachHeader(SIPHeader h, boolean replaceflag) throws SIPDuplicateHeaderException {
        this.attachHeader(h, replaceflag, false);
    }

    public void attachHeader(SIPHeader header, boolean replaceFlag, boolean top) throws SIPDuplicateHeaderException {
        SIPHeader h;
        if (header == null) {
            throw new NullPointerException("null header");
        }
        if (ListMap.hasList(header) && !SIPHeaderList.class.isAssignableFrom(header.getClass())) {
            SIPHeaderList hdrList = ListMap.getList(header);
            hdrList.add(header);
            h = hdrList;
        } else {
            h = header;
        }
        if (replaceFlag) {
            this.nameTable.remove(header.getName().toLowerCase());
        } else if (this.nameTable.containsKey(header.getName().toLowerCase()) && !(h instanceof SIPHeaderList)) {
            if (h instanceof ContentLength) {
                try {
                    ContentLength cl = (ContentLength)header;
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
                catch (InvalidArgumentException e) {
                    // empty catch block
                }
            }
            return;
        }
        SIPHeader originalHeader = (SIPHeader)this.getHeader(header.getName());
        if (originalHeader != null) {
            ListIterator li = this.headers.listIterator();
            while (li.hasNext()) {
                SIPHeader next = (SIPHeader)li.next();
                if (!next.equals(originalHeader)) continue;
                li.remove();
            }
        }
        if (this.getHeader(header.getName()) == null) {
            this.nameTable.put(header.getName().toLowerCase(), h);
            this.headers.add(h);
        } else if (h instanceof SIPHeaderList) {
            SIPHeaderList hdrlist = (SIPHeaderList)this.nameTable.get(header.getName().toLowerCase());
            if (hdrlist != null) {
                hdrlist.concatenate((SIPHeaderList)h, top);
            } else {
                this.nameTable.put(h.getName().toLowerCase(), h);
            }
        } else {
            this.nameTable.put(h.getName().toLowerCase(), h);
        }
        if (h instanceof From) {
            this.fromHeader = (From)h;
        } else if (h instanceof ContentLength) {
            this.contentLengthHeader = (ContentLength)h;
        } else if (h instanceof To) {
            this.toHeader = (To)h;
        } else if (h instanceof CSeq) {
            this.cSeqHeader = (CSeq)h;
        } else if (h instanceof CallID) {
            this.callIdHeader = (CallID)h;
        } else if (h instanceof MaxForwards) {
            this.maxForwardsHeader = (MaxForwards)h;
        }
    }

    public void removeHeader(String headerName, boolean top) {
        SIPHeader toRemove = (SIPHeader)this.nameTable.get(headerName.toLowerCase());
        if (toRemove == null) {
            return;
        }
        if (toRemove instanceof SIPHeaderList) {
            SIPHeaderList hdrList = (SIPHeaderList)toRemove;
            if (top) {
                hdrList.removeFirst();
            } else {
                hdrList.removeLast();
            }
            if (hdrList.isEmpty()) {
                ListIterator li = this.headers.listIterator();
                while (li.hasNext()) {
                    SIPHeader sipHeader = (SIPHeader)li.next();
                    if (!sipHeader.getName().equalsIgnoreCase(headerName)) continue;
                    li.remove();
                }
                this.nameTable.remove(headerName.toLowerCase());
            }
        } else {
            this.nameTable.remove(headerName.toLowerCase());
            if (toRemove instanceof From) {
                this.fromHeader = null;
            } else if (toRemove instanceof To) {
                this.toHeader = null;
            } else if (toRemove instanceof CSeq) {
                this.cSeqHeader = null;
            } else if (toRemove instanceof CallID) {
                this.callIdHeader = null;
            } else if (toRemove instanceof MaxForwards) {
                this.maxForwardsHeader = null;
            } else if (toRemove instanceof ContentLength) {
                this.contentLengthHeader = null;
            }
            ListIterator li = this.headers.listIterator();
            while (li.hasNext()) {
                SIPHeader sipHeader = (SIPHeader)li.next();
                if (!sipHeader.getName().equalsIgnoreCase(headerName)) continue;
                li.remove();
            }
        }
    }

    public void removeHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null arg");
        }
        SIPHeader toRemove = (SIPHeader)this.nameTable.get(headerName.toLowerCase());
        if (toRemove == null) {
            return;
        }
        this.nameTable.remove(headerName.toLowerCase());
        if (toRemove instanceof From) {
            this.fromHeader = null;
        } else if (toRemove instanceof To) {
            this.toHeader = null;
        } else if (toRemove instanceof CSeq) {
            this.cSeqHeader = null;
        } else if (toRemove instanceof CallID) {
            this.callIdHeader = null;
        } else if (toRemove instanceof MaxForwards) {
            this.maxForwardsHeader = null;
        } else if (toRemove instanceof ContentLength) {
            this.contentLengthHeader = null;
        }
        ListIterator li = this.headers.listIterator();
        while (li.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)li.next();
            if (!sipHeader.getName().equalsIgnoreCase(headerName)) continue;
            li.remove();
        }
    }

    public String getTransactionId() {
        Via topVia = null;
        if (!this.getViaHeaders().isEmpty()) {
            topVia = (Via)this.getViaHeaders().getFirst();
        }
        if (topVia.getBranch() != null && topVia.getBranch().toUpperCase().startsWith("z9hG4bK".toUpperCase())) {
            if (this.getCSeq().getMethod().equals("CANCEL")) {
                return (topVia.getBranch() + ":" + this.getCSeq().getMethod()).toLowerCase();
            }
            return topVia.getBranch().toLowerCase();
        }
        StringBuffer retval = new StringBuffer();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        String hpFrom = from.getUserAtHostPort();
        retval.append(hpFrom).append(":");
        if (from.hasTag()) {
            retval.append(from.getTag()).append(":");
        }
        String hpTo = to.getUserAtHostPort();
        retval.append(hpTo).append(":");
        String cid = this.callIdHeader.getCallId();
        retval.append(cid).append(":");
        retval.append(this.cSeqHeader.getSequenceNumber()).append(":").append(this.cSeqHeader.getMethod());
        if (topVia != null) {
            retval.append(":").append(topVia.getSentBy().encode());
            if (!topVia.getSentBy().hasPort()) {
                retval.append(":").append(5060);
            }
        }
        String hc = Utils.toHexString(retval.toString().toLowerCase().getBytes());
        return new Integer(hc.hashCode()).toString();
    }

    public int hashCode() {
        if (this.callIdHeader == null) {
            throw new RuntimeException("Invalid message! Cannot compute hashcode!! ");
        }
        return this.callIdHeader.getCallId().hashCode();
    }

    public boolean hasContent() {
        return this.messageContent != null || this.messageContentBytes != null;
    }

    public ListIterator getHeaders() {
        return this.headers.listIterator();
    }

    public Header getHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("bad name");
        }
        SIPHeader sipHeader = (SIPHeader)this.nameTable.get(headerName.toLowerCase());
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).getFirst();
        }
        return sipHeader;
    }

    public ContentType getContentTypeHeader() {
        return (ContentType)this.getHeader("Content-Type");
    }

    public FromHeader getFrom() {
        return this.fromHeader;
    }

    public ErrorInfoList getErrorInfoHeaders() {
        return (ErrorInfoList)this.getSIPHeaderList("Error-Info");
    }

    public ContactList getContactHeaders() {
        return (ContactList)this.getSIPHeaderList("Contact");
    }

    public Contact getContactHeader() {
        ContactList clist = this.getContactHeaders();
        if (clist != null) {
            return (Contact)clist.getFirst();
        }
        return null;
    }

    public ViaList getViaHeaders() {
        return (ViaList)this.getSIPHeaderList("Via");
    }

    public void setVia(List viaList) {
        ViaList vList = new ViaList();
        ListIterator it = viaList.listIterator();
        while (it.hasNext()) {
            Via via = (Via)it.next();
            vList.add(via);
        }
        this.setHeader(vList);
    }

    public void setHeader(SIPHeaderList sipHeaderList) {
        this.setHeader((Header)sipHeaderList);
    }

    public Via getTopmostVia() {
        if (this.getViaHeaders() == null) {
            return null;
        }
        return (Via)this.getViaHeaders().getFirst();
    }

    public CSeqHeader getCSeq() {
        return this.cSeqHeader;
    }

    public Authorization getAuthorization() {
        return (Authorization)this.getHeader("Authorization");
    }

    public MaxForwardsHeader getMaxForwards() {
        return this.maxForwardsHeader;
    }

    public void setMaxForwards(MaxForwardsHeader maxForwards) {
        this.setHeader(maxForwards);
    }

    public RouteList getRouteHeaders() {
        return (RouteList)this.getSIPHeaderList("Route");
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    public void setCallId(CallIdHeader callId) {
        this.setHeader(callId);
    }

    public void setCallId(String callId) throws ParseException {
        if (this.callIdHeader == null) {
            this.setHeader(new CallID());
        }
        this.callIdHeader.setCallId(callId);
    }

    public RecordRouteList getRecordRouteHeaders() {
        return (RecordRouteList)this.getSIPHeaderList("Record-Route");
    }

    public ToHeader getTo() {
        return this.toHeader;
    }

    public void setTo(ToHeader to) {
        this.setHeader(to);
    }

    public void setFrom(FromHeader from) {
        this.setHeader(from);
    }

    public ContentLengthHeader getContentLength() {
        return this.contentLengthHeader;
    }

    public String getMessageContent() throws UnsupportedEncodingException {
        if (this.messageContent == null && this.messageContentBytes == null) {
            return null;
        }
        if (this.messageContent == null) {
            String charset;
            ContentType contentTypeHeader = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
            this.messageContent = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? new String(this.messageContentBytes, charset) : new String(this.messageContentBytes, DEFAULT_ENCODING)) : new String(this.messageContentBytes, DEFAULT_ENCODING);
        }
        return this.messageContent;
    }

    public byte[] getRawContent() {
        try {
            if (this.messageContent == null && this.messageContentBytes == null && this.messageContentObject == null) {
                return null;
            }
            if (this.messageContentObject != null) {
                String charset;
                String messageContent = this.messageContentObject.toString();
                ContentType contentTypeHeader = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
                byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? messageContent.getBytes(charset) : messageContent.getBytes(DEFAULT_ENCODING)) : messageContent.getBytes(DEFAULT_ENCODING);
                return messageContentBytes;
            }
            if (this.messageContent != null) {
                String charset;
                ContentType contentTypeHeader = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
                byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? this.messageContent.getBytes(charset) : this.messageContent.getBytes(DEFAULT_ENCODING)) : this.messageContent.getBytes(DEFAULT_ENCODING);
                return messageContentBytes;
            }
            return this.messageContentBytes;
        }
        catch (UnsupportedEncodingException ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    public void setMessageContent(String type, String subType, String messageContent) {
        if (messageContent == null) {
            throw new IllegalArgumentException("messgeContent is null");
        }
        ContentType ct = new ContentType(type, subType);
        this.setHeader(ct);
        this.messageContent = messageContent;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        this.computeContentLength(messageContent);
    }

    public void setContent(Object content, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        this.setHeader(contentTypeHeader);
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        this.computeContentLength(content);
    }

    public Object getContent() {
        if (this.messageContentObject != null) {
            return this.messageContentObject;
        }
        if (this.messageContentBytes != null) {
            return this.messageContentBytes;
        }
        if (this.messageContent != null) {
            return this.messageContent;
        }
        return null;
    }

    public void setMessageContent(String type, String subType, byte[] messageContent) {
        ContentType ct = new ContentType(type, subType);
        this.setHeader(ct);
        this.setMessageContent(messageContent);
        this.computeContentLength(messageContent);
    }

    public void setMessageContent(String content) {
        this.computeContentLength(content);
        this.messageContent = content;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content) {
        this.computeContentLength(content);
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    private void computeContentLength(Object content) {
        int length = 0;
        if (content != null) {
            if (content instanceof String) {
                String charset = null;
                ContentType contentTypeHeader = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
                if (contentTypeHeader != null) {
                    charset = contentTypeHeader.getCharset();
                }
                if (charset == null) {
                    charset = DEFAULT_ENCODING;
                }
                try {
                    length = ((String)content).getBytes(charset).length;
                }
                catch (UnsupportedEncodingException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            } else {
                length = content instanceof byte[] ? ((byte[])content).length : content.toString().length();
            }
        }
        try {
            this.contentLengthHeader.setContentLength(length);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void removeContent() {
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        try {
            this.contentLengthHeader.setContentLength(0);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public ListIterator getHeaders(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null headerName");
        }
        SIPHeader sipHeader = (SIPHeader)this.nameTable.get(headerName.toLowerCase());
        if (sipHeader == null) {
            return new LinkedList().listIterator();
        }
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).listIterator();
        }
        return new HeaderIterator(this, sipHeader);
    }

    private SIPHeaderList getSIPHeaderList(String headerName) {
        return (SIPHeaderList)this.nameTable.get(headerName.toLowerCase());
    }

    private LinkedList getHeaderList(String headerName) {
        SIPHeader sipHeader = (SIPHeader)this.nameTable.get(headerName.toLowerCase());
        if (sipHeader == null) {
            return null;
        }
        if (sipHeader instanceof SIPHeaderList) {
            return (LinkedList)((SIPHeaderList)sipHeader).getHeaderList();
        }
        LinkedList<SIPHeader> ll = new LinkedList<SIPHeader>();
        ll.add(sipHeader);
        return ll;
    }

    public boolean hasHeader(String headerName) {
        return this.nameTable.containsKey(headerName.toLowerCase());
    }

    public boolean hasFromTag() {
        return this.fromHeader != null && this.fromHeader.getTag() != null;
    }

    public boolean hasToTag() {
        return this.toHeader != null && this.toHeader.getTag() != null;
    }

    public String getFromTag() {
        return this.fromHeader == null ? null : this.fromHeader.getTag();
    }

    public void setFromTag(String tag) {
        try {
            this.fromHeader.setTag(tag);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setToTag(String tag) {
        try {
            this.toHeader.setTag(tag);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getToTag() {
        return this.toHeader == null ? null : this.toHeader.getTag();
    }

    public abstract String getFirstLine();

    public void addHeader(Header sipHeader) {
        SIPHeader sh = (SIPHeader)sipHeader;
        try {
            if (sipHeader instanceof ViaHeader) {
                this.attachHeader(sh, false, true);
            } else {
                this.attachHeader(sh, false, false);
            }
        }
        catch (SIPDuplicateHeaderException ex) {
            try {
                if (sipHeader instanceof ContentLength) {
                    ContentLength cl = (ContentLength)sipHeader;
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
            }
            catch (InvalidArgumentException e) {
                // empty catch block
            }
        }
    }

    public void addUnparsed(String unparsed) {
        this.unrecognizedHeaders.add(unparsed);
    }

    public void addHeader(String sipHeader) {
        String hdrString = sipHeader.trim() + "\n";
        try {
            HeaderParser parser = ParserFactory.createParser(sipHeader);
            SIPHeader sh = parser.parse();
            this.attachHeader(sh, false);
        }
        catch (ParseException ex) {
            this.unrecognizedHeaders.add(hdrString);
        }
    }

    public ListIterator getUnrecognizedHeaders() {
        return this.unrecognizedHeaders.listIterator();
    }

    public ListIterator getHeaderNames() {
        ListIterator li = this.headers.listIterator();
        LinkedList<String> retval = new LinkedList<String>();
        while (li.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)li.next();
            String name = sipHeader.getName();
            retval.add(name);
        }
        return retval.listIterator();
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage otherMessage = (SIPMessage)other;
        Collection values = this.nameTable.values();
        Iterator it = values.iterator();
        if (this.nameTable.size() != otherMessage.nameTable.size()) {
            return false;
        }
        while (it.hasNext()) {
            SIPHeader mine = (SIPHeader)it.next();
            SIPHeader his = (SIPHeader)otherMessage.nameTable.get(mine.getName().toLowerCase());
            if (his == null) {
                return false;
            }
            if (his.equals(mine)) continue;
            return false;
        }
        return true;
    }

    public ContentDispositionHeader getContentDisposition() {
        return (ContentDispositionHeader)this.getHeader("Content-Disposition");
    }

    public ContentEncodingHeader getContentEncoding() {
        return (ContentEncodingHeader)this.getHeader("Content-Encoding");
    }

    public ContentLanguageHeader getContentLanguage() {
        return (ContentLanguageHeader)this.getHeader("Content-Language");
    }

    public ExpiresHeader getExpires() {
        return (ExpiresHeader)this.getHeader("Expires");
    }

    public void setExpires(ExpiresHeader expiresHeader) {
        this.setHeader(expiresHeader);
    }

    public void setContentDisposition(ContentDispositionHeader contentDispositionHeader) {
        this.setHeader(contentDispositionHeader);
    }

    public void setContentEncoding(ContentEncodingHeader contentEncodingHeader) {
        this.setHeader(contentEncodingHeader);
    }

    public void setContentLanguage(ContentLanguageHeader contentLanguageHeader) {
        this.setHeader(contentLanguageHeader);
    }

    public void setContentLength(ContentLengthHeader contentLength) {
        try {
            this.contentLengthHeader.setContentLength(contentLength.getContentLength());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void addLast(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, false);
        }
        catch (SIPDuplicateHeaderException ex) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    public void addFirst(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, true);
        }
        catch (SIPDuplicateHeaderException ex) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    public void removeFirst(String headerName) throws NullPointerException {
        if (headerName == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(headerName, true);
    }

    public void removeLast(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(headerName, false);
    }

    public void setCSeq(CSeqHeader cseqHeader) {
        this.setHeader(cseqHeader);
    }

    public abstract void setSIPVersion(String var1) throws ParseException;

    public abstract String getSIPVersion();

    public abstract String toString();
}

