/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.ParseException;
import javax.net.ssl.SSLSocket;
import javax.sip.address.Hop;

public final class TLSMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable {
    private SSLSocket mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private String key;
    protected boolean isCached;
    protected boolean isRunning;
    private Thread mythread;
    private String myAddress;
    private int myPort;
    private InetAddress peerAddress;
    private int peerPort;
    private String peerProtocol;
    protected int useCount = 0;
    private TLSMessageProcessor tlsMessageProcessor;
    private SIPTransactionStack sipStack;

    protected TLSMessageChannel(SSLSocket sock, SIPTransactionStack sipStack, TLSMessageProcessor msgProcessor) throws IOException {
        if (sipStack.isLoggingEnabled()) {
            sipStack.logWriter.logDebug("creating new TLSMessageChannel ");
            sipStack.logWriter.logStackTrace();
        }
        this.mySock = sock;
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIPAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TLSMessageChannelThread");
        this.sipStack = sipStack;
        this.tlsMessageProcessor = msgProcessor;
        this.myPort = this.tlsMessageProcessor.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TLSMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TLSMessageProcessor messageProcessor) throws IOException {
        if (sipStack.isLoggingEnabled()) {
            sipStack.logWriter.logDebug("creating new TLSMessageChannel ");
            sipStack.logWriter.logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TLS";
        this.sipStack = sipStack;
        this.tlsMessageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIPAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        this.messageProcessor = messageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        block4: {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Closing message Channel " + this);
                }
            }
            catch (IOException ex) {
                if (!this.sipStack.isLoggingEnabled()) break block4;
                this.sipStack.logWriter.logDebug("Error closing socket " + ex);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "tls";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean retry) throws IOException {
        SSLSocket sock = (SSLSocket)this.sipStack.ioHandler.sendBytes(this.getMessageProcessor().getIPAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, retry);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setName("TLSMessageChannelThread");
            thread.start();
        }
    }

    public void sendMessage(SIPMessage sipMessage) throws IOException {
        byte[] msg = sipMessage.encodeAsBytes();
        long time = System.currentTimeMillis();
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        if (this.sipStack.serverLog.needsLogging(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        SSLSocket sock = (SSLSocket)this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIPAddress(), receiverAddress, receiverPort, "TLS", message, retry);
        if (sock != this.mySock && sock != null) {
            try {
                if (this.mySock != null) {
                    this.mySock.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.mySock = sock;
            this.myClientInputStream = this.mySock.getInputStream();
            Thread mythread = new Thread(this);
            mythread.setDaemon(true);
            mythread.setName("TLSMessageChannelThread");
            mythread.start();
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            this.sipStack.getLogWriter().logDebug("Encountered bad message \n" + message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(SIPMessage sipMessage) throws Exception {
        block31: {
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = sipMessage.encode();
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logError("bad message " + badmsg);
                    this.sipStack.logWriter.logError(">>> Dropped Bad Msg");
                }
                return;
            }
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                this.peerPort = hop.getPort();
                this.peerProtocol = v.getTransport();
                try {
                    this.peerAddress = this.mySock.getInetAddress();
                    if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        v.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    v.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (!this.isCached) {
                    ((TLSMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                    this.isCached = true;
                    String key = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                    this.sipStack.ioHandler.putSocket(key, this.mySock);
                }
            }
            long receptionTime = System.currentTimeMillis();
            if (sipMessage instanceof SIPRequest) {
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("----Processing Message---");
                }
                if (this.sipStack.serverLog.needsLogging(16)) {
                    this.sipStack.serverLog.logMessage(sipMessage, this.getPeerHostPort().toString(), this.messageProcessor.getIPAddress().getHostAddress() + ":" + this.messageProcessor.getPort(), false, receptionTime);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sipResponse = sipRequest.createResponse(513);
                    byte[] resp = sipResponse.encodeAsBytes();
                    this.sendMessage(resp, false);
                    throw new Exception("Message size exceeded");
                }
                ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest != null) {
                    SIPServerTransaction sipServerTx2;
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        Object var9_15 = null;
                    }
                    catch (Throwable throwable) {
                        SIPServerTransaction sipServerTx2;
                        Object var9_16 = null;
                        if (sipServerRequest instanceof SIPTransaction && !(sipServerTx2 = (SIPServerTransaction)sipServerRequest).passToListener()) {
                            ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        }
                        throw throwable;
                    }
                    if (sipServerRequest instanceof SIPTransaction && !(sipServerTx2 = (SIPServerTransaction)sipServerRequest).passToListener()) {
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                    }
                    break block31;
                }
                SIPResponse response = sipRequest.createResponse(503);
                response.addHeader(this.sipStack.createServerHeaderForStack());
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    response.setHeader(retryAfter);
                    this.sendMessage(response);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sipStack.logWriter.logWarning("Dropping message -- could not acquire semaphore");
                break block31;
            }
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            if (sipResponse.getStatusCode() == 100) {
                sipResponse.getTo().removeParameter("tag");
            }
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logError("Dropping Badly formatted response message >>> " + sipResponse);
                }
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Message size exceeded");
                }
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                try {
                    sipServerResponse.processResponse(sipResponse, this);
                    Object var12_22 = null;
                }
                catch (Throwable throwable) {
                    Object var12_23 = null;
                    if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    }
                    throw throwable;
                }
                if (sipServerResponse instanceof SIPTransaction && !((SIPTransaction)((Object)sipServerResponse)).passToListener()) {
                    ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                }
                break block31;
            }
            this.sipStack.logWriter.logWarning("Could not get semaphore... dropping response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Pipeline hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.timer);
        this.myParser = new PipelinedMsgParser(this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        int bufferSize = 4096;
        ++this.tlsMessageProcessor.useCount;
        this.isRunning = true;
        try {
            while (true) {
                int nbytes;
                byte[] msg;
                try {
                    msg = new byte[bufferSize];
                    nbytes = this.myClientInputStream.read(msg, 0, bufferSize);
                    if (nbytes == -1) {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TLSMessageProcessor tLSMessageProcessor = this.tlsMessageProcessor;
                                synchronized (tLSMessageProcessor) {
                                    --this.tlsMessageProcessor.nConnections;
                                    this.tlsMessageProcessor.notify();
                                }
                            }
                            hispipe.close();
                            this.mySock.close();
                        }
                        catch (IOException ioex) {
                        }
                        Object var10_13 = null;
                        this.isRunning = false;
                        this.tlsMessageProcessor.remove(this);
                        --this.tlsMessageProcessor.useCount;
                        return;
                    }
                }
                catch (IOException ex) {
                    try {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("IOException  closing sock " + ex);
                        }
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TLSMessageProcessor e = this.tlsMessageProcessor;
                                synchronized (e) {
                                    --this.tlsMessageProcessor.nConnections;
                                    this.tlsMessageProcessor.notify();
                                }
                            }
                            this.mySock.close();
                            hispipe.close();
                        }
                        catch (IOException ioex) {}
                    }
                    catch (Exception ex1) {
                    }
                    Object var10_14 = null;
                    this.isRunning = false;
                    this.tlsMessageProcessor.remove(this);
                    --this.tlsMessageProcessor.useCount;
                    return;
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                    continue;
                }
                {
                    hispipe.write(msg, 0, nbytes);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.isRunning = false;
            this.tlsMessageProcessor.remove(this);
            --this.tlsMessageProcessor.useCount;
            throw throwable;
        }
    }

    protected void uncache() {
        this.tlsMessageProcessor.remove(this);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TLSMessageChannel that = (TLSMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return true;
    }
}

