/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sip.address.URI;
import jp.ac.naka.ec.TreeNode;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.entity.EntityType;
import net.sourceforge.jsdp.SessionDescription;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityContainerImpl
extends EntityImpl
implements EntityContainer {
    protected Map<String, EntityListener> table;
    private static Logger logger = Logger.getLogger(EntityContainerImpl.class);
    private TupleSpaceAdapter dispatcher = TupleSpaceAdapter.getInstance();

    public EntityContainerImpl() {
        this.table = new HashMap<String, EntityListener>();
        this.setEntityType(EntityType.CONTAINER);
    }

    public EntityContainerImpl(String name) {
        this();
        this.setName(name);
    }

    public EntityContainerImpl(String name, EntityContainer con) {
        super(con);
        this.setName(name);
        this.table = new HashMap<String, EntityListener>();
        Map temp = con.getEntryTable();
        for (Object key : temp.keySet()) {
            this.table.put((String)key, (EntityListener)temp.get(key));
        }
        this.addEntry(con.getURI(), con);
        EntityEvent evt = new EntityEvent(con, this, EntityEvent.EventType.ADD);
        this.dispatcher.dispatchEvent(evt);
    }

    @Override
    public void addEntity(Entity e) {
        EntityContainerImpl target;
        super.addChild(e);
        this.addEntry(e.getURI(), e);
        EntityContainer entityContainer = target = this.getParent() != null ? (EntityContainer)this.getParent() : this;
        if (target == null) {
            return;
        }
        EntityEvent evt = new EntityEvent(target, e, EntityEvent.EventType.ADD);
        evt.setBroadcast(true);
        this.dispatcher.dispatchEvent(evt);
    }

    @Override
    public EntityContainer getContainer(String uri) {
        if (uri.equals(this.getURI().toString())) {
            return this;
        }
        if (this.hasParent()) {
            EntityContainer con = this.getContainer();
            if (con.getURI().equals(uri)) {
                return con;
            }
        } else {
            Entity e = this.getEntity(uri);
            if (e instanceof EntityContainer) {
                EntityContainer con = (EntityContainer)e;
                return con;
            }
        }
        return null;
    }

    @Override
    public Set<Entity> getEntities() {
        if (this.isLocal()) {
            Set<String> keys = this.table.keySet();
            HashSet<Entity> entities = new HashSet<Entity>();
            for (String key : keys) {
                entities.add((Entity)this.table.get(key));
            }
            return entities;
        }
        Set<TreeNode> nodes = super.getChildNodes();
        HashSet<Entity> entities = new HashSet<Entity>();
        for (TreeNode node : nodes) {
            entities.add((Entity)node);
        }
        return entities;
    }

    @Override
    public Set<Entity> getEntitiesByLocation(String location) {
        return null;
    }

    @Override
    public Entity getEntity(String sip_uri) {
        Entity entity = (Entity)this.table.get(sip_uri);
        return entity;
    }

    @Override
    public void receiveMessage(EntityEvent e) {
        if (!this.isLocal()) {
            return;
        }
        switch (e.getEventType()) {
            case MESSAGE: {
                this.procMessage(e);
                break;
            }
            case INIT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException((Object)((Object)e.getEventType()) + " is not Supported.");
            }
        }
    }

    @Override
    public void receiveAck(EntityEvent evt) {
    }

    private void procMessage(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        if (e.isBroadcast() || target.equals(this)) {
            for (TreeNode node : this.getChildNodes()) {
                EntityListener listener = (EntityListener)((Object)node);
                listener.receiveMessage(e);
            }
            return;
        }
        for (TreeNode node : this.getChildNodes()) {
            Entity entity;
            if (!(node instanceof Entity) || !(entity = (Entity)node).equals(target)) continue;
            entity.receiveMessage(e);
        }
    }

    @Override
    public SessionDescription receiveOffer(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Set<TreeNode> nodes = this.getChildNodes();
        SessionDescription sdp = null;
        Entity entity = null;
        for (TreeNode node : nodes) {
            entity = (Entity)node;
            if (!entity.equals(target)) continue;
            sdp = entity.receiveOffer(e);
            break;
        }
        if (sdp == null) {
            return null;
        }
        Entity source = (Entity)e.getSource();
        EntityEvent evt = new EntityEvent(sdp, (EntityListener)source, entity);
        evt.setEventType(EntityEvent.EventType.ANSWER);
        evt.setRequest(e.getRequest());
        TupleSpaceAdapter dispatcher = TupleSpaceAdapter.getInstance();
        dispatcher.dispatchEvent(evt);
        return null;
    }

    @Override
    public void receiveAnswer(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Set<TreeNode> nodes = this.getChildNodes();
        for (TreeNode node : nodes) {
            Entity entity = (Entity)node;
            if (!entity.equals(target)) continue;
            entity.receiveAnswer(e);
            break;
        }
    }

    @Override
    public void receiveBye(EntityEvent e) {
        Entity target = (Entity)e.getTarget();
        Set<TreeNode> nodes = this.getChildNodes();
        Entity entity = null;
        for (TreeNode node : nodes) {
            entity = (Entity)node;
            if (!entity.equals(target)) continue;
            entity.receiveBye(e);
            break;
        }
    }

    @Override
    public void addedNewEntity(EntityEvent evt) {
        if (evt.getSource().equals(this)) {
            return;
        }
        switch (evt.getEventType()) {
            case REGISTER: {
                EntityContainer e = (EntityContainer)evt.getSource();
                logger.info((Object)("Add External EntityContainer :" + e.getURI()));
                this.addEntry(e.getURI(), e);
                break;
            }
            case ADD: {
                if (!(evt.getSource() instanceof Entity)) break;
                Entity source = (Entity)evt.getSource();
                this.addEntry(source.getURI(), source);
                logger.info((Object)("Add Entity :" + source.getURI()));
                this.informToEntities();
                break;
            }
            case SUBSCRIBE: 
            case NOTIFY: {
                Entity[] entities;
                Entity[] entityArray = entities = (Entity[])evt.getSource();
                int n = 0;
                int n2 = entityArray.length;
                while (n < n2) {
                    Entity entity = entityArray[n];
                    if (!this.table.containsKey(entity.getURI().toString()) && !entity.equals(this)) {
                        this.addEntry(entity.getURI(), entity);
                        logger.info((Object)("Add External Entity :" + entity.getURI()));
                        this.informToEntities();
                    }
                    ++n;
                }
                break;
            }
        }
    }

    private void informToEntities() {
    }

    private void addEntry(URI uri, EntityListener listener) {
        this.table.put(uri.toString(), listener);
    }

    private boolean removeEntry(String name) {
        return this.table.remove(name) != null;
    }

    @Override
    public Map getEntryTable() {
        return this.table;
    }

    @Override
    public void setParent(TreeNode node) {
        if (this.getParent() == null) {
            super.setParent(node);
            if (!this.isLocal()) {
                return;
            }
            EntityEvent evt = new EntityEvent((EntityListener)((Object)node), this, EntityEvent.EventType.INIT);
            this.dispatcher.dispatchEvent(evt);
        } else {
            Entity entity = (Entity)node;
            this.addEntry(entity.getURI(), entity);
            super.setParent(node);
        }
    }

    @Override
    public boolean removeChild(TreeNode node) {
        if (node instanceof EntityContainer) {
            EntityContainer con = (EntityContainer)node;
            Set<Entity> entities = con.getEntities();
            for (Entity entity : entities) {
                this.removeEntry(entity.getURI().toString());
                con.removeChild(entity);
                entity = null;
            }
            this.removeEntry(con.getURI().toString());
            con = null;
        } else {
            Entity entity = (Entity)node;
            this.removeEntry(entity.getURI().toString());
            Object var2_3 = null;
        }
        return true;
    }

    @Override
    public boolean include(TreeNode node) {
        Entity e = (Entity)node;
        return this.table.containsKey(e.getURI().toString());
    }
}

