/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.log4j.Logger;

class RegisterDelegate
extends MethodDelegate {
    private static Logger logger = Logger.getLogger(RegisterDelegate.class);
    public static int default_expires = 3600;

    public RegisterDelegate() {
        this.core = SipCore.getInstance();
        this.dispatcher = EntityEventDispatcher.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        try {
            ToHeader to = (ToHeader)req.getHeader("To");
            ContactHeader contact = (ContactHeader)req.getHeader("Contact");
            ExpiresHeader expiresHeader = (ExpiresHeader)req.getHeader("Expires");
            int expires = expiresHeader.getExpires();
            if (contact.getParameter("expires") != null) {
                String t = contact.getParameter("expires");
                expires = Integer.valueOf(t);
            }
            int ret = this.registration(to, contact, expires);
            switch (ret) {
                case 200: {
                    break;
                }
                case 401: 
                case 403: 
                case 404: 
                case 423: 
                case 500: {
                    this.core.sendResponse(ret, req);
                }
            }
            Address addr = contact.getAddress();
            this.core.sendResponse(200, evt, addr.getURI().toString());
            EntityContainerImpl con = new EntityContainerImpl();
            con.setName(addr.getDisplayName());
            con.setURI(addr.getURI());
            con.setLocal(false);
            EntityEvent e = new EntityEvent(con);
            e.setEventType(EntityEvent.EventType.REGISTER);
            this.dispatcher.dispatchEvent(e);
        }
        catch (Exception e) {
            logger.warn((Object)"Error occures while processing REGISTER :", (Throwable)e);
            return false;
        }
        return true;
    }

    private int registration(ToHeader to, ContactHeader contact, int expires) {
        return 200;
    }
}

