/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.sip.ListeningPoint;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.Connector;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityException;
import jp.ac.naka.ec.sip.DefaultListener;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.log4j.Logger;

public class SipConnector
implements Connector {
    private final String pathname = "gov.nist";
    private SipCore core;
    private SipListener listener = new DefaultListener();
    private EntityContainer con;
    private static Logger logger = Logger.getLogger(SipConnector.class);
    public static String transport = "udp";
    public static int defaultExpires = 360000;
    public static int minimumExpires = 60;
    File entityDir;

    public SipConnector(String user_name, String hostname, int sip_port, String sip_config) throws SipException, IOException {
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName("gov.nist");
        Properties prop = new Properties();
        prop.load(new FileInputStream(sip_config));
        SipStack sipStack = null;
        sipStack = sipFactory.createSipStack(prop);
        try {
            AddressFactory addressFactory = sipFactory.createAddressFactory();
            SipURI uri = addressFactory.createSipURI(user_name, String.valueOf(hostname) + ":" + sip_port);
            logger.info((Object)("getHostAddress:\t" + uri.toString()));
            ListeningPoint lp = sipStack.createListeningPoint(hostname, sip_port, "udp");
            SipProvider sipProvider = sipStack.createSipProvider(lp);
            sipProvider.addSipListener(this.listener);
            this.core = SipCore.getInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SipException(ex.getMessage());
        }
    }

    public void setEntityContainer(EntityContainer con) {
        this.con = con;
    }

    public boolean send(EntityEvent evt) throws EntityException {
        Entity target = (Entity)evt.getTarget();
        Entity source = (Entity)evt.getSource();
        boolean flag = false;
        if (target == null) {
            throw new EntityException("Target is null");
        }
        if (target.isLocal()) {
            return flag;
        }
        if (evt.isBroadcast()) {
            for (Entity entity : this.con.getEntities()) {
                if (!(entity instanceof EntityContainer) || entity.isLocal()) continue;
                switch (evt.getEventType()) {
                    case MESSAGE: {
                        try {
                            logger.info((Object)("Sending SIP MESSAGE to " + entity.getURI()));
                            this.core.sendRequest(evt.getMessage(), (EntityContainer)entity, source, "MESSAGE");
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Error while sending SIP message", (Throwable)e);
                            return false;
                        }
                        flag = true;
                        break;
                    }
                    default: {
                        logger.warn((Object)"not inplemented");
                    }
                }
            }
        } else {
            try {
                switch (evt.getEventType()) {
                    case REGISTER: {
                        logger.info((Object)("Sending REGISTER to " + target.getURI()));
                        this.core.sendRequest((EntityContainer)target, "REGISTER");
                        break;
                    }
                    case MESSAGE: {
                        logger.info((Object)("Sending MESSAGE to " + target.getURI()));
                        this.core.sendRequest(evt.getMessage(), target, source, "MESSAGE");
                        flag = true;
                        break;
                    }
                    case OFFER: {
                        logger.info((Object)("Sending INVITE to " + target.getURI() + evt.getSessionDescription()));
                        this.core.sendRequest(evt.getSessionDescription().toString(), target, source, "INVITE");
                        flag = true;
                        break;
                    }
                    case BYE: {
                        logger.info((Object)("Sending BYE to " + target.getURI()));
                        this.core.sendRequest("", target, source, "BYE");
                        flag = true;
                        break;
                    }
                    default: {
                        logger.warn((Object)("not inplemented EventType operation:" + (Object)((Object)evt.getEventType())));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Error while sending SIP message", (Throwable)e);
                return false;
            }
        }
        return flag;
    }
}

