/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


package jp.ac.naka.ec.db;

import java.sql.Timestamp;

import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.serial.SensorData;

/**
 * 
 * @author Takashi Kasuya
 *
 */
public class DataObjectImpl implements DataObject {

	private EntityType type = EntityType.SENSOR;
	private SensorData data;
	private String other_data;
	private Entity source;
	private Entity target;
	private Timestamp timestamp;
	private Location location;
	
	/**
	 * 
	 * @param type
	 * @param data
	 * @param source
	 * @param target
	 */
	public DataObjectImpl(EntityType type, SensorData data, Entity source, Entity target, Location location) {
		this.type = type;
		this.data = data;
		this.source = source;
		this.target = target;
		this.location = location;
	}
	
	public DataObjectImpl (EntityType type, String data, Entity source, Entity target, Location location) {
		this(type, (SensorData)null, source, target, location);
		this.other_data = data;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getDataType()
	 */
	public EntityType getDataType() {
		return this.type;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getEventSource()
	 */
	public Entity getEventSource() {
		return source;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getEventTarget()
	 */
	public Entity getEventTarget() {
		return target;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getOtherData()
	 */
	public String getOtherData() {
		return other_data;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getSensorData()
	 */
	public SensorData getSensorData() {
		return data;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getTimeStamp()
	 */
	public Timestamp getTimeStamp() {
		return timestamp;
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.db.DataObject#getLocation()
	 */
	public Location getLocation () {
		return location;
	}
}
