/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.entity.RequestMessage;
import jp.ac.naka.ec.serial.MoxaSensorData;

/**
 * Cxg\邾EntityBeXgpB
 * @author Takashi Kasuya
 *
 */
public class RequestMethodDumper extends AbstractEntity {

	JTextArea field;

	JFrame frame;

	@Override
	public void init() {
		frame = new JFrame("MethodDumper");
		frame.setSize(200, 200);
		field = new JTextArea();
		frame.getContentPane().add(new JScrollPane(field));
		frame.setVisible(true);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setEntityType(EntityType.ACTUATOR);
	}


	@Override
	public void receiveMessage(EntityEvent e) {
		StringBuilder st = new StringBuilder();
		st.append(field.getText());
		st.append(e.getMessage() + "\n");
		field.setText(st.toString());
	}
	
	/*
	public void forwardInvocation(RequestMessage message) {
		StringBuilder st = new StringBuilder();
		st.append(field.getText());
		st.append(message.getMethod() + " :");
		Object[] params = message.getParamList();
		if (params != null) {
			for (int i = 0; i < params.length; i++) {
				String str = params[i].toString();
				st.append(str);
				if (params.length != i) {
					st.append(", ");
				}
			}
		}
		st.append("\n");
		field.setText(st.toString());
	}
	
	// <message><method>sensor</method><paramList><param><Integer>4</Integer></param><param><String>29.4</String></param><param><Integer>2</Integer></param><param><Integer>2420</Integer></param><param><Long>1163634781390</Long></param></paramList></message>
	public void output (int type, String value, int addr, int panId, long timestamp) {
		MoxaSensorData data = new MoxaSensorData(type, value, addr, panId, timestamp);
		StringBuilder st = new StringBuilder();
		st.append(field.getText());
		st.append("\n" + data.toString());
		//System.out.println(data.toString());
		field.setText(st.toString());
	}*/
}
