/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.sip;

import gov.nist.javax.sip.header.From;

import java.util.ArrayList;
import java.util.List;

import javax.sip.RequestEvent;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.xml.parsers.ParserConfigurationException;

import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.entity.EntityEvent.EventType;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFParser;
import jp.ac.naka.ec.sip.pidf.PIDFParserImpl;
import jp.ac.naka.ec.sip.pidf.Tuple;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.xml.sax.SAXException;

/**
 * @author Takashi Kasuya
 * 
 */
class MessageDelegate extends MethodDelegate {
	private static Logger logger = Logger.getLogger(MessageDelegate.class);
	PIDFParser parser = PIDFParserImpl.getInatance();
	
	public MessageDelegate() throws ParserConfigurationException, SAXException {
		PropertyConfigurator.configure(Main.log4j_properties);
		dispatcher = TupleSpaceAdapter.getInstance();
		core = SipCore.getInstance();
	}

	/*
	 * (non-Javadoc)
	 * @see jp.ac.naka.ec.sip.MethodDelegate#forward(javax.sip.RequestEvent)
	 */
	public boolean forward(RequestEvent evt) {
		Request req = evt.getRequest();

		byte[] content = req.getRawContent();
		ToHeader to = (ToHeader) req.getHeader(ToHeader.NAME);
		SipURI toUri = (SipURI) to.getAddress().getURI();
		// ContactHeader from =
		// (ContactHeader)req.getHeader(ContactHeader.NAME);
		FromHeader from = (FromHeader) req.getHeader(From.NAME);
		SipURI fromUri = (SipURI) from.getAddress().getURI();
		ContentTypeHeader content_type = (ContentTypeHeader) req
				.getHeader(ContentTypeHeader.NAME);
		try {
			Entity source = new EntityImpl(fromUri);
			source.setLocal(false);
			Entity target = new EntityImpl(toUri);
			String message = new String(content, "UTF-8");
			EntityEvent e = null;
			if (content_type.getContentType().equals("text")
					&& content_type.getContentSubType().equals("plain")) {
				e = new EntityEvent(message, target, source);
			} else if (content_type.getContentType().equals(
					PIDFData.CONTENT_TYPE)
					&& content_type.getContentSubType().equals(
							PIDFData.CONTENT_SUBTYPE)) {
				PIDFData data = parser.parse(content);
				Entity[] entities = makeEntitiesFromPIDF(data);
				e = new EntityEvent(entities);
				e.setEventType(EventType.ADD);
			} else {
				throw new IllegalArgumentException(
						"Can not handle ContentType :" + content_type);
			}
			dispatcher.dispatchEvent(e);

			// 200 OK
			core.sendResponse(Response.OK, req);
		} catch (Exception e) {
			logger.warn("Error occures while processing SIP Message :", e);
			return false;
		}
		return true;
	}
}
