/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.flash;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import jp.ac.naka.ec.EventSource;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.plugin.flash.FlashXMLParser;
import jp.ac.naka.ec.plugin.flash.FlashXMLParserImpl;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class FlashXMLSocketServer
extends EventSource
implements Runnable {
    private static Logger logger = Logger.getLogger(FlashXMLSocketServer.class);
    private List<FlashClient> clients = new ArrayList<FlashClient>();
    private int port = 4444;
    private ServerSocket server;
    private FlashXMLParser parser;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
    List<FlashClient> errors = new ArrayList<FlashClient>();

    public void init(EntityContainer source, Properties properties) throws Exception {
        String t = properties.getProperty("port");
        if (t != null && !t.equals("")) {
            this.port = Integer.parseInt(t);
        }
        if ((t = properties.getProperty("parser")) != null && !t.equals("")) {
            Class<?> clz = Class.forName(t);
            this.parser = (FlashXMLParser)clz.newInstance();
        } else {
            this.parser = new FlashXMLParserImpl();
        }
        this.parser.setEventSource((Entity)source);
        this.server = new ServerSocket(this.port);
        Thread th = new Thread(this);
        th.start();
        logger.info((Object)("Start Flash XMLSocket Server on port:" + this.port));
    }

    public void receiveMessage(EntityEvent evt) {
        logger.info((Object)("receive message :" + evt.getMessage()));
        StringBuilder sb = new StringBuilder();
        sb.append("<event><data>");
        sb.append(evt.getMessage());
        sb.append("</data>");
        sb.append("<source>");
        sb.append(evt.getSource().toString());
        sb.append("</source>");
        Date currentTime_1 = new Date();
        String dateString = this.formatter.format(currentTime_1);
        sb.append("<time>");
        sb.append(dateString);
        sb.append("</time></event>");
        this.errors.clear();
        for (FlashClient fc : this.clients) {
            try {
                fc.sendMessage(sb.toString());
            }
            catch (IOException e) {
                logger.error((Object)("write error on Client IP: " + fc.getInetAddress().getHostAddress() + ". disconnected."));
                fc.stopClient();
                this.errors.add(fc);
            }
        }
        for (FlashClient fc : this.errors) {
            this.clients.remove(fc);
            fc = null;
        }
    }

    public void run() {
        block11: {
            try {
                try {
                    while (true) {
                        Socket sock = this.server.accept();
                        FlashClient fc = new FlashClient(sock);
                        logger.info((Object)("Connectd to Flash XMLSocket Server :" + sock.getInetAddress().getHostAddress()));
                        fc.start();
                        this.clients.add(fc);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Error while connecting Flash client.", (Throwable)e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.server.close();
                    for (FlashClient fc : this.clients) {
                        fc.stopClient();
                        fc = null;
                    }
                    this.clients.clear();
                }
                catch (IOException fc) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        try {
            this.server.close();
            for (FlashClient fc : this.clients) {
                fc.stopClient();
                fc = null;
            }
            this.clients.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void dispatchEvent(EntityEvent evt) {
        if (evt.isBroadcast()) {
            logger.info((Object)"Dispatch Event by broadcast.");
        } else {
            logger.info((Object)("Dispatch Event to " + evt.getTarget()));
        }
        this.getEventDispatcher().dispatchEvent(evt);
    }

    public static void main(String[] args) {
        try {
            PropertyConfigurator.configure((String)"./config/log4j.properties");
            new FlashXMLSocketServer().init((EntityContainer)new EntityContainerImpl(), new Properties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FlashClient
    extends Thread {
        BufferedReader in = null;
        PrintWriter out = null;
        Socket sock;

        public FlashClient(Socket sock) throws IOException {
            this.sock = sock;
            this.in = new BufferedReader(new InputStreamReader(sock.getInputStream(), "UTF8"));
            this.out = new PrintWriter(new OutputStreamWriter(sock.getOutputStream(), "UTF8"));
        }

        public InetAddress getInetAddress() {
            return this.sock.getInetAddress();
        }

        public void sendMessage(String msg) throws IOException {
            this.out.print(String.valueOf(msg) + "\u0000");
            if (this.out.checkError()) {
                throw new IOException();
            }
        }

        public void run() {
            try {
                try {
                    char[] c = new char[1];
                    while (this.in.read(c, 0, 1) != -1) {
                        StringBuilder sb = new StringBuilder(4096);
                        while (c[0] != '\u0000') {
                            sb.append(c[0]);
                            this.in.read(c, 0, 1);
                        }
                        String str = new String(sb.toString().getBytes(), "SJIS");
                        EntityEvent evt = FlashXMLSocketServer.this.parser.parseXML(str);
                        if (evt != null) {
                            FlashXMLSocketServer.this.dispatchEvent(evt);
                            continue;
                        }
                        logger.info((Object)("Invalid messge :" + sb.toString()));
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Read error on Client IP: " + this.sock.getInetAddress().getHostAddress()), (Throwable)e);
                }
            }
            finally {
                this.stopClient();
            }
        }

        private void stopClient() {
            this.interrupt();
        }
    }
}

