/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.util;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.util.InvalidValueException;

public class TypedTime
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7152238446184328783L;
    public static final String DAYS = "d";
    public static final String HOURS = "h";
    public static final String MINUTES = "m";
    public static final String SECONDS = "s";
    private static final Hashtable units = new Hashtable(4);
    protected long time;

    protected TypedTime() {
    }

    public TypedTime(long time) {
        this.setTime(time);
    }

    public TypedTime(String input) throws InvalidValueException {
        Matcher matcher = Pattern.compile("((-){0,1}[1-9](\\d)*)|0").matcher(input);
        if (matcher.lookingAt()) {
            String t = matcher.group();
            String modifier = input.substring(t.length());
            if (modifier.length() > 0) {
                Long multiplier = (Long)units.get(modifier);
                if (multiplier == null) {
                    throw new InvalidValueException("Unknown multiplier");
                }
                this.time = multiplier * Long.parseLong(t);
            } else {
                this.time = Long.parseLong(t);
            }
        }
    }

    public Object clone() {
        TypedTime object = new TypedTime();
        object.time = this.time;
        return object;
    }

    public long getTime() {
        return this.time;
    }

    public static long getTime(String input) throws InvalidValueException {
        long parsedTime = 0L;
        Matcher matcher = Pattern.compile("((-){0,1}[1-9](\\d)*)|0").matcher(input);
        if (matcher.lookingAt()) {
            String t = matcher.group();
            String modifier = input.substring(t.length());
            if (modifier.length() > 0) {
                Long multiplier = (Long)units.get(modifier);
                if (multiplier == null) {
                    throw new InvalidValueException("Unknown multiplier");
                }
                parsedTime = multiplier * Long.parseLong(t);
            } else {
                parsedTime = Long.parseLong(t);
            }
        }
        return parsedTime;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public static String toString(long time) {
        StringBuffer result = new StringBuffer();
        if (time == 0L) {
            result.append("0");
        } else if (time % 86400L == 0L) {
            result.append(time / 86400L);
            result.append(DAYS);
        } else if (time % 3600L == 0L) {
            result.append(time / 3600L);
            result.append(HOURS);
        } else if (time % 60L == 0L) {
            result.append(time / 60L);
            result.append(MINUTES);
        } else {
            result.append(time);
        }
        return result.toString();
    }

    public String toString() {
        return TypedTime.toString(this.time);
    }

    static {
        units.put(DAYS, new Long(86400L));
        units.put(HOURS, new Long(3600L));
        units.put(MINUTES, new Long(60L));
        units.put(SECONDS, new Long(1L));
    }
}

