/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.Configuration;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.Plugin;
import jp.ac.naka.ec.PluginClassLoader;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityCollaborator
extends EntityImpl {
    private static Log logger = LogFactory.getLog(EntityCollaborator.class);
    private EntityContainer container;
    private static EntityCollaborator instance = new EntityCollaborator();
    private ArrayList<Plugin> plugins = new ArrayList();
    private EventDispatcher dispatcher;
    public static String sip_properties = "config/sip.properties";
    public static String log4j_properties = "config/log4j.properties";
    public static String base = ".";

    static {
        PropertyConfigurator.configure((String)(String.valueOf(base) + "/" + log4j_properties));
    }

    private EntityCollaborator() {
    }

    public static EntityCollaborator getInstance() {
        SipCore core = SipCore.getInstance();
        try {
            core.initialize(String.valueOf(base) + "/" + sip_properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Error while initiating SIP setting.", (Throwable)e);
        }
        instance.init(null, core);
        return instance;
    }

    public static EntityCollaborator getInstance(Configuration config) {
        SipCore core = SipCore.getInstance();
        try {
            core.initialize(String.valueOf(base) + "/" + sip_properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Error while initiating SIP setting.", (Throwable)e);
        }
        instance.init(config, core);
        return instance;
    }

    public static EntityCollaborator getInstance(int port) {
        SipCore core = SipCore.getInstance();
        try {
            core.initialize(port, String.valueOf(base) + "/" + sip_properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)"Error while initiating SIP setting.", (Throwable)e);
        }
        instance.init(null, core);
        return instance;
    }

    private void init(Configuration config, SipCore core) {
        this.dispatcher = TupleSpaceAdapter.getInstance();
        PropertyConfigurator.configure((String)(String.valueOf(base) + "/" + log4j_properties));
        this.container = new EntityContainerImpl(core.getURI());
        core.setEntityContainer(this.container);
        this.dispatcher.addEntityListener(this.container);
    }

    private static void loadJars(String base) throws IOException {
        File[] jars;
        File folder = new File("lib");
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdir();
        }
        File[] fileArray = jars = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.getName().equals("CVS")) {
                    return false;
                }
                return pathname.getName().indexOf(".jar") != -1;
            }
        });
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File jar = fileArray[n];
            String jarfile = jar.getAbsolutePath();
            PluginClassLoader.addJarFile(jarfile);
            ++n;
        }
    }

    public void setParentNode(EntityContainer node) {
        this.container.setParent(node);
    }

    public void setParentURI(String uri) {
        SipCore core = SipCore.getInstance();
        SipURI sip_uri = core.createURI(uri);
        EntityContainerImpl parent = new EntityContainerImpl(sip_uri);
        this.container.setParent(parent);
    }

    public boolean hasParentNode() {
        return this.container.hasParent();
    }

    public void addEntity(Entity e) {
        SipCore core = SipCore.getInstance();
        String host = core.getURI().getHost();
        int port = core.getURI().getPort();
        String name = e.getName();
        name = name != null ? name : e.getClass().getSimpleName();
        SipURI e_uri = core.createURI("sip:" + name + "@" + host + ":" + port);
        e.setParent(this.container);
        e.setURI(e_uri);
        e.setName(name);
        Location location = this.container.getLocation();
        if (location != null) {
            e.setLocation(location);
        }
        this.container.addEntity(e);
    }

    public Set<Entity> getEntities() {
        return this.container.getEntities();
    }

    public boolean addPlugin(Plugin plugin) {
        String name = plugin.getPluginName();
        name = name != null ? name : plugin.getClass().getSimpleName();
        SipCore core = SipCore.getInstance();
        String host = core.getURI().getHost();
        int port = core.getURI().getPort();
        SipURI uri = core.createURI("sip:" + name + "@" + host + ":" + port);
        plugin.setURI(uri);
        try {
            plugin.init(this.container);
            this.dispatcher.addEntityListener(plugin);
            this.plugins.add(plugin);
            logger.info((Object)("Added new Plugin " + name + " successfully."));
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)("Error while adding Plugin :" + name), (Throwable)e);
            return false;
        }
    }

    public Set<Plugin> getPlugins() {
        HashSet<Plugin> set = new HashSet<Plugin>();
        Iterator<Plugin> iter = this.plugins.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }
}

